/*
 * Decompiled with CFR 0.152.
 */
import emsl.inch.InchPanel;
import emsl.objects.DocumentSize;
import java.awt.Color;
import java.awt.Rectangle;

public class PagePanel
extends InchPanel {
    private InchPanel contentPanel;
    private DocumentSize documentSize;

    public PagePanel() {
        this.setLayout(null);
        this.setPageBorder(2);
        this.setDocumentSize(new DocumentSize());
    }

    public InchPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(InchPanel inchPanel) {
        if (this.contentPanel != null) {
            this.remove(this.contentPanel);
        }
        this.contentPanel = inchPanel;
        this.add(this.contentPanel);
        this.layoutPage();
    }

    public void setDocumentSize(DocumentSize documentSize) {
        this.documentSize = (DocumentSize)documentSize.clone();
        this.layoutPage();
    }

    public DocumentSize getDocumentSize() {
        return (DocumentSize)this.documentSize.clone();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.getContentPanel().setBackground(color);
        this.getContentPanel().layoutPage();
        if (!this.isPageBorder()) {
            this.getParent().setBackground(color);
        }
    }

    public void setViewScale(int n) {
        super.setViewScale(n);
        if (this.contentPanel != null) {
            this.contentPanel.setViewScale(n);
        }
        this.layoutPage();
    }

    public void setContentBorder(int n) {
        if (this.contentPanel == null) {
            return;
        }
        this.contentPanel.setBorder(n);
        this.layoutPage();
    }

    public int getContentBorder() {
        if (this.contentPanel == null) {
            return 0;
        }
        return this.contentPanel.getBorder();
    }

    public void setPageBorder(int n) {
        this.setBorder(n);
    }

    public int getPageBorder() {
        return this.getBorder();
    }

    public boolean isPageBorder() {
        return this.getPageBorder() != 0;
    }

    public void layoutPage() {
        int n = this.documentSize.getPageWidth();
        int n2 = this.documentSize.getPageHeight();
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        this.setInchBounds(rectangle);
        this.updateBounds();
        if (this.contentPanel == null) {
            return;
        }
        int n3 = this.documentSize.getLeftMargin();
        int n4 = this.documentSize.getRightMargin();
        int n5 = this.documentSize.getTopMargin();
        int n6 = this.documentSize.getBottomMargin();
        rectangle = new Rectangle(n3, n5, 0, 0);
        rectangle.width = n - n3 - n4;
        rectangle.height = n2 - n5 - n6;
        this.contentPanel.setViewScale(this.getViewScale());
        Rectangle rectangle2 = this.contentPanel.getInchBounds();
        this.contentPanel.setInchBounds(rectangle);
        this.contentPanel.updateBounds();
        if (!rectangle2.equals(rectangle)) {
            this.contentPanel.layoutPage();
        }
        this.repaint();
    }
}

