/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIFrame;
import emsl.awt.GUIIcon;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUITextField;
import emsl.system.UndoGroup;
import emsl.text.TextBook;
import emsl.text.TextCursor;
import emsl.text.TextData;
import emsl.text.TextPanel;
import emsl.text.TextSelector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GUIFind
extends GUIDialogueBox
implements ActionListener {
    private GUIFrame parent;
    private TextPanel textPanel;
    private GUITextField findTextField;
    private GUITextField replaceTextField;
    private GUILabelPanel replacePanel;
    private GUIButton close;
    private GUIButton find;
    private GUIButton replace;
    private GUIButton replaceAll;
    private GUIChoice ignoreCase;
    private GUIButton startAgain;
    private GUIIcon label;
    private boolean isFind;

    public GUIFind(GUIFrame gUIFrame, TextPanel textPanel) {
        super(gUIFrame, "Find", true);
        this.parent = gUIFrame;
        ((Component)this).setSize(new Dimension(500, 300));
        this.setModal(false);
        this.textPanel = textPanel;
        this.createDialogueBox();
    }

    private void createDialogueBox() {
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new GridLayout(4, 0));
        this.findTextField = new GUITextField(0);
        this.replaceTextField = new GUITextField(0);
        this.findTextField.addActionListener(this);
        this.replaceTextField.addActionListener(this);
        GUILabelPanel gUILabelPanel = new GUILabelPanel((Component)this.findTextField, "Find", 100);
        gUILabelPanel.setBehaviour(3);
        this.replacePanel = new GUILabelPanel((Component)this.replaceTextField, "Replace", 100);
        this.replacePanel.setBehaviour(3);
        gUIPanel.add(gUILabelPanel);
        gUIPanel.add(this.replacePanel);
        this.label = new GUIIcon(new Dimension(400, 28), "");
        gUIPanel.add(this.label);
        GUIPanel gUIPanel2 = new GUIPanel(new Dimension(500, -2));
        gUIPanel.add(gUIPanel2);
        this.ignoreCase = new GUIChoice(new Dimension(150, 28), "Case Insensitive,Case Sensitive");
        gUIPanel2.add(this.ignoreCase);
        this.startAgain = new GUIButton(new Dimension(150, 28), "Start at Beginning");
        gUIPanel2.add(this.startAgain);
        this.startAgain.addActionListener(this);
        this.close = this.addExitButton("Close", false);
        this.setWindowCloseButton(this.close);
        this.replaceAll = this.addExitButton("Replace All", false);
        this.replace = this.addExitButton("Replace", true);
        this.find = this.addExitButton("Find", true);
    }

    public void findDisplay() {
        this.setTitle("Find...");
        this.replaceAll.getParent().setVisible(false);
        this.replace.getParent().setVisible(false);
        this.replacePanel.setVisible(false);
        this.isFind = true;
        this.label.setText("");
        this.display();
    }

    public void replaceDisplay() {
        this.setTitle("Find and Replace...");
        this.replaceAll.getParent().setVisible(true);
        this.replace.getParent().setVisible(true);
        this.replacePanel.setVisible(true);
        this.label.setText("");
        this.isFind = false;
        this.display();
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        if (gUIButton == this.find || gUIButton == this.replace || gUIButton == this.replaceAll) {
            UndoGroup undoGroup = this.textPanel.getTextUndo().getUndoGroup("Replace");
            if (gUIButton == this.find) {
                this.find();
            }
            if (gUIButton == this.replace) {
                this.replace(undoGroup);
            }
            if (gUIButton == this.replaceAll) {
                this.replaceAll(undoGroup);
            }
            this.textPanel.getTextUndo().setUndoGroup(undoGroup);
            this.textPanel.sendActionEvent("UpdateMenus");
            return false;
        }
        return super.exitButtonPressed(gUIButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.findTextField) {
            this.find();
        }
        if (object == this.replaceTextField) {
            this.find();
        }
        if (object == this.startAgain) {
            this.startAtBeginning();
        }
    }

    private boolean find() {
        TextData textData = this.textPanel.getTextData();
        TextSelector textSelector = this.textPanel.getTextSelector();
        textSelector.selectionOff();
        String string = textData.getString();
        String string2 = this.findTextField.getText();
        if (string2.equals("")) {
            return false;
        }
        if (this.ignoreCase.getText().startsWith("Case Insensitive")) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        TextCursor textCursor = this.textPanel.getTextCursor();
        int n = textCursor.getCursorPosition() + 1;
        if ((n = string.indexOf(string2, n)) == -1) {
            this.label.setText("End Of Text Reached");
            textSelector.selectionOff();
            this.textPanel.repaint();
            this.label.repaint();
            return false;
        }
        textCursor.setCursorPosition(n);
        textSelector.setSelection(n, n + string2.length() - 1);
        this.textPanel.repaint();
        this.label.setText("Text Found");
        this.label.repaint();
        return true;
    }

    private void startAtBeginning() {
        Object object;
        if (this.textPanel instanceof TextBook) {
            ((TextBook)this.textPanel).setPageNumber(1);
            object = new ActionEvent(this, 0, "TextBook Page Change");
            this.parent.actionPerformed((ActionEvent)object);
        }
        object = this.textPanel.getTextSelector();
        TextCursor textCursor = this.textPanel.getTextCursor();
        ((TextSelector)object).selectionOff();
        this.textPanel.repaint();
        textCursor.setCursorPosition(0);
    }

    private boolean replace(UndoGroup undoGroup) {
        String string = this.replaceTextField.getText();
        if (string.equals("")) {
            return false;
        }
        TextSelector textSelector = this.textPanel.getTextSelector();
        if (!textSelector.isSelected()) {
            this.find();
        }
        if (!textSelector.isSelected()) {
            return false;
        }
        this.textPanel.setMouseBusy();
        ((Component)this).setCursor(new Cursor(3));
        int n = textSelector.getSelectionStart();
        textSelector.getSelectionEnd();
        this.textPanel.insert(string, n, undoGroup);
        this.textPanel.layoutAfterChange(n);
        textSelector.setSelectionStart(n);
        textSelector.setSelectionEnd(n + string.length() - 1);
        this.textPanel.repaint();
        this.label.setText("Text Replaced");
        this.label.repaint();
        ((Component)this).setCursor(new Cursor(0));
        this.textPanel.setMouseNormal();
        return true;
    }

    private void replaceAll(UndoGroup undoGroup) {
        this.startAtBeginning();
        boolean bl = false;
        int n = 0;
        do {
            if (!(bl = this.find())) continue;
            this.replace(undoGroup);
            ++n;
        } while (bl);
        this.label.setText(n + " Occurances Found And Replaced");
        this.label.repaint();
        undoGroup.setGroupName("Replace All");
        this.startAtBeginning();
    }
}

