/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.AbstractWordFinder;
import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordNotFoundException;
import java.util.Collection;
import java.util.HashSet;

public class TeXWordFinder
extends AbstractWordFinder {
    private boolean IGNORE_COMMENTS = true;
    private HashSet user_defined_ignores = new HashSet();
    private int regex_user_defined_ignores = 0;
    public static final int STRING_EXPR = 0;
    public static final int REG_EXPR = 1;

    public TeXWordFinder(String inText) {
        super(inText);
    }

    public TeXWordFinder() {
    }

    @Override
    public Word next() {
        if (!this.hasNext()) {
            throw new WordNotFoundException("No more words found.");
        }
        this.currentWord.copy(this.nextWord);
        this.setSentenceIterator(this.currentWord);
        int i = this.currentWord.getEnd();
        boolean finished = false;
        boolean started = false;
        while (i < this.text.length() && !finished) {
            if (!started && this.isWordChar(i)) {
                this.nextWord.setStart(i++);
                started = true;
                continue;
            }
            if (started) {
                if (this.isWordChar(i)) {
                    ++i;
                    continue;
                }
                this.nextWord.setText(this.text.substring(this.nextWord.getStart(), i));
                finished = true;
                break;
            }
            int j = i;
            j = this.ignore(j, '%', '\n');
            j = this.ignore(j, "$$", "$$");
            j = this.ignore(j, '$', '$');
            j = this.ignoreUserDefined(j);
            j = this.ignore(j, "\\newcommand", "}");
            j = this.ignore(j, "\\documentclass", "}");
            j = this.ignore(j, "\\usepackage", "}");
            j = this.ignore(j, "\\newcounter{", "}");
            j = this.ignore(j, "\\setcounter{", "}");
            j = this.ignore(j, "\\addtocounter{", "}");
            j = this.ignore(j, "\\value{", "}");
            j = this.ignore(j, "\\arabic{", "}");
            j = this.ignore(j, "\\usecounter{", "}");
            j = this.ignore(j, "\\newenvironment", "}");
            j = this.ignore(j, "\\setlength", "}");
            j = this.ignore(j, "\\setkeys", "}");
            j = this.ignore(j, "\\begin{", "}");
            if (i != (j = this.ignore(j, "\\end{", "}"))) {
                i = j;
                continue;
            }
            if (i != (j = this.ignore(j, '\\'))) {
                i = j;
                continue;
            }
            ++i;
        }
        if (!started) {
            this.nextWord = null;
        } else if (!finished) {
            this.nextWord.setText(this.text.substring(this.nextWord.getStart(), i));
        }
        return this.currentWord;
    }

    public void addUserDefinedIgnores(Collection expressions, int regex) {
        this.user_defined_ignores.addAll(expressions);
        this.regex_user_defined_ignores = regex;
    }

    private int ignoreUserDefined(int i) {
        return i;
    }

    public void setIgnoreComments(boolean ignore) {
        this.IGNORE_COMMENTS = ignore;
    }
}

