/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryDichoDisk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SpellDictionaryCachedDichoDisk
extends SpellDictionaryDichoDisk {
    public static int hits = 0;
    public static int codes = 0;
    public static final String JAZZY_DIR = ".jazzy";
    public static final String PRE_CACHE_FILE_EXT = ".pre";
    private static int MAX_CACHED = 10000;
    private HashMap suggestionCache = new HashMap(MAX_CACHED);
    private String preCacheFileName;
    private String preCacheDir;

    public SpellDictionaryCachedDichoDisk(File wordList) throws FileNotFoundException, IOException {
        super(wordList);
        this.loadPreCache(wordList);
    }

    public SpellDictionaryCachedDichoDisk(File wordList, String encoding) throws FileNotFoundException, IOException {
        super(wordList, encoding);
        this.loadPreCache(wordList);
    }

    public SpellDictionaryCachedDichoDisk(File wordList, File phonetic) throws FileNotFoundException, IOException {
        super(wordList, phonetic);
        this.loadPreCache(wordList);
    }

    public SpellDictionaryCachedDichoDisk(File wordList, File phonetic, String encoding) throws FileNotFoundException, IOException {
        super(wordList, phonetic, encoding);
        this.loadPreCache(wordList);
    }

    @Override
    public void addWord(String word) {
        System.err.println("error: addWord is not implemented for SpellDictionaryCachedDichoDisk");
    }

    public void clearCache() {
        this.suggestionCache.clear();
    }

    @Override
    public List getWords(String code) {
        ++codes;
        if (this.suggestionCache.containsKey(code)) {
            ++hits;
            List list = this.getCachedList(code);
            return list;
        }
        List list = super.getWords(code);
        this.addToCache(code, list);
        return list;
    }

    private List getCachedList(String code) {
        CacheObject obj = (CacheObject)this.suggestionCache.get(code);
        obj.setRefTime();
        return obj.getSuggestionList();
    }

    private void addToCache(String code, List l) {
        String c2 = null;
        String lowestCode = null;
        long lowestTime = Long.MAX_VALUE;
        if (this.suggestionCache.size() >= MAX_CACHED) {
            for (String c2 : this.suggestionCache.keySet()) {
                CacheObject obj = (CacheObject)this.suggestionCache.get(c2);
                if (obj.getRefTime() == 0L) {
                    lowestCode = c2;
                    break;
                }
                if (lowestTime <= obj.getRefTime()) continue;
                lowestCode = c2;
                lowestTime = obj.getRefTime();
            }
            this.suggestionCache.remove(lowestCode);
        }
        this.suggestionCache.put(code, new CacheObject(l));
    }

    private void loadPreCache(File dicoFile) throws IOException {
        this.preCacheDir = String.valueOf(System.getProperty("user.home")) + "/" + JAZZY_DIR;
        this.preCacheFileName = String.valueOf(this.preCacheDir) + "/" + dicoFile.getName() + PRE_CACHE_FILE_EXT;
        File preFile = new File(this.preCacheFileName);
        if (!preFile.exists()) {
            System.err.println("No precache file");
            return;
        }
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(preFile));
        try {
            long size = in.readLong();
            int i = 0;
            while ((long)i < size) {
                String code = (String)in.readObject();
                long time = in.readLong();
                List suggestions = (List)in.readObject();
                this.suggestionCache.put(code, new CacheObject(suggestions, time));
                ++i;
            }
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        in.close();
    }

    public void saveCache() throws IOException {
        if (this.preCacheFileName == null || this.preCacheDir == null) {
            System.err.println("Precache filename has not been set.");
            return;
        }
        File preDir = new File(this.preCacheDir);
        if (!preDir.exists()) {
            preDir.mkdir();
        }
        File preFile = new File(this.preCacheFileName);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(preFile));
        Iterator it = this.suggestionCache.keySet().iterator();
        out.writeLong(this.suggestionCache.size());
        while (it.hasNext()) {
            String code = (String)it.next();
            CacheObject obj = (CacheObject)this.suggestionCache.get(code);
            out.writeObject(code);
            out.writeLong(obj.getRefTime());
            out.writeObject(obj.getSuggestionList());
        }
        out.close();
    }

    private class CacheObject
    implements Serializable {
        private List suggestions = null;
        private long refTime = 0L;

        public CacheObject(List list) {
            this.suggestions = list;
        }

        public CacheObject(List list, long time) {
            this.suggestions = list;
            this.refTime = time;
        }

        public List getSuggestionList() {
            return this.suggestions;
        }

        public void setRefTime() {
            this.refTime = System.currentTimeMillis();
        }

        public long getRefTime() {
            return this.refTime;
        }
    }
}

