/* REXX Command file C:\MyPath\DrBMW001.cmd    (generated by DrBMW.exe) */
CALL RxFuncAdd 'REXXLIBREGISTER', 'REXXLIB', 'REXXLIBREGISTER'
CALL RexxLibRegister
'@ECHO OFF'
CRLF = '0D0A'x
xx = TIME(reset)
rcSave = 0
PARSE ARG isScheduled oneTime
jobID = '001  Backup C to D'
rc = RXQUEUE( 'set', 'DRBMW1')
CALL logToHistory ' Job# '001'  -----------------------------------------------'
CALL logToHistory 'Backup Description: '|| 'Full Backup (Xcopy), archive attr. reset by ATTRIB'
CALL logToHistory 'Comment: '||'none entered'
x = DOSDEL('C:\MyPath\DrBMW.Cdr')
CALL logToHistory 'Formatting with: '||'No Formatting will be done'
SAY 'No Formatting will be done'
SAY 'BACKUP WITH Xcopy C:\* D: /h/o/t/s/e/r/v/f'
CALL logToHistory 'Copying with: '||'Xcopy C:\* D: /h/o/t/s/e/r/v/f'
'CALL Xcopy C:\* D: /h/o/t/s/e/r/v/f 1>"C:\MyPath\DrBMW.Cdr" 2>&1'
IF RC >= 3 THEN CALL copyFailed 
SAY 'Xcopy C:\* D: /h/o/t/s/e/r/v/f finished'
'Attrib -a C:\*.* /s '
IF RC >= 1 THEN CALL archiverFailed 
SAY 'Archive attribute reset'
CALL logToHistory 'Archive Attribute Processing: '||'Attrib -a C:\*.* /s '
ETIME = TRUNC(TIME(elapsed))
TMP = ETIME + 0.0000001
HH = ( TMP / 3600 ) % 1
MM = ( TMP / 60 - HH * 60 ) % 1
SS = ( TMP - ( MM * 60 ) - ( HH * 3600 ) ) % 1
TIME_FORMAT = right( HH, 2, 0 )|| "h : " || right( MM, 2, 0 )|| "m : " || right( SS, 2, 0 )|| "s "
CALL logToHistory 'Elapsed time was: 'TIME_FORMAT
IF isScheduled = 'N' THEN 
   DO 
     CALL BEEP 500,120
     CALL BEEP 600,120
     CALL BEEP 700,120
     CALL BEEP 800,120
     SAY 'Elapsed time was: 'TIME_FORMAT
     PAUSE
     CALL EventSem_Post '\SEM32\DRBMW'
   END
IF isScheduled = 'Y' THEN QUEUE jobID||'  Finished OK'
IF oneTime = 'Y' THEN 'DEL "C:\MyPath\DrBMW001.cmd"'
EXIT
/*        Routines         */
FORMATFAILED:
rcSave = RC
CALL logToHistory 'Format failed. Return code was 'rcSave
IF isScheduled = 'N' THEN 
   DO 
     CALL BEEP 400,220
     CALL BEEP 300,220
     SAY 'Format failed. Return code was 'rcSave
     PAUSE
     CALL EventSem_Post '\SEM32\DRBMW'
   END
IF isScheduled = 'Y' THEN QUEUE jobID||'  Format Cmd Failed'
IF oneTime = 'Y' THEN 'DEL "C:\MyPath\DrBMW001.cmd"'
EXIT
COPYFAILED:
rcSave = RC
CALL logToHistory 'File copy failed. Return code was 'rcSave
IF isScheduled = 'N' THEN 
   DO 
     CALL BEEP 400,220
     CALL BEEP 300,220
     SAY 'Copy command failed. Return code was 'rcSave
     PAUSE
     CALL EventSem_Post '\SEM32\DRBMW'
   END
IF isScheduled = 'Y' THEN QUEUE jobID||'  Copy Cmd failed'
IF oneTime = 'Y' THEN 'DEL "C:\MyPath\DrBMW001.cmd"'
EXIT
ARCHIVERFAILED:
rcSave = RC
CALL logToHistory 'Archive command failed. Return code was 'rcSave
IF isScheduled = 'N' THEN 
   DO 
     CALL BEEP 400,220
     CALL BEEP 300,220
     SAY 'Reset of Archive attribute failed. Return code was 'rcSave
     PAUSE
     CALL EventSem_Post '\SEM32\DRBMW'
   END
IF isScheduled = 'Y' THEN QUEUE jobID||'  Archive Cmd failed'
IF oneTime = 'Y' THEN 'DEL "C:\MyPath\DrBMW001.cmd"'
EXIT
LOGTOHISTORY:
/* timestamp data and add records to DrBMW.hst file  */
PARSE ARG logComment
today = DATE()
timeNow = TIME()
PARSE VAR timeNow hh ":" mm ":" ss
timeNow = RIGHT(hh, 2, "0") || ":" || RIGHT(mm, 2, "0") || ":" || RIGHT(ss, 2, "0")
logData = today||" "||timeNow||" "||logComment
errors = LINEOUT('C:\MyPath\DrBMW.hst', LOGDATA)
RETURN
