/*
 * File: DTBACKUP.CMD
 *
 * Program to back up the OS/2 desktop
 *
 * Bob Eager   January 2001
 *
 */

/* Get boot drive */

boot = lower(left(value('RUNWORKPLACE',,'OS2ENVIRONMENT'),2))

/* Paths used */

binp = 'f:\binp'                        /* Where to find programs */
temp = boot'\temp'                      /* Site for temporary files */
desktop = '\Desktop'                    /* Desktop directory */
recovery = boot'\recovery'              /* Recovery directory */

/* Files used */

os2     = boot'\os2\os2.ini'
os2sys  = boot'\os2\os2sys.ini'
binfile = temp'\sysbin.zip'
dtdfile = temp'\sysdtd.zip'
wccfile = temp'\syswcc.zip'
target  = recovery'\dtbackup.zip'       /* Actual backup file */

/* Other files included in recovery */

rfiles.0 = 2                            /* Number of files */
rfiles.1 = binp'\rm.exe'
rfiles.2 = binp'\unzip.exe'

/* Load REXX support */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Create temporary and recovery directories if necessary */

call SysMkDir temp
call SysMkDir recovery

/* Make the INI files visible */

'attrib -s -h' os2
'attrib -s -h' os2sys

/* Tidy old temporary files and any pre-existing target file */

call SysFileDelete binfile
call SysFileDelete dtdfile
call SysFileDelete wccfile
call SysFileDelete target

/* Back up the INI files */

'zip -9 -j' binfile os2 os2sys

/* Back up the desktop directory */

'zip -9 -r -S' dtdfile boot||desktop

/* Back up the WarpCenter configuration */

'zip -9 -j' wccfile boot'\os2\dll\dock*.cfg' boot'\os2\dll\scenter.cfg'

/* Combine all the backup files */

'zip -9 -j' target binfile dtdfile wccfile

/* Copy essential files */

do i = 1 to rfiles.0
   'copy' rfiles.i recovery
end

/* Attempt to tidy up */

call SysFileDelete binfile
call SysFileDelete dtdfile
call SysFileDelete wccfile
call SysRmDir temp

/* Hide the INI files again */

'attrib +s +h' os2
'attrib +s +h' os2sys

exit

/*--------------------------------------------------------------------------*/

/*
 * Function to translate string to lower case
 *
 */

lower: procedure

arg s
return(translate(s, xrange('a','z'), xrange('A','Z')))

/*
 * End of file: DTBACKUP.CMD
 *
 */

