program dos_get_code_page__patch;

(***************************************************************************

 Veit Kannegieser * 1998.12.20

   tested with
    PMWUNLIT 1.20
    APACK 0.94b
    APPACK.EXE

***************************************************************************)

uses
  suchedat,
  dgcp_spr;

const
  version  ='1998.12.20..1999.01.16';

  suchfolge1=#$66#$b8#$00#$03           (* MOV AX,$0300         *)
            +#$cd#$31                   (* DPMI                 *)
            +#$07                       (* POP ES               *)
            +#$19#$c0                   (* SBB EAX,EAX          *)
            +#$f6#$44#$24#$20#$01       (* CARRY ?              *)
            +#$75                       (* JNZ ..               *);

  suchfolge2=#$66#$b8#$01#$01           (* MOV AX,$0101         *)
            +#$cd#$31                   (* DPMI                 *);




procedure aendere(o:longint;b:byte);
  var
    d:file of byte;
  begin
    filemode:=2;
    assign(d,paramstr(1));
    reset(d);
    seek(d,o);
    write(d,b);
    close(d);
  end;

var
  fund1,fund2:longint;

begin
  writeln('DGCP_PAT * Veit Kannegieser * '+version);

  if (paramcount<>1)
  or (paramstr(1)='-?')
  or (paramstr(1)='/?')
   then
    begin
      writeln(textz_hilfe^);
      halt;
    end;


  fund1:=0;
  repeat
    fund1:=suche_zeichenkette_in_datei(paramstr(1),fund1,suchfolge1);

    if fund1=nicht_gefunden then
      begin
        writeln(textz_nicht_gefunden^);
        exit;
      end;

    fund2:=suche_zeichenkette_in_datei(paramstr(1),fund1,suchfolge2);
    if (fund2=nicht_gefunden)
    or (fund2-fund1>$50)        (* Abstand zu gro *)
     then
      begin
        inc(fund1,length(suchfolge1));
        continue;
      end;

    if fund2-(3+4)=suche_zeichenkette_in_datei(paramstr(1),fund2-(3+4),
      #$8b#$94#$24) (* MOV EDX,[ESP+$xxxxxxxx] *) then
      begin
        write(textz_gefunden^);
        writeln(textz_schon_geaendert^);
        exit;
      end;

    if fund2-(3+4)=suche_zeichenkette_in_datei(paramstr(1),fund2-(3+4),
      #$8b#$9c#$24) (* MOV EBX,[ESP+$xxxxxxxx] *) then
      begin
        write(textz_gefunden^);
        aendere(fund2-(3+4)+1,$94);
        writeln(textz_geaendert^);
        exit;
      end;

    (* PMWUNLITE *)
    if fund2-(3+1)=suche_zeichenkette_in_datei(paramstr(1),fund2-(3+1),
      #$8b#$54#$24) (* MOV EDX,[ESP+$xx] *) then
      begin
        write(textz_gefunden^);
        writeln(textz_schon_geaendert^);
        exit;
      end;

    if fund2-(3+1)=suche_zeichenkette_in_datei(paramstr(1),fund2-(3+1),
      #$8b#$5c#$24) (* MOV EBX,[ESP+$xxxxxxxx] *) then
      begin
        write(textz_gefunden^);
        aendere(fund2-(3+1)+1,$54);
        writeln(textz_geaendert^);
        exit;
      end;

    inc(fund1);

  until false;

end.
