extern void parse_command_line(int argc, char *argv[]);
extern void new_line(void);
extern void new_page(void);
extern void clear_line(void);
extern void put_line(void);
extern void new_line(void);
extern void normal_char(void);
extern void translate_pcl(void);
extern void next_char(void);
extern void error(char *message, int rcode);
extern void strpad(int col);
extern int column_by_dot(double number);
extern int column_by_decipoint(double number);
extern int row_by_dot(double number);
extern int row_by_decipoint(double number);
extern double get_pcl_arg(void);
extern void pcl_asterisk(void);
extern void pcl_asterisk_P(void);
extern void pcl_ampersand(void);
extern void pcl_ampersand_A(void);
extern void pcl_ampersand_D(double number);
extern void pcl_ampersand_K(double number);
extern void pcl_ampersand_L(double number);
extern void pcl_ampersand_number(double number);
extern void pcl_paren(void);
extern void pcl_paren_number(double number);
extern void pcl_paren_S(double number);
extern void position_vertical(int target_row);

/**
***  Constant and type definitions
**/

#define MAXLINE         255
#define LINEFEED        0x0A
#define FORMFEED        0x0C
#define CARRIAGE_RETURN 0x0D
#define POSITIVE        1
#define NOSIGN          0
#define NEGATIVE        -1
#define ESCAPE          27
#define DPI             300.0
#define PCL_END_SET     "ABCDEFGHIJKLMNOPQRSTUVWXYZ@"

typedef char            STRING[MAXLINE+1];

/**
***  Define global variables
**/

extern int      line_length;    /* Max length of a line */
extern short    italic_on;      /* Is italic turned on? */
extern short    bold_on;        /* Is boldface turned on? */
extern short    underscore_on;  /* Is underscore turned on? */
extern FILE     *pcl_file;      /* Input file */
extern FILE     *vba_file;      /* Output file */
extern STRING   line;           /* Buffer for holding a line */
extern char     current[2];     /* Buffer for next input character */
extern long     row;            /* Input row (or line number) */
extern int      column;         /* Input column */
extern int      lmargin;        /* Left margin */
extern int      rmargin;        /* Right margin */
extern int      underscore;     /* Is underscore on? */
extern int      italics;        /* Is italics on? */
extern int      bold;           /* Is bold on? */
extern double   pitch;          /* Pitch of the font */
extern double   lpi;            /* Lines per inch */
extern int      actual_vpos;    /* Actual line number on the output page */
extern int      logical_vpos;   /* Theoretical line number on output page */
