/**
***  This is a part of the PCL2VBA project.   This set of functions handle
***  misc data handling.
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dcfvba.h"

/* -------------------------------------------------------------------------- */

void normal_char(void)
   {
   if (strlen(line) < (size_t)line_length)
      strcat(line,current);
   return;
   }

/* -------------------------------------------------------------------------- */

void next_char(void)
   {
   if (!feof(pcl_file))
      *current = (char)fgetc(pcl_file);

      /* Convert null bytes to blanks so they do not indicate end of string */

      if (*current == '\0')
         *current = ' ';
   column++;
   }

/* -------------------------------------------------------------------------- */

double get_pcl_arg(void)
   {
   STRING real = "";  /* holder for the real number */

   while (strchr("+-.0123456789",*current) != NULL)
      {
      strcat(real,current);
      next_char();
      }
   return(atof(real));
   }

/* -------------------------------------------------------------------------- */

void translate_pcl(void)
   {
   char pcl_command;
   do
      {
      next_char();
      pcl_command = (char)toupper(*current);
      switch(pcl_command)
         {
         case '(':
         case ')':
            {
            pcl_paren();
            break;
            }
         case '&':
            {
            pcl_ampersand();
            break;
            }
         case '*':
            {
            pcl_asterisk();
            break;
            }
         case 'E':  /* Reset */
            break;
         case '9':  /* Clear margins */
            {
            lmargin = 0;
            rmargin = 0;
            break;
            }
         default:
            {
            char error_message[255];

            sprintf(error_message,"Unsupported PCL command: <Esc>(%c",*current);
            error(error_message,8);

            /* Skip over remaining characters in the PCL datastream */

            while(strchr(PCL_END_SET,*current) == NULL)
               {
               next_char();
               strcat(error_message,current);
               }
            } /* default */
         } /* switch */
      } /* do */
   while(strchr(PCL_END_SET,*current) == NULL);
   return;
   }

/* -------------------------------------------------------------------------- */

void strpad(int col)
   {
   int i;      /* loop index */
   int length; /* length of the line */

   /* Pad out the string */

   length = strlen(line);
   if (length <= col)
      for (i = length;i < col;i++)
         strcat(line," ");
   else /* Truncate the line */
      {
      if (col > 1)
         line[col-1] = '\0';
      else
         *line = '\0';
      }
   }  /* strpad */

/* -------------------------------------------------------------------------- */

void position_vertical(int target_row)
   {
   int  length;            /* length of the line */
   int  skip_lines;        /* Number of lines to skip */

   /* Save the current column number */

   length = strlen(line);

   /* Dump the current line so far */

   new_line();

   /* Skip blank lines */

   /* Adjust the logical and actual line numbers.  If there hasn't been any */
   /* negative positioning, they will be the same.   If there has been      */
   /* movement up the page, this will adjust for that as best it can.       */

   logical_vpos = target_row;

   if ((skip_lines = target_row - actual_vpos) > 0)
      fprintf(vba_file,".sk %d\n",skip_lines);

   /* Move the "cursor" back to the original column */

   strpad(length);

   }  /* position_vertical */

/* -------------------------------------------------------------------------- */

int column_by_decipoint(double number)
   {
   return((int)(number / (720.0 / pitch)));
   }

/* -------------------------------------------------------------------------- */

int column_by_dot(double number)
   {
   return((int)(number / (DPI / pitch)));
   }

/* -------------------------------------------------------------------------- */

int row_by_decipoint(double number)
   {
   return((int)(number / (720.0 / lpi)));
   }

/* -------------------------------------------------------------------------- */

int row_by_dot(double number)
   {
   return((int)(number / (DPI / lpi)));
   }

/* -------------------------------------------------------------------------- */

void error(char *message, int rcode)
   {
   fprintf(stderr,"%s at (%lu:%u): %s\n",(rcode) ? "Error" : "Warning",row,column,message);

   if (rcode)
      exit(rcode);
   }
