/*
 * Decompiled with CFR 0.152.
 */
package jef.util;

public class Throttle {
    static final int MAX_THROTTLE_STEP = 5;
    static final int MIN_THROTTLE_STEP = 1;
    static final int DEFAULT_THROTTLE_STEP = 1;
    static final int DEFAULT_TARGET_FPS = 60;
    static final int FRAMES_UNTIL_THROTTLE_RECALC = 40;
    static final int MAX_FRAME_SKIP = 5;
    static final float MAX_FPS_DEVIATION = 0.1f;
    static final boolean TRY_ALT_SKIP_CALC = true;
    static boolean throttle;
    static boolean autoFS;
    static long fps;
    static long sumFPS;
    static float avgFPS;
    static long sleep;
    static int targetFPS;
    static int throttleStep;
    static int minFPS;
    static int maxFPS;
    static long minimumSleep;
    static int fskip;
    static int frameDuration;
    static long t;
    static long tempT;
    static int frameNumber;
    static long recalcCount;
    static Thread thread;

    static {
        sumFPS = 0L;
        avgFPS = 0.0f;
        recalcCount = 0L;
    }

    public static void init(int _fps, Thread _thread) {
        targetFPS = _fps;
        thread = _thread;
        throttle = true;
        autoFS = true;
        fskip = 0;
        throttleStep = 1;
        frameNumber = 0;
        recalcCount = 0L;
        sumFPS = 0L;
        avgFPS = 0.0f;
        fps = 0L;
        String osname = System.getProperty("os.name");
        sleep = minimumSleep = (long)(osname.endsWith("NT") ? 11 : 5);
        throttleStep = 1;
        minFPS = targetFPS - (int)((float)targetFPS * 0.1f);
        if (minFPS == targetFPS) {
            minFPS = targetFPS - 1;
        }
        if ((maxFPS = targetFPS + (int)((float)targetFPS * 0.1f)) == targetFPS) {
            maxFPS = targetFPS + 1;
        }
        frameDuration = 1000 / targetFPS;
        fps = targetFPS;
        t = System.currentTimeMillis();
    }

    public static void throttle() {
        if (throttle & frameNumber % throttleStep == 0) {
            try {
                Thread.sleep(sleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (frameNumber < 40) {
            ++frameNumber;
        } else {
            frameNumber = 0;
            Throttle.recalcTiming();
        }
    }

    public static long getSleep() {
        return sleep;
    }

    public static boolean skipFrame() {
        return fskip != 0 && frameNumber % (fskip + 1) != 0;
    }

    public static void enableAutoFrameSkip(boolean enable) {
        autoFS = enable;
    }

    public static boolean isAutoFrameSkip() {
        return autoFS;
    }

    public static void enable(boolean enable) {
        throttle = enable;
    }

    public static boolean isEnabled() {
        return throttle;
    }

    public static void setFrameSkip(int skip) {
        fskip = skip;
    }

    public static int getFrameSkip() {
        return fskip;
    }

    public static int getFPS() {
        return (int)fps;
    }

    public static int getTargetFPS() {
        return targetFPS;
    }

    public static float getAverageFPS() {
        return avgFPS;
    }

    private static void recalcTiming() {
        tempT = System.currentTimeMillis();
        fps = 1000L / ((tempT - t) / 40L);
        t = tempT;
        avgFPS = (float)((int)((sumFPS += fps) * 100L / ++recalcCount)) / 100.0f;
        if (throttle) {
            if (fps < (long)minFPS) {
                if (sleep > minimumSleep) {
                    sleep -= ((long)targetFPS - fps) / (long)(targetFPS - minFPS);
                }
                if (sleep <= minimumSleep) {
                    if (++throttleStep > 5) {
                        throttleStep = 5;
                        if (autoFS) {
                            throttleStep = 1;
                            if (++fskip > 5) {
                                fskip = 5;
                                throttleStep = 5;
                            }
                        }
                    } else {
                        sleep += minimumSleep;
                    }
                }
            } else if (fps > (long)maxFPS && (sleep += (fps - (long)targetFPS) / (long)(maxFPS - targetFPS)) > (long)(1000 / targetFPS - 1)) {
                if (--throttleStep < 1) {
                    throttleStep = 1;
                    if (autoFS) {
                        throttleStep = 5;
                        if (--fskip < 0) {
                            fskip = 0;
                            throttleStep = 1;
                        }
                    }
                } else if ((sleep -= minimumSleep) < minimumSleep) {
                    sleep = minimumSleep;
                }
            }
        }
    }
}

