/*
 * Decompiled with CFR 0.152.
 */
package jef.map;

import java.util.HashMap;
import java.util.Map;
import jef.map.ReadHandler;
import jef.map.ReadMap;

public class MemoryReadAddressMap
implements ReadMap {
    int[] mem;
    Map map = new HashMap(256);
    MEMreadBanked[] BANKS = new MEMreadBanked[8];
    ReadHandler memRead = new MEMRead();
    ReadHandler[] handlers = new ReadHandler[]{this.memRead, this.memRead, this.memRead};

    public MemoryReadAddressMap(int[] mem) {
        this.mem = mem;
    }

    public void setBankAddress(int b, int address) {
        this.BANKS[b - 1].setBankAdr(address);
    }

    public void set(int from, int until, ReadHandler memRead) {
        int i = from;
        while (i <= until) {
            Integer key = new Integer(i);
            this.map.put(key, memRead);
            ++i;
        }
    }

    public void setMR(int from, int until, int readerType) {
        int i = from;
        while (i <= until) {
            ++i;
        }
    }

    public int getSize() {
        return 0;
    }

    public int read(int address) {
        ReadHandler rh = (ReadHandler)this.map.get(new Integer(address));
        if (rh == null) {
            return this.memRead.read(address);
        }
        return rh.read(address);
    }

    public int[] getMemory() {
        return this.mem;
    }

    class MEMRead
    implements ReadHandler {
        MEMRead() {
        }

        public int read(int address) {
            return MemoryReadAddressMap.this.mem[address];
        }
    }

    class MEMreadBanked
    implements ReadHandler {
        int startArea;
        int bank_address;

        public MEMreadBanked(int startArea) {
            this.startArea = startArea;
        }

        public int read(int address) {
            return MemoryReadAddressMap.this.mem[address + this.bank_address];
        }

        public void setBankAdr(int adr) {
            this.bank_address = adr - this.startArea;
        }
    }
}

