#ifndef __IOCTL_H__
#define __IOCTL_H__

#define IOCTLCAT 0x92
#define IORDMSR 0x01

#pragma pack(1)

typedef struct rdmsroncpu {
	unsigned long reg;
	unsigned short cpu;
	unsigned short tries;
} rdmsroncpu;

typedef struct msrval {
	unsigned long eax;
	unsigned long edx;
	unsigned short cpu;
	unsigned short tries;
} msrval;

/*
	Usage expample:

	rdmsroncpu req = {0};
	msrval res = {0};
	req.reg = MSR_IA32_THERM_STATUS;
	unsigned long cbParam, cbreturn;
	DosDevIOCtl(file, IOCTLCAT, IORDMSR,
			&req, sizeof(req), (PULONG)&cbParam,
			&res, sizeof(res), (PULONG)&cbreturn);
	printf("cpu = %d, eax = %08x edx = %08x\n", res.cpu, res.eax, res.edx);

*/


#pragma pack()

#endif /* __IOCTL_H__ */