#!/bin/sh
#

# There are other, simpler commands to startup the runner. The two
# commented commands good replacements. The first works well with
# Java Platform 1.1 based runtimes. The second works well with
# Java2 Platform based runtimes.

#exec jre -cp codequill.jar com.sonoransoft.codequill.CodeQuill $* &
#exec java -jar codequill.jar $* &

PRG=$0

## resolve links - $0 may be a link to  home
progname=`basename $0`

while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '.*/.*' > /dev/null; then
        PRG="$link"
    else
        PRG="`dirname $PRG`/$link"
    fi
done

CODEQUILL_DIR_1=`dirname "$PRG"`
# "Guessing CODEQUILL_DIR from codequill.sh to ${CODEQUILL_DIR_1}"
if [ -d ${CODEQUILL_DIR_1} ] ; then
    CODEQUILL_DIR=${CODEQUILL_DIR_1}
    # echo "Setting CODEQUILL_DIR to $CODEQUILL_DIR"
fi

if [ -z "$JAVA_HOME" ] ;  then
    JAVA=`which java`
    if [ -z "$JAVA" ] ; then
        echo "Cannot find JAVA. Please set your PATH."
        exit 1
    fi
    JAVA_BINDIR=`dirname $JAVA`
    JAVA_HOME=$JAVA_BINDIR/..
fi

if [ "$JAVACMD" = "" ] ; then
    JAVACMD=$JAVA_HOME/bin/java
fi

ORIG_CLASSPATH=$CLASSPATH

unset CLASSPATH
if [ "$CLASSPATH" != "" ]; then
    CLASSPATH=${CLASSPATH}:${CODEQUILL_DIR}/codequill.jar
else
    CLASSPATH=${CODEQUILL_DIR}/codequill.jar
fi
export CLASSPATH

exec $JAVACMD com.sonoransoft.codequill.CodeQuill "$@" &

if [ "$ORIG_CLASSPATH" != "" ]; then
    CLASSPATH=${ORIG_CLASSPATH}
    export CLASSPATH
else
    unset CLASSPATH
fi
