implementation module dialogDevice

import StdEnv, ostypes, oswindow, misc, oskernel
import deltaIOSystem, ioState, deltaSystem, deltaPicture
import dialogDef, dialogAccess
from timerDevice import TimerFunctions
from windowDevice import WindowFunctions,EventToMouse
from deltaDialog import CloseActiveDialog

Modal       :== True
Modeless    :== False

//  These ids should be safe !! 
		
SetId       :== -1
ResetId     :== -2

AboutDialogId   :== -1

HorMargin   :== 12 // 15
VerMargin   :== 12 // 15
HorSpace    :== 16 // 25
VerSpace    :== 16 // 25

HorBoxSpace    :== 10
VerBoxSpace    :== 0 // 10

/* PJ Begin */
HorPos      :== -1 /* zorgt ervoor wanneer dialogpos niet is */
VerPos      :== -1 /* opgegeven, dat ie netjes gecentered wordt. */ 
/* PJ End */

::  DialogMode  :== Bool
::  Id          :== DialogItemId
::  ItPos       :== (!DialogItemId,!ItemPos,!Rect,![CPos])
::  CPos        :== (!DialogItemId,!Rect)

DialogFunctions::    DeviceFunctions s
DialogFunctions = (ShowDialog,OpenDialogDevice,DialogIO,CloseDialogDevice, HideDialog)

/* Closing the entire dialog device. */

CloseDialogDevice:: !(IOState s) -> IOState s
CloseDialogDevice io
		= Evaluate_2 (IOStateRemoveDevice io` DialogDevice) (Close_dialogs dialogs)
		  where 
		  (dialogs, io`) = IOStateGetDevice io DialogDevice
		  

Close_dialogs:: !(DeviceSystemState s) -> DeviceSystemState s
Close_dialogs (DialogSystemState dialogs) 
		= let! 
			strict1
		  in DialogSystemState strict1
		  where 
		  strict1 = Close_dialogs` dialogs

Close_dialogs`:: ![DialogHandle s io] -> [DialogHandle s io]
Close_dialogs` [dialog : dialogs] 
		= Evaluate_2 (Close_dialogs` dialogs) (Close_dialog dialog)
Close_dialogs` dialogs
		= dialogs

Close_dialog:: !(DialogHandle s io) -> Int
Close_dialog (id,mode,wptr,info,funs,osids)
		= OSWinTerminateDialog wptr mode 

HideDialog:: !(IOState s) -> IOState s
HideDialog io_state
		= IOStateSetDevice io_state` dialog`
		  where 
		  dialog`             = HideDialog` dialog
		  (dialog, io_state`) = IOStateGetDevice io_state DialogDevice

HideDialog`:: !(DeviceSystemState s) -> DeviceSystemState s
HideDialog` (DialogSystemState dialogs)
		= let! 
			dialogs` = HideDialog`` dialogs
		  in DialogSystemState dialogs`

HideDialog``:: ![DialogHandle s (IOState s)] -> [DialogHandle s (IOState s)]
HideDialog`` [(id,mode,wptr,info,funs,osids) : dialogs]
		= let! 
			wptr`    = OSWinHide wptr
			dialogs` = HideDialog`` dialogs
		  in [(id,mode, wptr`,info,funs,osids) : dialogs`]
HideDialog`` dialogs
		= dialogs

ShowDialog:: !(IOState s) -> IOState s
ShowDialog io_state
		= IOStateSetDevice io_state` dialog`
		  where 
		  dialog`             = ShowDialog` dialog
		  (dialog, io_state`) = IOStateGetDevice io_state DialogDevice

ShowDialog`:: !(DeviceSystemState s) -> DeviceSystemState s
ShowDialog` (DialogSystemState dialogs)
		= let! 
			dialogs` = ShowDialog`` dialogs
		  in DialogSystemState dialogs`
		  
ShowDialog``:: ![DialogHandle s (IOState s)] -> [DialogHandle s (IOState s)]
ShowDialog`` [dialog =: (id, mode, wptr, info, funs, osids) : dialogs]
	| IsAboutDialog dialog
		= let! 
			dialogs` = ShowDialog`` dialogs
		  in [dialog : dialogs`]
		= let! 
			wptr`    = OSWinShow wptr
			dialogs` = ShowDialog`` dialogs
		  in [(id, mode, wptr`, info, funs, osids) : dialogs`]		
ShowDialog`` dialogs
		= dialogs

IsAboutDialog:: (DialogHandle s io) -> Bool
IsAboutDialog (id,mode,wptr,info,funs,osids)
		= AboutDialogId == id

/* Opening the dialog device at start up. */

OpenDialogDevice :: !.(DeviceSystem s (IOState s)) !(IOState s) -> IOState s
OpenDialogDevice (DialogSystem dialog_defs) io_state
		= let! 
			strict1
		  in IOStateSetDevice io_state` (DialogSystemState strict1)
		  where 
		  strict1             = Open_dialogs strict2 
		  (strict2,io_state`) = InsertAboutInIOState dialog_defs io_state 

AboutDialogDefToDialogDef:: !(AboutDialogDef s) -> DialogDef s (IOState s)
AboutDialogDefToDialogDef (About about)
		= about

InsertAboutInIOState:: ![DialogDef s (IOState s)] !(IOState s) -> ([DialogDef s (IOState s)], !(IOState s))
InsertAboutInIOState dialogdef=:[dialog=:AboutDialog appname pic dfs help : dialogs] io
	= (dialogdef, IOStateSetAbout dialog` io)
	  where 
		  dialog` = DialogDefToAboutDialogDef dialog   
InsertAboutInIOState [dialog : dialogs0] io0
	= ([dialog : dialogs1],io1)
	where
		(dialogs1,io1) = InsertAboutInIOState dialogs0 io0
InsertAboutInIOState [] io 
		= ([], IOStateSetAbout NoAbout io)

DialogDefToAboutDialogDef:: !(DialogDef s (IOState s)) -> AboutDialogDef s
DialogDefToAboutDialogDef about=:(AboutDialog appname pic dfs help) 
		= About about

Open_dialogs:: ![DialogDef s (IOState s)] -> DialogHandles s (IOState s)
Open_dialogs [dialog=:CommandDialog id t a di items : dialogs]
		= let! 
			strict1
			strict2
		  in [strict1 : strict2]
		  where 
		  strict1 = Open_dialog Modeless dialog
		  strict2 = Open_dialogs dialogs
Open_dialogs [dialog=:PropertyDialog id t a f1 f2 items : dialogs]
		= let! 
			strict1
			strict2
		  in [strict1 : strict2]
		  where 
		  strict1 = Open_dialog Modeless dialog
		  strict2 = Open_dialogs dialogs
Open_dialogs [dialog =: AboutDialog appname pic dfs help : dialogs]
		= Open_dialogs dialogs
Open_dialogs [dialog : dialogs] 
		= Open_dialogs dialogs
Open_dialogs []
		= []

RemoveAbouts:: ![DialogDef s (IOState s)] -> [DialogDef s (IOState s)]
RemoveAbouts [AboutDialog appname pic dfs help : dialogs]
		= RemoveAbouts dialogs
RemoveAbouts [dialog : dialogs]
		= let! 
			strict1
		  in [dialog : strict1]
		  where 
		  strict1 = RemoveAbouts dialogs
RemoveAbouts []
		= []

Open_dialog:: !DialogMode !(DialogDef s io) -> DialogHandle s io
Open_dialog mode def=:(PropertyDialog id title att f1 f2 items)
		= let! 
			newdialog = ConvertToCommandDialog def
		  in NewDialog mode newdialog
Open_dialog mode def
		= NewDialog mode def

ConvertToCommandDialog:: (DialogDef s io) -> DialogDef s io
ConvertToCommandDialog (PropertyDialog id title att f1 f2 items)
		= CommandDialog id title att SetId (items ++ newitems)
		  where 
		  newitems  = [setitem, resetitem]
		  setitem   = DialogButton SetId   Left            "Apply"  Able f1
		  resetitem = DialogButton ResetId (RightTo SetId) "Cancel" Able f2
		  
Open_Notice:: !NoticeDef !(IOState s) -> (!NoticeButtonId, !IOState s)
Open_Notice notice io
		= let! 
			dialh
		  in DoNoticeIO io dialh
		  where 
		  dialog = ConvertNoticeToCommandDialog notice
		  dialh  = NewDialog Modal dialog
		  
/* Note that the id's of the text items should be safe */
ConvertNoticeToCommandDialog:: NoticeDef -> DialogDef s io
ConvertNoticeToCommandDialog (Notice text defbutton=: (NoticeButton defid t) buttons)
		= CommandDialog 1 "Notice" [ItemSpace (Pixel HorSpace) (Pixel 0)] defid items
		  where 
		  items       = textitems ++ buttonitems
		  textitems   = ConvertNoticeText text 10000 Left
		  buttonitems = ConvertNoticeButtons [defbutton : buttons] Left
		  

ConvertNoticeText:: [String] Id ItemPos -> [DialogItem s io]
ConvertNoticeText [t : ts] id pos
		= [StaticText id pos t : ConvertNoticeText ts (dec id) (Below id)]
ConvertNoticeText ts id pos
		= [StaticText id pos " "]

ConvertNoticeButtons:: [NoticeButtonDef] ItemPos -> [DialogItem s io]
ConvertNoticeButtons [NoticeButton id title : buttons] pos
		= [item : items]
		  where 
		  item  = DialogButton id pos title Able DummyButtonFunction
		  items = ConvertNoticeButtons buttons (RightTo id)		  
ConvertNoticeButtons buttons pos
		= []

DummyButtonFunction:: DialogInfo * s * io -> (*s, *io)
DummyButtonFunction info s io
		= (s, io)

CloseDialogButtonFunction:: DialogInfo * s (IOState *s) -> (*s, IOState *s)
CloseDialogButtonFunction info s io
		= (s, CloseActiveDialog io)

DoNoticeIO::  !(IOState s) !(DialogHandle s (IOState s)) -> (!NoticeButtonId, !IOState s)
DoNoticeIO io dialog
	| done 
		= (id, io`)
		= DoNoticeIO io` dialog`
		  where 
		  (done, id, io`, dialog`) = NoticeIO event io dialog
		  event                    = OSGetNextEvent 0
		
DoModalIO:: !*s !(IOState *s) -> (!*s, !IOState *s)
DoModalIO s io
		= DoModalIO` [timer_io, window_io, DialogIO] s io
		  where 
		  (_,_,window_io,_,_) = WindowFunctions
		  (_,_,timer_io,_,_)  = TimerFunctions
		  
DoModalIO`:: ![DoIOFunction *s] !*s !(IOState *s) -> (!*s, !IOState *s)
DoModalIO` funs s io
	| closed 
		= (s`, io``)
		= DoModalIO` funs s` io``
		  where 
		  (closed, io``) = IOStateModalDialogClosed io`
		  (_, s`, io`)   = DoModalIO`` funs event s io
		  event          = OSGetNextEvent 0
		
DoModalIO``:: ![DoIOFunction *s] Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s)
DoModalIO`` [f : funs] event s io
	| done 
		= (True, s`, io`)
		= DoModalIO`` funs event s` io`
		  where 
		  (done, s`, io`) = f event s io
DoModalIO`` funs event s io
		= (False, s, io)

NewDialog:: !DialogMode !(DialogDef s io) -> DialogHandle s io
NewDialog mode dialog=:(PropertyDialog id title att f1 f2 items) 
		= NewDialog mode (ConvertToCommandDialog dialog)
NewDialog mode (CommandDialog id title attrs ditem items)
		= let! 
			wptr4
			wptr2
			strict1
			wptr
		  in (id, mode, wptr4, info, funs, osids)
	where 
		  wptr4                     = OSWinShowNewDialog wptr3 title mode
		  info                      = InitialiseItemInfo items`
		  funs                      = InitialiseFunctionInfo items`
		  wptr3                     = PositionItems wptr2 positions items`
		  (items`,osids)            = CheckDialogItems 1 items []
		  wptr2                     = OSWinSizeDialog wptr1 xs ys xp yp
		  (xs1,ys1,positions,wptr1) = strict1
		  wptr                      = OSWinCreateDialog mode
		  (xp,yp)                   = AttrPosition attrs
		  (xs,ys)                   = AttrSize attrs xs1 ys1
		  margins                   = AttrMargins attrs
		  spaces                    = AttrItemSpaces attrs
		  strict1                   = CreateItemBoxes wptr (IdToOsId ditem osids) margins spaces items` osids
	  
CheckPosition :: ItemPos IdTable -> ItemPos
CheckPosition (RightTo id) osids
	| id2 >= 0
		= RightTo id2
		= Left
		  where
		  id2 = IdToOsId id osids
CheckPosition (Below id) osids
	| id2 >= 0
		= Below id2
		= Left
		  where
		  id2 = IdToOsId id osids
CheckPosition (XOffset id m) osids
	| id2 >= 0
		= XOffset id2 m
		= Left
		  where
		  id2 = IdToOsId id osids
CheckPosition (YOffset id m) osids
	| id2 >= 0
		= YOffset id2 m
		= Left
		  where
		  id2 = IdToOsId id osids
CheckPosition pos osids
		= pos

CheckDialogItems:: Id [DialogItem s io] IdTable -> ([DialogItem s io], IdTable)
CheckDialogItems newid [DialogButton id ps t s f : items] oldosids
	=	([DialogButton newid1 ps1 t s f : items1], [(id, newid1) : osids])
	where 
		ps1            	= CheckPosition ps oldosids
		newid1			= newid bitor OSButtonIdMask
		(items1,osids)	= CheckDialogItems (inc newid) items [(id, newid1) : oldosids]
CheckDialogItems newid [DialogIconButton id ps d l s f : items] oldosids
	=	([DialogIconButton newid2 ps1 d l s f : items1], [(id, newid2) : osids])
	where 
		ps1             = CheckPosition ps oldosids
		newid2          = newid bitor (OSButtonIdMask bitor OSUserButton)
		(items1, osids) = CheckDialogItems (inc newid) items [(id, newid2) : oldosids]
CheckDialogItems newid [StaticText id ps t : items] oldosids
	=	([StaticText newid ps1 t : items1], [(id, newid) : osids])
	where 
		ps1             = CheckPosition ps oldosids
		(items1, osids) = CheckDialogItems (inc newid) items [(id, newid) : oldosids]
CheckDialogItems newid [DynamicText id ps w t : items] oldosids
	=	([DynamicText newid ps1 w t : items1], [(id, newid) : osids])
	where 
		ps1             = CheckPosition ps oldosids
		(items1, osids) = CheckDialogItems (inc newid) items [(id, newid) : oldosids]
CheckDialogItems newid [EditText id ps w l t : items] oldosids
	=	([EditText newid1 ps1 w l t : items1], [(id, newid1) : osids])
	where
		ps1             = CheckPosition ps oldosids
		newid1			= newid bitor (if (l>1) OSMLEIdMask OSEntryFieldMask)
		(items1, osids) = CheckDialogItems (inc newid) items [(id, newid1) : oldosids]
CheckDialogItems newid [DialogPopUp id ps ab di rs : items] oldosids
	=	([DialogPopUp newid2 ps1 ab di2 rs1 : items1], [(id,newid2) : osids1 ++ osids2])
	where
		newid2				= newid bitor OSComboBoxMask
		ps1             	= CheckPosition ps oldosids
		(rs1,osids1,newid1)	= CheckRadioItems (inc newid) rs
		(items1,osids2) 	= CheckDialogItems newid1 items [(id, newid2) : oldosids]
		di1             	= CheckDefaultRadioId di rs
		di2             	= IdToOsId di1 osids1
CheckDialogItems newid [RadioButtons id ps rc di rs : items] oldosids
	=	([RadioButtons newid ps1 rc di2 rs1 : items1], [(id, newid) : osids1 ++ osids2])
	where 
		ps1                 = CheckPosition ps oldosids
		(rs1,osids1,newid1)	= CheckRadioItems (inc newid) rs
		(items1, osids2)    = CheckDialogItems newid1 items [(id, newid) : oldosids]
		di1                 = CheckDefaultRadioId di rs
		di2                 = IdToOsId di1 osids1
CheckDialogItems newid [CheckBoxes id ps rc boxes : items] oldosids
	=	([CheckBoxes newid ps1 rc boxes1 : items1], [(id, newid) : osids1 ++ osids2])
	where 
		ps1                      = CheckPosition ps oldosids
		(boxes1, osids1, newid1) = CheckBoxItems (inc newid) boxes
		(items1, osids2)         = CheckDialogItems newid1 items [(id, newid) : oldosids]
CheckDialogItems newid [Control id ps pd ab state cl cf df : items] oldosids
	=	([Control newid2 ps1 pd ab state cl cf df : items1], [(id, newid2) : osids])
	where
		ps1             = CheckPosition ps oldosids
		newid2          = newid bitor (OSButtonIdMask bitor OSUserButton)
		(items1, osids) = CheckDialogItems (inc newid) items [(id, newid2) : oldosids]
CheckDialogItems newid [] oldosids
	= ([],[])

CheckRadioItems:: Id [RadioItemDef s io] -> ([RadioItemDef s io], IdTable, Id)
CheckRadioItems newid [RadioItem id t s f : radios]
	=	([RadioItem newid2 t s f : rs1], [(id, newid2) : osids], newid1)
	where
		newid2 = newid bitor OSButtonIdMask
		(rs1, osids, newid1) = CheckRadioItems (inc newid) radios
CheckRadioItems newid radios
	= ([], [], newid)

CheckBoxItems:: Id [CheckBoxDef s io] -> ([CheckBoxDef s io], IdTable, Id)
CheckBoxItems newid [CheckBox id title state mark f : boxes]
	=	([CheckBox newid2 title state mark f : boxes1], [(id, newid2) : osids], newid1)
	where 
		newid2 = newid bitor OSButtonIdMask
		(boxes1, osids, newid1) = CheckBoxItems (inc newid) boxes
CheckBoxItems newid boxes
	= ([], [], newid)

CheckDefaultRadioId:: !Id ![RadioItemDef s io] -> Id
CheckDefaultRadioId rid radios=:[RadioItem id t s f : rest`]
	= check rid id radios
	where
		check :: !Id !Id ![RadioItemDef s io] -> Id
		check rid first [RadioItem id t s f : radios]
			| id == rid 
				= rid
				= check rid first radios
		check rid first []
				= first
CheckDefaultRadioId rid []
	= rid

InitialiseFunctionInfo:: [DialogItem s io] -> ItemInfo2 s io
InitialiseFunctionInfo [DialogButton id ps t s f : rest]
	= [(id, ItemButtonFunction f) : InitialiseFunctionInfo rest]
InitialiseFunctionInfo [DialogIconButton id ps d l s f : rest]
	= [(id, ItemButtonFunction f) : InitialiseFunctionInfo rest]
InitialiseFunctionInfo [DialogPopUp id ps ab di rs : rest]
	=	rfuns ++ funs
	where 
		rfuns = InitRadioFuns rs
		funs  = InitialiseFunctionInfo rest
InitialiseFunctionInfo [RadioButtons id ps rc di rs : rest]
	=	rfuns ++ funs
	where 
		rfuns = InitRadioFuns rs
		funs  = InitialiseFunctionInfo rest
InitialiseFunctionInfo [CheckBoxes id ps rc boxes : rest]
	=	cfuns ++ funs
	where 
		funs  = InitialiseFunctionInfo rest
		cfuns = InitCheckBoxFuns boxes
InitialiseFunctionInfo [Control id ps pd ab state cl cf df : rest]
	= [(id, ItemDialogFunction df) : InitialiseFunctionInfo rest]
InitialiseFunctionInfo [item : rest]
	= InitialiseFunctionInfo rest
InitialiseFunctionInfo []
	= []

InitialiseItemInfo:: [DialogItem s io] -> ItemInfo
InitialiseItemInfo [DialogButton id ps t s f : rest]
		= InitialiseItemInfo rest
InitialiseItemInfo [DialogIconButton id ps d l s f : rest]
		= (edits,radios,checks,[(id,(d,state,cl,cf)):ctrls],dynamics)
		  where 
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
		  state                                = IntCS 0
		  cl                                   = IconLookToControlLook l
		  cf                                   = \m c -> (c, [])
InitialiseItemInfo [EditText id ps tw nl text : rest]
		= ([(id,text):edits],radios,checks,ctrls,dynamics)
		  where 
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
InitialiseItemInfo [DynamicText id ps tw text : rest]
		= (edits,radios,checks,ctrls,[(id,text):dynamics])
		  where 
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
InitialiseItemInfo [DialogPopUp id ps ab di rs : rest]
		= (edits,[(id,False,0,rids):radios],checks,ctrls,dynamics)
		  where 
		  (_, rids)                            = InitRadioIds 0 di rs
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
InitialiseItemInfo [RadioButtons id ps rc di rs : rest]
		= (edits,[(id,True,index,rids):radios],checks,ctrls,dynamics)
		  where 
		  (index,rids)                         = InitRadioIds 0 di rs
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
InitialiseItemInfo [CheckBoxes id ps rc boxes : rest]
		= (edits,radios, cchecks ++ checks,ctrls,dynamics)
		  where 
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
		  cchecks                              = InitCheckBoxesInfo id boxes
InitialiseItemInfo [Control id ps pd ab state cl cf df : rest]
		= (edits,radios,checks,[(id,(pd,state,cl,cf)):ctrls],dynamics)
		  where 
		  (edits,radios,checks,ctrls,dynamics) = InitialiseItemInfo rest
InitialiseItemInfo [item : rest]
		= InitialiseItemInfo rest
InitialiseItemInfo []
		= ([],[],[],[],[])

IconLookToControlLook:: IconLook SelectState ControlState -> [DrawFunction]
IconLookToControlLook iconlook selectstate control
		= iconlook selectstate

InitRadioFuns:: ![RadioItemDef s io] -> ItemInfo2 s io
InitRadioFuns [RadioItem id t s f : radios]
		= [(id, ItemDialogFunction f) : InitRadioFuns radios]
InitRadioFuns radio 
		= []

InitCheckBoxFuns:: ![CheckBoxDef s io] -> ItemInfo2 s io
InitCheckBoxFuns [CheckBox id title state mark f : checks]
		= [(id, ItemDialogFunction f) : InitCheckBoxFuns checks]
InitCheckBoxFuns checks 
		= []

InitRadioIds:: Int !Id ![RadioItemDef s io] -> (Int, [Id])
InitRadioIds index id [RadioItem id2 t s f : radios]
	| id == id2
		= (index,  [id2 : ids])
		= (index`, [id2 : ids])
		  where 
		  (index`,ids) = InitRadioIds (inc index) id radios	
InitRadioIds index id radios
		= (-1,[])

InitCheckBoxesInfo:: Id ![CheckBoxDef s io] -> [(Id,Id,Bool)]
InitCheckBoxesInfo gid [CheckBox id title state mark f : checks]
		= [(id, gid, IsMarked mark) : InitCheckBoxesInfo gid checks]
InitCheckBoxesInfo gid checks
		= []

NoticeIO:: !Event !(IOState s) !(DialogHandle s (IOState s)) -> (!Bool, !NoticeButtonId, !IOState s, DialogHandle s (IOState s))
NoticeIO (OSDialogDevice, OSDialogCommand, wptr, itemid) io d=: (id,mode,wptr2,info,funs,osids)
	| wptr == wptr2
		= (True, OsIdToId itemid osids, io`, d)
		  where 
		  io` = Evaluate_2 io (OSWinTerminateDialog wptr True)
				
NoticeIO event io dialog
		= (False, -1, io, dialog)

DialogIO  :: !.Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s)
DialogIO (OSDialogDevice, OSDialogActivate, wptr, itemosid) s io
		= (True, s, io``)
		  where 
		  io``              = Evaluate_2 io` (DrawDialogControlLook wptr itemosid controlinfo)
		  (controlinfo,io`) = FindControlInfo wptr itemosid io
DialogIO (OSDialogDevice, OSDialogCommand, wptr, itemosid) s io
		= (True, s`, io`)
		  where 
		  (s`,io`) = DialogIO` wptr itemosid s io
DialogIO (OSDialogDevice, OSDialogClose, wptr, x) s io
	| found 
		= (True, s, io``)
		= (True, s, io`)
		  where 
		  io``               = Evaluate_2 io` (Close_dialog dialog)
		  (found,dialog,io`) = IOStateRemoveDialogPtr wptr io
DialogIO (OSDialogDevice, OSDialogMouse, wptr, itemosid) s io
		= (True, s`, io`)
		  where 
		  (s`,io`) = ControlIO wptr itemosid s io
/* RWS */
DialogIO (OSDialogDevice, OSDialogUpdateEditFields, wptr, id) s io
	=	(True, s, io3)
	where
		(dialogsystem, io1)
			=	IOStateGetDevice io DialogDevice
		(dialog, dialogs, _)
			=	GetDialogAndItemFunction wptr id dialogsystem
		dialog1
			=	UpdateDialogHandleEditItem dialog id
		dialogsystem1
			=	DialogSystemState dialogs
		io2
			=	IOStateSetDevice io1 dialogsystem1
		io3
			=	PutDialogInIOState dialog1 io2
/* */
DialogIO no_dialog_event s io_state
		= (False,s,io_state)

DialogIO`:: DialogPtr OsId !*s !(IOState *s) -> (!*s, !IOState *s)
DialogIO` wptr osid s io
		= DoDialogIO f dialog s (IOStateSetDevice io` dialogsystem`)
		  where 
		  dialogsystem`        = DialogSystemState dialogs
		  (dialog, dialogs, f) = GetDialogAndItemFunction wptr osid dialogsystem
		  (dialogsystem, io`)  = IOStateGetDevice io DialogDevice

DoDialogIO:: (ItemFunction *s (IOState *s)) (DialogHandle *s (IOState *s)) !*s !(IOState *s) -> (!*s, !IOState *s)
DoDialogIO ItemEmptyFunction dialog s io
		= (s, PutDialogInIOState dialog io)
DoDialogIO (ItemDialogFunction f) dialog s io
		= let! 
			dialog``
			dialog`
		  in (s, PutDialogInIOState (DialogStateToDialogHandle dialog``) io)
		  where 
		  dialog``                      = f (ItemInfoToDialogInfo info osids) (DialogHandleToDialogState (id,mode,ptr,info,funs,osids))
		  (id,mode,ptr,info,funs,osids) = dialog`
		  dialog`                       = UpdateDialogInfo dialog
		  
DoDialogIO (ItemButtonFunction f) dialog s io
		= let! 
			dialog`
		  in f info` s (PutDialogInIOState dialog` io)
		  where 
		  (_,_,_,info,_,idtable) = dialog`
		  info`                  = ItemInfoToDialogInfo info idtable
		  dialog`                = UpdateDialogInfo dialog
		  

ControlIO:: !DialogPtr !OsId !*s !(IOState *s) -> (!*s, !IOState *s)
ControlIO wptr id s io
		= let! 
			strict1
			mouse
			strict2
			s`
			io````
			io```
			io``
			io`
		  in (s`, io````)
	  where 
		  io````              = UpdateDialogControlInfo io``` wptr` id newinfo
		  (controlinfo,io`)   = FindControlInfo wptr id io
		  (wptr`, newinfo)    = strict1
		  (pic,_,_,_)         = controlinfo
		  (offset,_)          = pic
		  mouse               = EventToMouse strict2 offset
		  strict1             = DrawDialogControlFeel wptr id mouse controlinfo
		  strict2             = OSGetMouseState wptr
		  (s`,io```)          = DoDialogIO f dialog s (IOStateSetDevice io`` dialogsystem`)
		  dialogsystem`       = DialogSystemState dialogs
		  (dialog,dialogs,f)  = GetDialogAndItemFunction wptr id dialogsystem
		  (dialogsystem,io``) = IOStateGetDevice io` DialogDevice

PutDialogInIOState:: (DialogHandle s (IOState s)) !(IOState s) -> IOState s
PutDialogInIOState dialog io
		= IOStateSetDevice io` dialogsystem`
		  where 
		  dialogsystem`      = PutDialogInDeviceSystem dialog dialogsystem
		  (dialogsystem,io`) = IOStateGetDevice io DialogDevice
		  

PutDialogInDeviceSystem:: (DialogHandle s (IOState s)) (DeviceSystemState s) -> DeviceSystemState s
PutDialogInDeviceSystem dialog (DialogSystemState dialogs)
		= DialogSystemState [dialog : dialogs]

/* was intended for button clicks in modal dialogs
::  DialogHasToBeClosed (DialogHandle s io) -> BOOL
		  DialogHasToBeClosed (id, TRUE, wptr, info,funs)
				-> Evaluate_2 TRUE (OSWinTerminateDialog wptr TRUE)
		  DialogHasToBeClosed (id, modal, wptr, info,funs)
				-> FALSE
*/

GetDialogAndItemFunction:: DialogPtr OsId (DeviceSystemState s) -> (DialogHandle s (IOState s), DialogHandles s (IOState s),                                                  ItemFunction s (IOState s))
GetDialogAndItemFunction wptr osid (DialogSystemState dialogs)
		= GetDialogAndItemFunction` wptr osid dialogs

GetDialogAndItemFunction`:: DialogPtr OsId (DialogHandles s (IOState s)) -> (DialogHandle s (IOState s),  DialogHandles s (IOState s), ItemFunction s (IOState s))
GetDialogAndItemFunction` wptr osid [d=: (id2,mode,wptr2,info,funs,osids) : dialogs]
	| wptr == wptr2 
		= (d, dialogs, ItemFunctionFromDialogInfo osid funs)
		= (d`, [d : dialogs`], f)
		  where 
		  (d`,dialogs`,f) = GetDialogAndItemFunction` wptr osid dialogs		

ItemFunctionFromDialogInfo:: !OsId [(OsId,ItemFunction s io)] -> ItemFunction s io
ItemFunctionFromDialogInfo id [(id2,fun) : items]
	| id == id2 
		= fun
		= ItemFunctionFromDialogInfo id items
ItemFunctionFromDialogInfo id items
		= ItemEmptyFunction

IsAble:: Bool -> SelectState
IsAble True  = Able
IsAble False = Unable

DrawDialogControlLook:: !DialogPtr !OsId !ControlInfo -> DialogPtr
DrawDialogControlLook wptr id ((xy,xy2),state,look,feel)
		= Evaluate_2 wptr (RemovePicture (EndDrawing picture))
		  where 
		  picture = DrawButton (NewButtonPicture wptr id xy True) (look (IsAble able) state)
		  able    = OSWinItemIsEnabled wptr id
		  

DrawDialogControlFeel:: !DialogPtr !OsId !MouseState !ControlInfo -> (!DialogPtr, !ControlInfo)
DrawDialogControlFeel wptr id mouse ((xy,xy2),state,look,feel)
		= (Evaluate_2 wptr (RemovePicture (EndDrawing picture)), ((xy,xy2),newstate,look,feel))
		  where 
		  picture             = DrawButton (NewButtonPicture wptr id xy False) drawfuns
		  (newstate,drawfuns) = feel mouse state
		  
				   
DrawButton:: !Picture ![DrawFunction] -> Picture
DrawButton pic [f : fs]
		= DrawButton (f pic) fs
DrawButton pic fs
		= pic


FindControlInfo:: DialogPtr OsId (IOState s) -> (ControlInfo, IOState s)
FindControlInfo wptr itemid io
	| not found
		= (DummyControlInfo, io`)
		= (controlinfo, io`)
		  where 
		  controlinfo          = FindControlInfoInDialog itemid info
		  (_,_,_,info,_,_)     = dialog
		  (found, dialog, io`) = IOStateGetDialogPtr wptr io
		
		  FindControlInfoInDialog:: OsId ItemInfo -> ControlInfo
		  FindControlInfoInDialog id (t,r,c,co,d)
				= FindControlInfoInControls id co

		  FindControlInfoInControls:: OsId [(OsId,ControlInfo)] -> ControlInfo
		  FindControlInfoInControls id [(id2,controlinfo) : controls]
			| id == id2 
				= controlinfo
				= FindControlInfoInControls id controls
		  FindControlInfoInControls id controls
				= DummyControlInfo

		  DummyControlInfo:: ControlInfo
		  DummyControlInfo = (((0,0),(0,0)),IntCS 0,DummyControlLook,DummyControlFeel)

		  DummyControlLook:: SelectState ControlState -> [DrawFunction]
		  DummyControlLook s c = []

		  DummyControlFeel:: MouseState ControlState -> (ControlState, [DrawFunction])
		  DummyControlFeel m c = (c, [])

UpdateDialogInfo:: !(DialogHandle s io) -> DialogHandle s io
UpdateDialogInfo (def,modeless,wptr,info,funs,ids)
		= let! 
			info` = UpdateItemInfo wptr info
		  in (def, modeless, wptr, info`,funs,ids)
		  

UpdateItemInfo:: DialogPtr ItemInfo -> ItemInfo
UpdateItemInfo wptr (edits, radios, checks, ctrls, dynamics)
		= let! 
			edits`    = UpdateEditItemInfos wptr edits
			radios`   = UpdateRadioItemInfos wptr radios
			checks`   = UpdateCheckItemInfos wptr checks
			dynamics` = UpdateEditItemInfos wptr dynamics
		  in (edits`, radios`, checks`, ctrls, dynamics`)		  

UpdateDialogHandleEditItem :: !(DialogHandle s io) !Int -> DialogHandle s io
UpdateDialogHandleEditItem (def,modeless,wptr,info,funs,ids) id
	= (def, modeless, wptr, UpdateDialogPtrEditItem wptr info id,funs,ids)

UpdateDialogPtrEditItem :: DialogPtr ItemInfo Int -> ItemInfo
UpdateDialogPtrEditItem wptr (edits, radios, checks, ctrls, dynamics) id
	= (UpdateEditItemInfo wptr edits id, radios, checks, ctrls, dynamics)		  

UpdateEditItemInfo:: DialogPtr [(Id,String)] Int -> [(Id,String)]
UpdateEditItemInfo wptr [(id,s) : ids] update_id
	| id==update_id
		= let! 
			s`   = OSWinGetItemText wptr id
			ids` = UpdateEditItemInfo wptr ids update_id
		  in [(id, s`) : ids`]
		= let! 
			ids` = UpdateEditItemInfo wptr ids update_id
		  in [(id,s) : ids`]
UpdateEditItemInfo wptr ids update_id
		= ids

EditInfoToString :: [(Id,String)] -> String
EditInfoToString [(i, s)]
		= toString i +++ ": " +++ s
EditInfoToString [(i, s) : r]
		= toString i +++ ": " +++ s +++ ", " +++ EditInfoToString r
EditInfoToString []
		= ""

UpdateEditItemInfos:: DialogPtr [(Id,String)] -> [(Id,String)]
UpdateEditItemInfos wptr [(id,s) : ids]
		= let! 
			s`   = OSWinGetItemText wptr id
			ids` = UpdateEditItemInfos wptr ids
		  in [(id, s`) : ids`]
UpdateEditItemInfos wptr ids
		= ids

UpdateRadioItemInfos:: DialogPtr [(Id,Bool,Int,[Id])] -> [(Id,Bool,Int,[Id])]
UpdateRadioItemInfos wptr [(id,True,index,rids=:[firstid:restids]) : ids]
		= let! 
			newindex = OSWinGetCheckedRadioButtonId wptr firstid
			ids`     = UpdateRadioItemInfos wptr ids
		  in [(id, True, newindex, rids) : ids`]
UpdateRadioItemInfos wptr [(id,False,index,rids=:[firstid:restids]) : ids]
		= let! 
			newindex = OSWinGetSelectedListBoxItem wptr id 
			ids`     = UpdateRadioItemInfos wptr ids
		  in [(id, False, newindex, rids) : ids`]
UpdateRadioItemInfos wptr ids
		= ids

UpdateCheckItemInfos:: DialogPtr [(Id,Id,Bool)] -> [(Id,Id,Bool)]
UpdateCheckItemInfos wptr [(id,gid,state) : ids]
		= let! 
			state`
			ids`
		  in [(id, gid, UpdateCheckState state state`) : ids`]
		  where 
		  state` = OSWinGetCheckBoxState wptr id
		  ids`   = UpdateCheckItemInfos wptr ids
UpdateCheckItemInfos wptr ids
		= ids

UpdateCheckState:: Bool Int -> Bool
UpdateCheckState state 2 = state
UpdateCheckState state 1 = True
UpdateCheckState state x = False

UpdateDialogControlInfo:: (IOState s) DialogPtr OsId ControlInfo -> IOState s
UpdateDialogControlInfo io wptr osid newinfo
	| not found 
		= io`
		= IOStateReplaceDialog id dialog` io`
		  where 
		  dialog`                         = (id,mode,wptr2,info`,funs,osids)
		  info`                           = UpdateControlInfo osid newinfo info
		  (id,mode,wptr2,info,funs,osids) = dialog
		  (found,dialog,io`)              = IOStateGetDialogPtr wptr io
		

UpdateControlInfo:: OsId ControlInfo ItemInfo -> ItemInfo
UpdateControlInfo id newinfo (edits, radios, checks, ctrls, dynamics)
		= (edits, radios, checks, ctrls`, dynamics)
		  where 
		  ctrls` = UpdateControlInfo` id newinfo ctrls
		  
				   
UpdateControlInfo`:: OsId ControlInfo [(OsId,ControlInfo)] -> [(OsId,ControlInfo)]
UpdateControlInfo` id newcontrol [c=: (id2,control) : controls]
	| id == id2
		= [(id2,newcontrol) : controls]
		= [c : UpdateControlInfo` id newcontrol controls]
UpdateControlInfo` id newcontrol controls
		= []

DummyItPos  :== (0,Left,(0,0,0,0),[])

/*  Retrieve position, size, margins and items spaces from the attribute list. */
AttrMargins:: ![DialogAttribute] -> (!Int,!Int)
AttrMargins []
		= (HorMargin, VerMargin)
AttrMargins [DialogMargin wid hgt : rest]
		= (ConvertMeasureX wid, ConvertMeasureY hgt)
AttrMargins [attr : rest]
		= AttrMargins rest

AttrItemSpaces:: ![DialogAttribute] -> (!Int,!Int)
AttrItemSpaces []
		= (HorSpace, VerSpace)
AttrItemSpaces [ItemSpace wid hgt : rest]
		= (ConvertMeasureX wid, ConvertMeasureY hgt)
AttrItemSpaces [attr : rest]
		= AttrItemSpaces rest

AttrPosition:: ![DialogAttribute] -> (!Int, !Int)
AttrPosition []
		= (HorPos, VerPos)
AttrPosition [DialogPos x y : rest]
		= (ConvertMeasureX x, ConvertMeasureY y)
AttrPosition [attr : rest]
		= AttrPosition rest

AttrSize:: ![DialogAttribute] !Int !Int -> (!Int, !Int)
AttrSize [] xs ys
		= (xs,ys)
AttrSize [DialogSize wid hgt : rest] xs ys
		= (max (ConvertMeasureX wid) xs, max (ConvertMeasureY hgt) ys)
AttrSize  [attr : rest] xs ys 
		= AttrSize rest xs ys


/*  Calculate the precise position (in pixels) of each dialog item,
		  the items are, as a side effect, also created */
CreateItemBoxes:: !DialogPtr Id !(!Int,!Int) !(!Int,!Int) ![DialogItem s io] IdTable -> (!Int,!Int,![ItPos],!DialogPtr)
CreateItemBoxes wptr def_id margins=:(hmg,vmg) spaces=:(hsp,vsp) items osids
	= (width, hgt + vmg, pos3, wptr)
	where 
		pos3           = RenterItems width hmg pos2 []
		(wid,hgt,pos2) = CalcItemPositions hmg (vmg - vsp) margins spaces pos1 []
		pos1           = CreateDialogItems wptr def_id items
		width          = wid + hmg

ConvertMeasureX:: Measure -> Int
ConvertMeasureX (Pixel n) = n
ConvertMeasureX (MM  n)   = MMToHorPixels n
ConvertMeasureX (Inch  n) = InchToHorPixels n
  
ConvertMeasureY:: Measure -> Int
ConvertMeasureY (Pixel n) = n
ConvertMeasureY (MM  n)   = MMToVerPixels n
ConvertMeasureY (Inch  n) = InchToVerPixels n

CreateDialogItems:: !DialogPtr OsId ![DialogItem s io] -> [ItPos]
CreateDialogItems dialog def_id [item:items]
	= let! 
		itemhandle
		itemhandles
	  in [itemhandle : itemhandles]
	where 
	  itemhandle  = CreateDialogItem dialog def_id item
	  itemhandles = CreateDialogItems dialog def_id items
CreateDialogItems dialog def_id items
	= []

CreateDialogItem:: !DialogPtr DialogItemId !(DialogItem s io) -> ItPos
CreateDialogItem dialog def_id (DialogButton id pos=:(ItemBox l t w h) title state f)
	= let! 
		(w1,h1) = OSWinCreatePushButtonWithSize dialog id title w h (def_id==id) (Enabled state)
	  in (id, pos, (0,0,w1,h1),[])
CreateDialogItem dialog def_id (DialogButton id pos title state f)
	= let! 
		(w,h) = OSWinCreatePushButton dialog id title (def_id==id) (Enabled state)
	  in (id, pos, (0,0,w,h),[])
CreateDialogItem dialog def_id (DialogIconButton id pos ((x0,y0),(x1,y1)) look state f)
	=	(id, pos, (0,0,w`,h`),[])
	where 
		w        = x1 - x0
		h        = y1 - y0
		(w`, h`) = OSWinCreateUserButton dialog id (def_id == id) (Enabled state) w h
CreateDialogItem dialog def_id (StaticText id pos text)
	= let! 
		(w,h) = OSWinCreateStaticText dialog id text (-1)
	  in (id, pos, (0,0,w,h),[])
CreateDialogItem dialog def_id (DynamicText id pos width text)
	= let! 
		(w,h) = OSWinCreateStaticText dialog id text (ConvertMeasureX width)
	  in (id, pos, (0,0,w,h),[])
CreateDialogItem dialog def_id (EditText id pos width lines text)
	= let! 
		(w,h) = OSWinCreateEntryField dialog id text (ConvertMeasureX width) lines
	  in (id, pos, (0,0,w,h),[])
CreateDialogItem dialog def_id (DialogPopUp id pos state di radios)
	= let! 
		s = OSWinSizeListBox dialog id n 5 True
		n = CreateListBox dialog DummyPtr radios id state di 
	  in (id, pos, (0,0,w,h), []) 
	where
		(w,h) = s
CreateDialogItem dialog def_id (RadioButtons id pos roc rid radios)
	= let! 
		(n,maxw,maxh) = CreateRadioItems dialog DummyPtr radios rid 0 0 0
	  in (id, pos, CalcBoxSize roc n maxw maxh, [])
CreateDialogItem dialog def_id (CheckBoxes id pos roc checks)
	= let! 
		(n,maxw,maxh) = CreateCheckBoxes dialog checks 0 0 0
	  in (id, pos, CalcBoxSize roc n maxw maxh, [])
CreateDialogItem dialog def_id (Control id pos ((x0,y0),(x1,y1)) state cstate look feel f)
	= (id, pos, (0,0,w`,h`),[])
	where 
	  w        = x1 - x0
	  h        = y1 - y0
	  (w`, h`) = OSWinCreateControlButton dialog id (Enabled state) w h
CreateDialogItem dialog def_id item
	= (0, ItemBox 0 0 0 0, (0,0,0,0),[])

IsMarked:: MarkState -> Bool
IsMarked Mark   = True
IsMarked nomark = False
		
CreateRadioItems:: !DialogPtr !ControlPtr [RadioItemDef s io] !Id !Int !Int !Int -> (!Int,!Int,!Int)
CreateRadioItems wptr prev [RadioItem id title state f : radios] defid n maxw maxh
	= let! 
		(rptr,w,h) = OSWinCreateRadioButton wptr prev id title (Enabled state) (id == defid)
	  in CreateRadioItems wptr rptr radios defid (inc n) (max w maxw) (max h maxh)
CreateRadioItems wptr prev radios defid n maxw maxh
	= (n, maxw, maxh)

CreateListBox :: !DialogPtr !ControlPtr [RadioItemDef s io] !Id !SelectState !Id  -> !Int
CreateListBox wptr prev radios lbid able defid
	= let! 
		rptr = OSWinCreateListBox wptr lbid (Enabled able) True
	  in
	  	CreateListBoxItems rptr prev radios lbid defid 0

CreateListBoxItems :: !DialogPtr !ControlPtr [RadioItemDef s io] !Id !Id !Int -> !Int
CreateListBoxItems wptr prev [RadioItem id title state f : radios] lbid defid n
	= let! 
		rptr = OSWinAddToListBox wptr lbid title (id == defid) False
	  in
	  	CreateListBoxItems wptr rptr radios lbid defid (inc n)
CreateListBoxItems wptr prev radios lbid defid n 
	= n

CreateCheckBoxes:: !DialogPtr [CheckBoxDef s io] !Int !Int !Int -> (!Int,!Int,!Int)
CreateCheckBoxes wptr [CheckBox id title state mark f : checks] n maxw maxh
		= let! 
			(w,h) = OSWinCreateCheckBox wptr id title  (Enabled state) (IsMarked mark)		  
		  in CreateCheckBoxes wptr checks (inc n) (max w maxw) (max h maxh)
CreateCheckBoxes wptr checks n maxw maxh
		= (n, maxw, maxh)

CalcBoxSize:: !RowsOrColumns !Int !Int !Int -> Rect
CalcBoxSize (Rows nr) nb maxw maxh
		= (0,0,(maxw + HorBoxSpace) *  UpDiv nb nr ,(maxh + VerBoxSpace) * nr)
CalcBoxSize (Columns nc) nb maxw maxh
		= (0,0,(maxw + HorBoxSpace) * nc,(maxh + VerBoxSpace) *  UpDiv nb nc )

UpDiv:: !Int !Int -> Int
UpDiv a b
	| b == 0 
		= a
	| a mod b == 0
		= a / b
		= inc (a / b)

Div:: !Int !Int -> Int
Div a b
	| b == 0 
		= a
		= a / b

/*  After calculating width and height of each item the positions can be determined.
		  On the fly the width and height of the dialog are calculated.
		  (NB: Renter = Right or Center) */
CalcItemPositions:: !Int !Int !(!Int,!Int) !(!Int,!Int) ![ItPos] ![ItPos] -> (!Int,!Int,![ItPos])
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [(id,Left,(l,t,w,h),ci):rest] poss
		= CalcItemPositions maxx` (t` + h) mg sp rest [(id,Left,(hm,t`,w,h),ci):poss]
		  where 
		  maxx` = max maxx (hm + w)
		  t`    = maxy + vs
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [(id,Center,(l,t,w,h),ci):rest] poss
		= CalcItemPositions maxx` (t` + h) mg sp rest [(id,Center,(hm,t`,w,h),ci):poss]
		  where 
		  maxx` = max maxx (hm + w)
		  t`    = maxy + vs
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [(id,Right,(l,t,w,h),ci):rest] poss
		= CalcItemPositions maxx` (t` + h) mg sp rest [(id,Right,(hm,t`,w,h),ci):poss]
		  where 
		  maxx` = max maxx (hm + w)
		  t`    = maxy + vs		  
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [item1=:(id,RightTo ri,rc,ci):rest] poss
	| exists
		= CalcItemPositions maxx1 maxy1 mg sp rest (Concat2 items poss`)
		= CalcItemPositions maxx2 (t` + h) mg sp rest [(id,Left,(hm,t`,w,h),ci):poss]
		  where 
		  (maxx1,maxy1,items)  = PositionRightTo maxx maxy hs ri item1 item2
		  (exists,item2,poss`) = RemoveItPos ri poss
		  maxx2                = max maxx (hm + w)
		  t`                   = maxy + vs
		  (_,_,w,h)            = rc
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [item1=:(id,XOffset ri ofs,rc,ci):rest] poss
	| exists
		= CalcItemPositions maxx1 maxy1 mg sp rest (Concat2 items poss`)
		= CalcItemPositions maxx2 (t` + h) mg sp rest [(id,Left,(hm,t`,w,h),ci):poss]
		  where 
		  (maxx1,maxy1,items)  = PositionRightTo maxx maxy (ConvertMeasureX ofs) ri item1 item2
		  (exists,item2,poss`) = RemoveItPos ri poss
		  maxx2                = max maxx (hm + w)
		  t`                   = maxy + vs
		  (_,_,w,h)            = rc
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [item1=:(id,Below ri,rc,ci):rest] poss
	| exists 
		= CalcItemPositions maxx1 maxy1 mg sp rest [bpos,item2:poss`]
		= CalcItemPositions maxx2 (t` + h) mg sp rest [(id,Left,(hm,t`,w,h),ci):poss]
		  where 
		  (maxx1,maxy1,bpos)   = PositionBelow maxx maxy vs hm item1 item2
		  (exists,item2,poss`) = RemoveItPos ri poss
		  maxx2                = max maxx (hm + w)
		  t`                   = maxy + vs 
		  (_,_,w,h)            = rc		
CalcItemPositions maxx maxy mg=:(hm,vm) sp=:(hs,vs) [item1=:(id,YOffset ri ofs,rc,ci):rest] poss
	| exists 
		= CalcItemPositions maxx1 maxy1 mg sp rest [bpos,item2:poss`]
		= CalcItemPositions maxx2 (t` + h) mg sp rest [(id,Left,(hm,t`,w,h),ci):poss]
		  where 
		  (maxx1,maxy1,bpos)   = PositionBelow maxx maxy (ConvertMeasureY ofs) hm item1 item2
		  (exists,item2,poss`) = RemoveItPos ri poss
		  maxx2                = max maxx (hm + w)
		  t`                   = maxy + vs
		  (_,_,w,h)            = rc
CalcItemPositions maxx maxy mg sp [(id,ps=:XY x y,(l,t,w,h),ci):rest] poss
		= CalcItemPositions maxx` maxy` mg sp rest [(id,ps,(l`,t`,w,h),ci):poss]
		  where 
		  maxx` = max maxx (l` + w) 
		  maxy` = max maxx (t` + h)
		  l`    = ConvertMeasureX x
		  t`    = ConvertMeasureY y
CalcItemPositions maxx maxy mg sp [pos=:(id,ps=:ItemBox l t w h,rc,ci):rest] poss
	= CalcItemPositions (max maxx (l + w)) (max maxy (t + h)) mg sp rest [(id,ps,(l,t,w,h),ci):poss]
CalcItemPositions maxx maxy mg sp [] poss 
	= (maxx,maxy,poss)

PositionRightTo:: !Int !Int !Int !Int !ItPos !ItPos -> (!Int,!Int,![ItPos])
PositionRightTo maxx maxy ofs id item1=:(i1,p1,r1,c1) (i2,Center,r2,poss)
	| id == i2
		= (mx1,my1,[(i2,Center,r2,[(i1,(l1,t2,w1,h1)):poss])])
		= (mx2,my2,[(i2,Center,r2,poss`)])
		  where 
		  mx1             = max maxx (l1 + w1)
		  my1             = max maxy (t2 + h1)
		  l1              = l2 + w2  + ofs
		  (_,_,w1,h1)     = r1
		  (l2,t2,w2,_)    = r2
		  (mx2,my2,poss`) = RightToRenter maxx maxy ofs id item1 poss
		
PositionRightTo maxx maxy ofs id item1=:(i1,p1,r1,c1) (i2,Right,r2,poss)
	| id == i2
		= (mx1,my1,[(i2,Right,r2,[(i1,(l1,t2,w1,h1)):poss])])
		= (mx2,my2,[(i2,Right,r2,poss`)])
		  where 
		  mx1             = max maxx (l1 + w1)
		  my1             = max maxy (t2 + h1)
		  l1              = l2 + w2  + ofs
		  (_,_,w1,h1)     = r1 
		  (l2,t2,w2,_)    = r2
		  (mx2,my2,poss`) = RightToRenter maxx maxy ofs id item1 poss
		
PositionRightTo maxx maxy ofs id (i1,p1,(ld,td,w1,h1),c1) item2=:(i2,p2,(l2,t2,w2,h2),c2)
		= (mx`,my`,[(i1,p1,(l1,t2,w1,h1),c1),item2])
		  where 
		  mx` = max maxx (l1 + w1)
		  my` = max maxy (t2 + h1)
		  l1  = l2 + w2  + ofs
		  

RightToRenter:: !Int !Int !Int !Int !ItPos ![CPos] -> (!Int,!Int,![CPos])
RightToRenter maxx maxy ofs id ipos [cpos=:(ic,rc):rest]
	| id <> ic
		= let! 
			strict1
		  in (mx1,my1,[cpos : rest`])
		= (mx2,my2,[cpos, (i1,(l1,t2,w1,h1)) : rest])
		  where 
		  (mx1,my1,rest`) = strict1
		  mx2             = max maxx (l1 + w1)
		  my2             = max maxy (t2 + h1)
		  l1              = l2 + w2  + ofs
		  (_,_,w1,h1)     = r1 
		  (l2,t2,w2,_)    = rc
		  (i1,_,r1,_)     = ipos
		  strict1         = RightToRenter maxx maxy ofs id ipos rest
		

PositionBelow:: !Int !Int !Int !Int !ItPos !ItPos -> (!Int,!Int,!ItPos)
PositionBelow maxx maxy ofs hmg item1=:(i1,p1,r1,c1) (i2,Center,r2,poss)
		= (mx`,my`,(i1,Center,(hmg,t1,w1,h1),c1))
		  where 
		  mx`         = max maxx (hmg + w1)
		  my`         = max maxy (t1 + h1)
		  t1          = t2 + h2  + ofs
		  (_,_,w1,h1) = r1
		  (_,t2,_,h2) = r2
		  
PositionBelow maxx maxy ofs hmg item1=:(i1,p1,r1,c1) (i2,Right,r2,poss)
		= (mx`,my`,(i1,Right,(hmg,t1,w1,h1),c1))
		  where 
		  mx`         = max maxx (hmg + w1)
		  my`         = max maxy (t1 + h1)
		  t1          = t2 + h2 + ofs
		  (_,_,w1,h1) = r1 
		  (_,t2,_,h2) = r2
		  
PositionBelow maxx maxy ofs hmg (i1,p1,(ld,td,w1,h1),c1) item2=:(i2,p2,(l2,t2,w2,h2),c2)
		= (mx`,my`,(i1,p1,(l2,t1,w1,h1),c1))
		  where 
		  mx` = max maxx (l2 + w1)
		  my` = max maxy (t1 + h1)
		  t1  = t2 + h2  + ofs
		  

RemoveItPos:: !Int ![ItPos] -> (!Bool,!ItPos,![ItPos])
RemoveItPos rid [ip=:(iid,Center,r,cits):rest]
	| rid <> iid && not (ItPosInRenterList rid cits)
		= let! 
			strict1
		  in (exists,pos,[ip:rest`])
		= (True,ip,rest)
		  where 
		  (exists,pos,rest`) = strict1
		  strict1            = RemoveItPos rid rest
RemoveItPos rid [ip=:(iid,Right,r,cits):rest]
	| rid <> iid && not (ItPosInRenterList rid cits)
		= let! 
			strict1
		  in (exists,pos,[ip:rest`])
		= (True,ip,rest)
		  where 
		  (exists,pos,rest`) = strict1
		  strict1            = RemoveItPos rid rest
RemoveItPos rid [ip=:(iid,p,r,c):rest]
	| rid <> iid
		= let! 
			strict1
		  in (exists,pos,[ip:rest`])
		= (True,ip,rest)
		  where 
		  (exists,pos,rest`) = strict1
		  strict1            = RemoveItPos rid rest
RemoveItPos rid [] 
		= (False,DummyItPos,[])

ItPosInRenterList:: !Int ![CPos] -> Bool
ItPosInRenterList iid [(cid,r):rest] 
	| iid == cid 
		= True
		= ItPosInRenterList iid rest
ItPosInRenterList iid [] 
		= False

Concat2:: [x] [x] -> [x]
Concat2 [x]   list 
		= [x:list]
Concat2 [x,y] list 
		= [x,y:list]

/*  After positioning the items the Center/Right items must be repositioned
		  according to the width of the dialog retrieved in the previous pass. */
RenterItems:: !Int !Int ![ItPos] ![ItPos] -> [ItPos]
RenterItems wid hmg [(id,Center,(l,t,w,h),cits):rest] poss
		= RenterItems wid hmg rest [(id,Center,(l + delta,t,w,h),cits`):poss]
		  where 
		  cits` = ShiftRenterItems delta cits
		  delta = (wid - ( RenterItemsmaxX (l + w) cits  + hmg)) / 2
		  
RenterItems wid hmg [(id,Right,(l,t,w,h),cits):rest] poss
		= RenterItems wid hmg rest [(id,Right,(l + delta,t,w,h),cits`):poss]
		  where 
		  cits` = ShiftRenterItems delta cits
		  delta = wid - ( RenterItemsmaxX (l + w) cits  + hmg)
		  
RenterItems wid hmg [item:rest] poss
		= RenterItems wid hmg rest [item:poss]
RenterItems wid hmg [] poss 
		= poss

ShiftRenterItems:: !Int ![CPos] -> [CPos]
ShiftRenterItems delta [(id,(l,t,w,h)):rest]
		= let! 
			strict1
		  in [(id,(l + delta,t,w,h)) : strict1]
		  where 
		  strict1 = ShiftRenterItems delta rest
ShiftRenterItems delta [] 
		= []

RenterItemsmaxX:: !Int ![CPos] -> Int
RenterItemsmaxX m [(id,(l,t,w,h)):rest]
		= RenterItemsmaxX (max m (l + w)) rest
RenterItemsmaxX m [] 
		= m

/*  After positioning/rentering the items the list of Rects must be transformed to
		  ItemBoxes, the items are positioned in the window as a side effect */
PositionItems:: !DialogPtr ![ItPos] ![DialogItem s io] -> DialogPtr
PositionItems wptr poss [DialogButton id pos txt s f : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss def=:[DialogIconButton id pos pd l s f : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [StaticText id pos txt : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [DynamicText id pos wid txt : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [EditText id pos wid nrl t : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [DialogPopUp id pos ab di buts : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [RadioButtons id pos roc di radios : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetRadioItemPositions (RadioBoxItemSize n roc ibox) ibox roc wptr radios
		  n            = length radios
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [CheckBoxes id pos roc boxes : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetCheckBoxItemPositions (RadioBoxItemSize n roc ibox) ibox roc wptr boxes
		  n            = length boxes
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss [Control id pos pd a s l f d : items]
		= PositionItems wptr` poss` items
		  where 
		  wptr`        = SetItemPosition ibox wptr id
		  (ibox,poss`) = GetItemPosition id poss
PositionItems wptr poss []
		= wptr

SetItemPosition:: !ItemPos !DialogPtr !Id -> DialogPtr
SetItemPosition (ItemBox l t w h) wptr id
		= OSWinSetDlgItemPos wptr id l t w h

SetRadioItemPositions:: (Int, Int) ItemPos RowsOrColumns !DialogPtr [RadioItemDef s io]  -> DialogPtr
SetRadioItemPositions (dx,dy) (ItemBox l t w h) (Rows nr) wptr radios
		= SetRadioItemPositionsH l t (w + l) l dx dy wptr radios
SetRadioItemPositions (dx,dy) (ItemBox l t w h) (Columns nr) wptr radios
		= SetRadioItemPositionsV l t (h + t) t dx dy wptr radios

SetRadioItemPositionsH:: !Int !Int !Int !Int !Int !Int !DialogPtr [RadioItemDef s io] -> DialogPtr
SetRadioItemPositionsH x y maxx minx dx dy wptr radios
	| x >= maxx
		= SetRadioItemPositionsH minx (y + dy) maxx minx dx dy wptr radios
SetRadioItemPositionsH x y maxx minx dx dy wptr [RadioItem id title state f : radios]
		= SetRadioItemPositionsH (x + dx) y maxx minx dx dy wptr` radios
		  where 
		  wptr` = OSWinSetDlgItemPos wptr id x y dx dy
SetRadioItemPositionsH x y maxx minx dx dy wptr radios
		= wptr

SetRadioItemPositionsV  :: !Int !Int !Int !Int !Int !Int !DialogPtr [RadioItemDef s io] -> DialogPtr
SetRadioItemPositionsV x y maxy miny dx dy wptr radios
	| y >= maxy 
		= SetRadioItemPositionsV (x + dx) miny maxy miny dx dy wptr radios
SetRadioItemPositionsV x y maxy miny dx dy wptr [RadioItem id title state f : radios]
		= SetRadioItemPositionsV x (y + dy) maxy miny dx dy wptr` radios
		  where 
		  wptr` = OSWinSetDlgItemPos wptr id x y dx dy
SetRadioItemPositionsV x y maxy miny dx dy wptr radios
		= wptr

SetCheckBoxItemPositions:: (Int,Int) ItemPos RowsOrColumns !DialogPtr [CheckBoxDef s io] -> DialogPtr
SetCheckBoxItemPositions (dx,dy) (ItemBox l t w h) (Rows nr) wptr radios
		= SetCheckBoxItemPositionsH l t (w + l) l dx dy wptr radios
SetCheckBoxItemPositions (dx,dy) (ItemBox l t w h) (Columns nr) wptr radios
		= SetCheckBoxItemPositionsV l t (h + t) t dx dy wptr radios

SetCheckBoxItemPositionsH:: !Int !Int !Int !Int !Int !Int !DialogPtr [CheckBoxDef s io] -> DialogPtr
SetCheckBoxItemPositionsH x y maxx minx dx dy wptr checks
	| x >= maxx
		= SetCheckBoxItemPositionsH minx (y + dy) maxx minx dx dy wptr checks
SetCheckBoxItemPositionsH x y maxx minx dx dy wptr [CheckBox id title state mark f : checks]
		= SetCheckBoxItemPositionsH (x + dx) y maxx minx dx dy wptr` checks
		  where 
		  wptr` = OSWinSetDlgItemPos wptr id x y dx dy
SetCheckBoxItemPositionsH x y maxx minx dx dy wptr checks
		= wptr

SetCheckBoxItemPositionsV:: !Int !Int !Int !Int !Int !Int !DialogPtr  [CheckBoxDef s io] -> DialogPtr
SetCheckBoxItemPositionsV x y maxy miny dx dy wptr checks
	| y >= maxy
		= SetCheckBoxItemPositionsV (x + dx) miny maxy miny dx dy wptr checks
SetCheckBoxItemPositionsV x y maxy miny dx dy wptr [CheckBox id title state mark f : checks]
		= SetCheckBoxItemPositionsV x (y + dy) maxy miny dx dy wptr` checks
		  where 
		  wptr` = OSWinSetDlgItemPos wptr id x y dx dy
SetCheckBoxItemPositionsV x y maxy miny dx dy wptr checks
		= wptr

GetItemPosition:: !Int ![ItPos] -> (!ItemPos,![ItPos])
GetItemPosition iid poss=:[pos=:(pid,ps=:Center,rect,cits):rest]
	| iid == pid
		= (ItemBox l t w h,poss)
	| inclist
		= (ibox,[(pid,ps,rect,cits`):rest])
		= (box,[pos:rest`])
		  where 
		  (inclist,ibox,cits`) = FindItemBoxInRenterList iid cits
		  (box,rest`)          = GetItemPosition iid rest
		  (l,t,w,h)            = rect
GetItemPosition iid poss=:[pos=:(pid,ps=:Right,rect,cits):rest]
	| iid == pid
		= (ItemBox l t w h,poss)
	| inclist 
		= (ibox,[(pid,ps,rect,cits`):rest])
		= (box,[pos:rest`])
		  where 
		  (inclist,ibox,cits`) = FindItemBoxInRenterList iid cits
		  (box,rest`)          = GetItemPosition iid rest
		  (l,t,w,h)            = rect
GetItemPosition iid [pos=:(pid,ps,rect,cits):rest]
	| iid == pid 
		= (ItemBox l t w h, rest)
		= (box,[pos:rest`])
		  where 
		  (box,rest`) = GetItemPosition iid rest
		  (l,t,w,h)   = rect
GetItemPosition iid []
		= abort "Error in GetItemPosition [dialogDevice]: Unknown item id."


FindItemBoxInRenterList:: !Int ![CPos] -> (!Bool,!ItemPos,![CPos])
FindItemBoxInRenterList iid [] = (False,Left,[])
FindItemBoxInRenterList iid [cpos=:(cid,rect):rest]
	| iid == cid 
		= (True,ItemBox l t w h,rest)
		= (found,box,[cpos:rest`])
		  where 
		  (found,box,rest`) = strict1
		  (l,t,w,h)         = rect
		  strict1           = FindItemBoxInRenterList iid rest

RadioBoxItemSize:: !Int !RowsOrColumns !ItemPos -> (!Int, !Int)
RadioBoxItemSize nrb (Rows nr) (ItemBox l t w h)
		= (Div w (UpDiv nrb nr), Div h nr)
RadioBoxItemSize nrb (Columns nc) (ItemBox l t w h)
		= (Div w nc, Div h (UpDiv nrb nc))

/*
	CheckDefaultRadioItemId:: !DialogItemId ![RadioItemDef s io] -> DialogItemId
	CheckDefaultRadioItemId did items=:[RadioItem fid tt ab df : rest]
			= CheckDefRadioItemId fid did items
	CheckDefaultRadioItemId did []
			= abort "Error in dialog definition: Empty list of RadioItems."
	
	CheckDefRadioItemId:: !DialogItemId !DialogItemId ![RadioItemDef s io] -> DialogItemId
	CheckDefRadioItemId fid did [RadioItem id tt ab df : rest]
		| id == did 
			= did
			= CheckDefRadioItemId fid did rest
	CheckDefRadioItemId fid did [] 
			= fid
*/
