implementation module deltaDialog		  

import StdEnv, oswindow, ostypes, misc, oskernel		  
from   deltaMenu import EnableMenuSystem, DisableMenuSystem		  
import dialogDef, dialogDevice, dialogAccess

::  DialogChange *s :== (DialogState s (IOState s)) ->  DialogState s (IOState s) 		  
::  Id              :== DialogItemId		  

AboutDialogID :== -1

Error rule mes id  :== abort ("Error in " +++  rule +++  " [deltaDialog]: " +++  mes +++  " " +++  toString id     )		  

/*  Opening/Closing of dialogs and notices. A beep is a very simple notice. */
OpenDialog:: !(DialogDef s (IOState s)) !(IOState s) -> IOState s		  
OpenDialog def=:(AboutDialog an pd fs hp) io = io		  
OpenDialog def io
	| modalactive 
		= io1		  
	| exists
		= io3		  
		= IOStateAddDialog dialog io2		  
	  where
		  (modalactive,io1) = IOStateModalDialogActive io		  
		  (exists,_,io2)    = IOStateGetDialog id io1		  
		  (_,io3)           = IOStateSetDialogInFront id io2		  
		  dialog            = NewDialog Modeless def		  
		  id                = GetDialogId def		  

		  GetDialogId:: !(DialogDef s io) -> DialogId		  
		  GetDialogId (CommandDialog id t a di items)
				= id		  
		  GetDialogId (PropertyDialog id t a f1 f2 items)
				= id		  
		  GetDialogId dialog
				= -1		  

OpenModalDialog:: !(DialogDef *s (IOState *s)) !*s !(IOState *s) -> (!*s, !IOState *s)		  
OpenModalDialog ddef=:(CommandDialog id title attrs ditem items) s io
		= DoModalIO s io`		  
		  where
		  io`    = IOStateAddDialog dialog io		  
		  dialog = NewDialog Modal ddef		  
OpenModalDialog ddef s io
		= (s,io)		  

CloseDialog:: !DialogId !(IOState s) -> IOState s		  
CloseDialog did io
	| not found           
		= io`		  
	| was_modal
		= IOStateAddDialog dialog` io`		  
		= io`		  
		  where
		  (was_modal,dialog`) = CloseTheDialog dialog		  
		  (found,dialog,io`)  = IOStateRemoveDialog did io		  

CloseActiveDialog:: !(IOState s) -> IOState s		  
CloseActiveDialog io
	| was_modal
		= IOStateAddDialog dialog` io`		  
		= io`		  
		  where
		  (was_modal,dialog`) = CloseTheDialog dialog		  
		  (_, dialog,io`)     = IOStateRemoveActiveDialog io		  

CloseTheDialog:: !(DialogHandle s io) -> (!Bool, !DialogHandle s io)		  
CloseTheDialog (id, modal, wptr, info, funs, osids)
		= let!
			wptr1 = OSWinTerminateDialog wptr modal			  
		  in (modal, (id, modal, wptr1, info, funs, osids))		  

OpenNotice:: !NoticeDef !(IOState s) -> (!NoticeButtonId, !IOState s)		  
OpenNotice notice io 
		= Open_Notice notice io		  

Beep:: !(IOState s) -> IOState s		  
Beep io = Evaluate_2 io (OSBeep 1 0)		  

/*  Get(Active)DialogInfo returns the DialogInfo for the indicated dialog.
		  The boolean indicates whether the indicated dialog exists. When it is FALSE
		  a		  dummy DialogInfo is returned. */ 
GetDialogInfo:: !DialogId !(IOState s) -> (!Bool, !DialogInfo, !IOState s)		  
GetDialogInfo id io = IOStateGetDialogInfo id io		  

GetActiveDialogInfo:: !(IOState s) -> (!Bool, !DialogInfo, !IOState s)		  
GetActiveDialogInfo io = IOStateGetActiveDialogInfo io		  

/*  Enabling/Disabling of dialog items */
EnableDialogItems:: ![DialogItemId] !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
EnableDialogItems itids state
		= DialogHandleToDialogState (id,mode,wptr`,info,funs, osids)		  
		  where
		  (id,mode,wptr,info,funs, osids) = DialogStateToDialogHandle state		  
		  wptr` = SetItemAbility itids wptr osids True		  

DisableDialogItems:: ![DialogItemId] !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
DisableDialogItems itids state
		= DialogHandleToDialogState (id,mode,wptr`,info,funs, osids)		  
		  where
		  (id,mode,wptr,info,funs, osids) = DialogStateToDialogHandle state		  
		  wptr` = SetItemAbility itids wptr osids False		  

SetItemAbility:: ![DialogItemId] !DialogPtr IdTable !Bool -> DialogPtr		  
SetItemAbility [id:ids] wptr osids able
		= let!
			wptr1 = OSWinEnableItem wptr (IdToOsId id osids) able
		  in SetItemAbility ids wptr1 osids able		  
SetItemAbility ids wptr osids able
		= wptr		  

IdsToOsIds ids osids
		= map (f osids) ids
		  where
		  f osids id = IdToOsId id osids
		
/*  Marking/Unmarking of check boxes. */
MarkCheckBoxes:: ![DialogItemId] !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
MarkCheckBoxes itids state
		= DialogHandleToDialogState (id,mode,wptr`,info`,funs, osids)		  
		  where		  
		  (id,mode,wptr,info,funs, osids) = DialogStateToDialogHandle state		  
		  wptr` = MarkBoxes itids wptr osids True		  
		  info` = UpdateCheckBoxInfos (IdsToOsIds itids osids) False info		  
		  
UnmarkCheckBoxes:: ![DialogItemId] !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
UnmarkCheckBoxes itids state
		= DialogHandleToDialogState (id,mode,wptr`,info`,funs, osids)		  
		  where		  
		  (id,mode,wptr,info,funs, osids) = DialogStateToDialogHandle state		  
		  wptr` = MarkBoxes itids wptr osids False		  
		  info` = UpdateCheckBoxInfos (IdsToOsIds itids osids) False info		  
		  
MarkBoxes:: ![DialogItemId] !DialogPtr IdTable !Bool -> DialogPtr		  
MarkBoxes [id:ids] wptr osids able
		= let!
			strict1 = OSWinSetButtonState wptr (IdToOsId id osids) able		  
		  in MarkBoxes ids strict1 osids able		  
MarkBoxes ids wptr osids able
		= wptr		  

UpdateCheckBoxInfos:: ![OsId] Bool ItemInfo -> ItemInfo		  
UpdateCheckBoxInfos ids mark (edits,radios,checks,ctrls,dynamics)
		= (edits,radios,checks`,ctrls,dynamics)		  
		  where		  
		  checks` = UpdateCheckBoxInfos` ids mark checks		  
		  
		  UpdateCheckBoxInfos`:: ![Id] Bool [(Id,Id,Bool)] ->  [(Id,Id,Bool)]		  
		  UpdateCheckBoxInfos` ids newmark [c =: (id,gid,mark) : rest]
			| isMember id ids 
				= [(id,gid,newmark) : rest]		  
				= [c:UpdateCheckBoxInfos` ids newmark rest]		  
		  UpdateCheckBoxInfos` ids newmark []
				= []		  

SelectDialogRadioItem:: !DialogItemId !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
SelectDialogRadioItem itemid  state
		= DialogHandleToDialogState (id,mode,wptr`,info`,funs, osids)		  
		  where		  
		  (id,mode,wptr,info,funs,osids) = DialogStateToDialogHandle state		  
		  (wptr`,info`)                  = SelectRadioItem (IdToOsId itemid osids) wptr info		  
		  
SelectRadioItem:: !OsId !DialogPtr ItemInfo -> (!DialogPtr, !ItemInfo)		  
SelectRadioItem id wptr (edits,radios,checks,ctrls,dynamics)
		= (wptr`,(edits,radios`,checks,ctrls,dynamics))		  
		  where		  
		  (wptr`,radios`) = SelectRadioItem` id wptr radios		  
		  
SelectRadioItem`:: Id DialogPtr [(Id,Bool,Int,[Id])] -> (!DialogPtr, [(Id,Bool,Int,[Id])])		  
SelectRadioItem` id wptr [r=: (id2,True,index,ids) : rest]
	| index` >= 0 
		= let!
			wptr` = OSWinSetButtonState wptr id True
		  in (wptr`,[(id2,True, index`, ids) : rest])		  
		= (wptr``, [r : rest`])		  
		  where		  
		  index`         = getindex id ids 0		  
		  (wptr``,rest`) = SelectRadioItem` id wptr rest		  

		  getindex :: Id [Id] Int -> Int		  
		  getindex id [id2 : ids] n
			| id == id2 
				= n		  
				= getindex id ids (inc n)		  
		  getindex id ids n
				= -1		  
SelectRadioItem` id wptr r
		= (wptr,r)

/*  Change the contents of an editable or a dynamic text field. */
ChangeEditText:: !DialogItemId !{#Char} !(DialogState s (IOState s)) -> DialogState s (IOState s)		
ChangeEditText itid text state
		= let!
			wptr` = OSWinSetItemText wptr osid text		  
		  in DialogHandleToDialogState (id,mode,wptr`,info`,funs,osids)		  
		  where		  
		  (id,mode,wptr,info,funs,osids) = DialogStateToDialogHandle state		  
		  osid                           = IdToOsId itid osids
		  info`                          = UpdateTextInfo1 osid text info		  
				 		  
		  
ChangeDynamicText:: !DialogItemId !{#Char} !(DialogState s (IOState s)) -> DialogState s (IOState s)		
ChangeDynamicText itid text state
		= let!
			wptr` = OSWinSetItemText wptr osid text
			info` = UpdateTextInfo2 osid text info	  
		  in DialogHandleToDialogState (id,mode,wptr`,info`,funs,osids)		  
		  where		  
		  (id,mode,wptr,info,funs,osids) = DialogStateToDialogHandle state		  
		  osid                           = IdToOsId itid osids
				  		  
		  
UpdateTextInfo1:: !OsId String ItemInfo -> ItemInfo		  
UpdateTextInfo1 id text (edits,radios,checks,ctrls,dynamics)
		= (edits`,radios,checks,ctrls,dynamics)		  
		  where		  
		  edits` = UpdateTextInfo` id text edits		  
		  
UpdateTextInfo2:: !OsId String ItemInfo -> ItemInfo		  
UpdateTextInfo2 id text (edits,radios,checks,ctrls,dynamics)
		= (edits,radios,checks,ctrls,dynamics`)		  
		  where		  
		  dynamics` = UpdateTextInfo` id text dynamics		  
		  
UpdateTextInfo`:: !Id String [(Id,String)] ->  [(Id,String)]		  
UpdateTextInfo` id newtext [c=:(id2,text) : rest]
	| id == id2 
		= [(id,newtext) : rest]		  
		= [ c : UpdateTextInfo` id newtext rest]		  
UpdateTextInfo` id newtext []
		= []		  

/*  Change the IconLook and redraw the IconButton */
ChangeIconLook:: !DialogItemId !IconLook !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeIconLook itemid look dstate
		= let!
			(wptr`,info`) = UpdateIconInfo wptr (IdToOsId itemid osids) look info		  
		  in DialogHandleToDialogState (id,mode,wptr`,info`,funs, osids)		  
		  where		  
		  (id,mode,wptr,info,funs, osids) = DialogStateToDialogHandle dstate		  
				  		  
		  
UpdateIconInfo:: DialogPtr !OsId !IconLook ItemInfo -> (!DialogPtr, !ItemInfo)		  
UpdateIconInfo wptr osid look (edits,radios,checks,ctrls,dynamics)
		= let!		  
		  	(wptr`,ctrls`) = UpdateControlLook` wptr osid (IconLookToControlLook look) ctrls		  
		  in (wptr`, (edits,radios,checks,ctrls`,dynamics))		  
		            
UpdateControlLook`:: DialogPtr !OsId !ControlLook [(Id,ControlInfo)] -> (DialogPtr, [(Id,ControlInfo)])		  
UpdateControlLook` wptr osid look [ic =: (id2,control) : controls]
	| osid == id2
		= let!
			wptr` = DrawDialogControlLook wptr osid control`	  
		  in (wptr`, [(id2,control`) : controls])
		  	with
				control`           = NewControlLook look control		  
		= (wptr``, [ic : controls`])
			with
				(wptr``,controls`) = UpdateControlLook` wptr osid look controls		  
UpdateControlLook` wptr osid look controls
	= (wptr, controls)		  

NewControlLook:: ControlLook ControlInfo -> ControlInfo		  
NewControlLook look (pic,state,oldlook,feel)
		= (pic,state,look,feel)		  

::	ControlUpdateFunction:== OsId ControlInfo DialogPtr -> (ControlInfo,DialogPtr)

UpdateControl:: !OsId !ControlUpdateFunction !ItemInfo !DialogPtr -> (!ItemInfo,!DialogPtr)	
UpdateControl id update_function (edits,radios,checks,control_infos0,dynamics) dialog_pointer0
	= ((edits,radios,checks,control_infos1,dynamics),dialog_pointer1)
	where
		(control_infos1,dialog_pointer1) = UpdateControlInfo id update_function control_infos0 dialog_pointer0

		UpdateControlInfo:: !OsId !ControlUpdateFunction ![(Id,ControlInfo)] !DialogPtr -> (![(Id,ControlInfo)],!DialogPtr)		  	
		UpdateControlInfo id update_function [c=:(id2,control_info0) : controls] dialog_pointer0
			| id==id2
				= ([(id2,control_info1) : controls],dialog_pointer1)
				with
					(control_info1,dialog_pointer1) = update_function id control_info0 dialog_pointer0
				= ([c : controls1],dialog_pointer1)
				with
					(controls1,dialog_pointer1)=UpdateControlInfo id update_function controls dialog_pointer0;
		UpdateControlInfo id update_function controls dialog_pointer0
			= ([],dialog_pointer0);

/*  Change the ControlState and redraw the Control */
ChangeControlState  :: !DialogItemId !ControlState !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeControlState cid cstate dstate
	= DialogHandleToDialogState (id,mode,dialog_pointer1,info1,funs,osids)
	where
		(info1,dialog_pointer1) = UpdateControl control_os_id (ChangeControlStateInInfoAndRedraw cstate) info0 dialog_pointer0
		control_os_id = IdToOsId cid osids
		(id,mode,dialog_pointer0,info0,funs,osids) = DialogStateToDialogHandle dstate

		ChangeControlStateInInfoAndRedraw :: ControlState OsId ControlInfo DialogPtr -> (!ControlInfo,!DialogPtr)
		ChangeControlStateInInfoAndRedraw control_state control_os_id (picture_domain,_,control_look,control_feel) dialog_pointer0
			= (control_info,DrawDialogControlLook dialog_pointer0 control_os_id control_info)
			where
				control_info=(picture_domain,control_state,control_look,control_feel)		

/*  Change the ControlLook and redraw the Control */
ChangeControlLook:: !DialogItemId !ControlLook !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeControlLook cid clook dstate
	= DialogHandleToDialogState (id,mode,dialog_pointer1,info1,funs,osids)
	where
		(info1,dialog_pointer1) = UpdateControl control_os_id (ChangeControlLookInInfoAndRedraw clook) info0 dialog_pointer0
		control_os_id = IdToOsId cid osids
		(id,mode,dialog_pointer0,info0,funs,osids) = DialogStateToDialogHandle dstate

		ChangeControlLookInInfoAndRedraw :: ControlLook OsId ControlInfo DialogPtr -> (!ControlInfo,!DialogPtr)
		ChangeControlLookInInfoAndRedraw control_look control_os_id (picture_domain,control_state,_,control_feel) dialog_pointer0
			= (control_info,DrawDialogControlLook dialog_pointer0 control_os_id control_info)
			where
				control_info=(picture_domain,control_state,control_look,control_feel)		

/*  Change the ControlFeel, but dont redraw the Control */
ChangeControlFeel:: !DialogItemId !ControlFeel !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeControlFeel cid cfeel dstate
	= DialogHandleToDialogState (id,mode,dialog_pointer1,info1,funs,osids)
	where
		(info1,dialog_pointer1) = UpdateControl control_os_id (ChangeControlFeelInInfo cfeel) info0 dialog_pointer0
		control_os_id = IdToOsId cid osids
		(id,mode,dialog_pointer0,info0,funs,osids) = DialogStateToDialogHandle dstate

		ChangeControlFeelInInfo :: ControlFeel OsId ControlInfo DialogPtr -> (!ControlInfo,!DialogPtr)
		ChangeControlFeelInInfo control_feel control_os_id (picture_domain,control_state,control_look,_) dialog_pointer0
			= ((picture_domain,control_state,control_look,control_feel),dialog_pointer0)

/*  Change the DialogFunction of a check box, a radio button or a user-defined control. */
ChangeDialogFunction:: !DialogItemId !(DialogFunction s (IOState s)) !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeDialogFunction itemid dfunc dstate
		= ChangeItemFunction itemid (ItemDialogFunction dfunc) dstate		  

ChangeButtonFunction:: !DialogItemId !(ButtonFunction s (IOState s)) !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeButtonFunction id f dstate
		= ChangeItemFunction id (ItemButtonFunction f) dstate		  
		
ChangeSetFunction:: !(SetFunction s (IOState s)) !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeSetFunction f dstate
		= ChangeButtonFunction SetId f dstate		  

ChangeResetFunction:: !(ResetFunction s (IOState s)) !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ChangeResetFunction f dstate
		= ChangeButtonFunction ResetId f dstate		  

ChangeItemFunction:: !Id !(ItemFunction s io) !(DialogState s io) -> DialogState s io		  
ChangeItemFunction itemid f dstate
		= DialogHandleToDialogState (id,mode,wptr,info,funs`, osids)		  
		  where		  
		  (id,mode,wptr,info,funs,osids) = DialogStateToDialogHandle dstate		  
		  funs` = UpdateItemFunction (IdToOsId itemid osids) f funs		  
		  
UpdateItemFunction:: !OsId !(ItemFunction s io) ![(OsId,ItemFunction s io)] -> [(OsId,ItemFunction s io)]		  
UpdateItemFunction id newf [item=:(id2,f) : items]
	| id == id2
		= [(id2,newf) : items]		  
		= [item : UpdateItemFunction id newf items]		  
UpdateItemFunction id newf items
		= []		    

/* DialogStateGetDialogInfo returns the DialogInfo corresponding to
		  the DialogState given to it. */
DialogStateGetDialogInfo:: !(DialogState s (IOState s)) -> (!DialogInfo, !DialogState s (IOState s))		  
DialogStateGetDialogInfo state
		= DialogStateToDialogInfo state		  

/*  Functions that retrieve information from the DialogInfo. */
GetEditText:: !DialogItemId !DialogInfo -> {#Char}
GetEditText tid dinfo
		= RetrieveEditText (IdToOsId tid idtable) edits		  
		  where		  
		  ((edits,_,_,_,_), idtable) = DialogInfoToItemInfo dinfo		  
		  
RetrieveEditText:: !DialogItemId ![(DialogItemId,String)] -> String		  
RetrieveEditText tid [(id,text):rest]
	| id == tid 
		= text		  
		= RetrieveEditText tid rest		  
RetrieveEditText tid []
		= Error "GetEditText" "No EditText item found with id" tid		  

/* tid = FiguresId = group of radio buttons 
		  dinfo = dialog = active dialog */
GetSelectedRadioItemId:: !DialogItemId !DialogInfo -> DialogItemId		  
GetSelectedRadioItemId tid dinfo
		= OsIdToId (RetrieveRadioItemId (IdToOsId tid idtable) radios) idtable
		  where		  
		  ((_,radios,_,_,_),idtable) = DialogInfoToItemInfo dinfo		  
		  
/* tid = FiguresId= groep van radio buttons */
/* gevolg door een lijst van een (FiguresId ,radiobuttonid) */
RetrieveRadioItemId:: !OsId ![(OsId,Bool,Int,[OsId])] -> OsId		  
RetrieveRadioItemId tid [(id,b,i,ids):rest]
	| id == tid 
		= GetRadioId i ids 		  
		= RetrieveRadioItemId tid rest		  
RetrieveRadioItemId tid []
		= Error "GetSelectedRadioItemId" "No RadioButtons or DialogPopUp item found with id" tid		  

GetRadioId:: Int [DialogItemId] -> DialogItemId		  
GetRadioId 0 [id:ids] = id		  
GetRadioId n []       = -1		  
GetRadioId n [id:ids] = GetRadioId (dec n) ids		  

CheckBoxesMarked:: !DialogItemId !DialogInfo -> [(DialogItemId,Bool)]		  
CheckBoxesMarked tid dinfo 
		= RetrieveCheckMarks (IdToOsId tid idtable) checks idtable  
		  where		  
		  ((_,_,checks,_,_), idtable) = DialogInfoToItemInfo dinfo		  
		  
RetrieveCheckMarks:: !OsId ![(OsId,OsId,Bool)] IdTable -> [(DialogItemId,Bool)]		  
RetrieveCheckMarks tid [(id,gid,mark):rest] idtable
	| tid == gid 
		= [(OsIdToId id idtable,mark) : RetrieveCheckMarks tid rest idtable]		  
		= RetrieveCheckMarks tid rest idtable		  
RetrieveCheckMarks tid [] idtable
		= []		  

CheckBoxMarked:: !DialogItemId !DialogInfo -> Bool		  
CheckBoxMarked tid dinfo
		= RetrieveCheckMark (IdToOsId tid idtable) checks		  
		  where		  
		  ((_,_,checks,_,_),idtable) = DialogInfoToItemInfo dinfo		  
		  
RetrieveCheckMark:: !OsId ![(OsId,OsId,Bool)] -> Bool		  
RetrieveCheckMark tid [(id,gid,mark):rest]
	| tid == id 
		= mark		  
		= RetrieveCheckMark tid rest		  
RetrieveCheckMark tid []
		= Error "CheckBoxMarked" "No CheckBox item found with id" tid		  

GetControlState:: !DialogItemId !DialogInfo -> ControlState		  
GetControlState tid dinfo
		= RetrieveControlState (IdToOsId tid idtable) ctrls		  
		  where		  
		  ((_,_,_,ctrls,_),idtable) = DialogInfoToItemInfo dinfo		  
		  
RetrieveControlState:: !Id ![(Id,ControlInfo)] -> ControlState		  
RetrieveControlState tid [(id,(pic,state,look,feel)):rest]
	| id == tid 
		= state		  
		= RetrieveControlState tid rest		  
RetrieveControlState tid []
		= Error "GetControlState" "No Control item found with id" tid		  

/*  Change the dialog with the specified id according to the list of change functions. */
ChangeDialog:: !DialogId ![DialogChange s] !(IOState s) -> IOState s		  
ChangeDialog did changes io
	| not found
		= io`		  
		= IOStateReplaceDialog did (DialogStateToDialogHandle dialog`) io`		  
		  where		  
		  dialog`            = ApplyDialogChanges changes (DialogHandleToDialogState dialog)		  
		  (found,dialog,io`) = IOStateGetDialog did io		  

ApplyDialogChanges:: ![DialogChange s] !(DialogState s (IOState s)) -> DialogState s (IOState s)		  
ApplyDialogChanges [change:rest] dstate
		= ApplyDialogChanges rest (change dstate)		  
ApplyDialogChanges [] dstate
		= dstate		  

