/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package resources;
import java.io.*;
/**
 *
 * @author  Colin
 */
public class Textbook implements Constants, Comparable, Serializable {
    
    private String title = "";
    private String edition = "";  
    private String author = "";
    private String publisher = "";
    private String year = "";
    private String isbn = "";
    
    /** Creates a new instance of Textbook */
    public Textbook(String title, String edition, String author,
       String publisher, String year, String isbn) {
                        
        this.title = title;
        this.edition = edition;
        this.author = author;
        this.publisher = publisher;
        this. year = year;
        this.isbn = isbn;
    }
    public String getTitle(){
        return title;
    }
    public String getEdition (){
        return edition;
    }
    public String getAuthor(){
        return author;
    }
    public String getPublisher(){
        return publisher;
    }
    public String getYear(){
        return year;
    }
    public String getISBN(){
        return isbn;
    }
    public boolean equals(Object obj) {        
        if (!(obj instanceof Textbook)){
            return false;
        }
        
        if (title.equals( ((Textbook)obj).title) &&
            isbn.equals( ((Textbook)obj).isbn))
            return true;
        return false;
    }
    
    public String toString() {
        return title + ", " + edition + ", " + author + ", " 
            + publisher + ", " + year + ". " + isbn;
    }
    
    // todo Make the books sortable
    public int compareTo(Object obj) {
        return 0;
    }
    
}
