/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package resources;

import java.io.*;

/**
 * This class contains information regarding a conflict
 * between 2 <code>Sched</code> objects.  The reason detected, eg.,
 * professor or the room has been double-booked is also
 * maintained here.
 */

public class Conflict implements Constants, Serializable {
    static final long serialVersionUID = 911;
    
    private SchedCourse sched1, sched2;
    private int   reasonForConflict;
    
    /**
     * @param sched1 the schedule1
     * @param sched2 the schedule2
     * @param reason
     */
    
    public Conflict(SchedCourse sched1, SchedCourse sched2, int reason) {
        this.sched1 = sched1;
        this.sched2 = sched2;
        this.reasonForConflict = reason;
    }
    
    /**
     * Gets the Reason
     * @return an <code>integer</code> specifying the conflict reason code
     */
    
    public int getReason() {
        return reasonForConflict;
    }
    
    /**
     * Gets Schedule 1
     * @return an <code>Sched</code> specifying the schedule 1
     */
    
    public SchedCourse getSched1() {
        return sched1;
    }
    
    /**
     * Gets Schedule 2
     * @return an <code>Sched</code> specifying the schedule 2
     */
    
    public SchedCourse getSched2() {
        return sched2;
    }
    
    /**
     * a string is formatted to translate the conflict reason codes
     * into self explanatory descriptions
     */
    
    public String toString() {
        String temp = "Conflict: ";
        
        if (reasonForConflict == ROOM_DOUBLE_BOOKED) {
            temp += "Room double-booked\n";
        } else if (reasonForConflict == PROF_DOUBLE_BOOKED) {
            temp += "Professor is double-booked\n";
        }
        
        temp += sched1.toString() + "\n";
        temp += sched2.toString();
        temp += "\n\n";
        
        return temp;
    }
}

