/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import resources.CRTime;
import resources.CRTimeException;
import resources.Classroom;
import resources.Conflict;
import resources.Course;
import resources.Professor;
import resources.Textbook;
import resources.TimeSlot;

public class SchedCourse
implements Comparable,
Serializable {
    static final long serialVersionUID = 911L;
    public static final int PROFESSOR = 0;
    public static final int CLASSROOM = 1;
    private Professor professor;
    private Classroom classroom;
    private Course course;
    private TimeSlot timeSlot;
    private String crn = "";
    private Conflict conflict = null;
    private Textbook book = null;
    private String note = "";
    private static final int BY_COURSE = 1;
    private static final int BY_PROFESSOR = 2;
    private static final int BY_ROOM = 3;
    private static final int BY_START_TIME = 4;
    private static int sortKey = 1;

    public SchedCourse(Professor professor, Classroom classroom, Course course, TimeSlot timeSlot) {
        this.professor = professor;
        this.classroom = classroom;
        this.course = course;
        this.timeSlot = timeSlot;
    }

    public SchedCourse(Professor professor, Classroom classroom, Course course, TimeSlot timeSlot, String crn) {
        this.professor = professor;
        this.classroom = classroom;
        this.course = course;
        this.timeSlot = timeSlot;
        this.crn = crn;
    }

    public static void setSortKey(int key) {
        if (key >= 1 && key <= 3) {
            sortKey = key;
        }
    }

    public void setProfessor(Professor professor) {
        this.professor = professor;
    }

    public void setClassroom(Classroom classroom) {
        this.classroom = classroom;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public void setTimeSlot(TimeSlot timeSlot) {
        this.timeSlot = timeSlot;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public void setTextbook(Textbook book) {
        this.book = book;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Professor getProfessor() {
        return this.professor;
    }

    public Classroom getClassroom() {
        return this.classroom;
    }

    public Course getCourse() {
        return this.course;
    }

    public TimeSlot getTimeSlot() {
        return this.timeSlot;
    }

    public void setConflict(Conflict c) {
        this.conflict = c;
    }

    public Conflict getConflict() {
        return this.conflict;
    }

    public String getCrn() {
        return this.crn;
    }

    public Textbook getTextbook() {
        return this.book;
    }

    public String getNote() {
        return this.note;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof SchedCourse)) {
            return 0;
        }
        SchedCourse sched2 = (SchedCourse)obj;
        if (sortKey == 1) {
            return this.course.compareTo(sched2.course);
        }
        if (sortKey == 2) {
            return this.professor.compareTo(sched2.professor);
        }
        if (sortKey == 3) {
            return this.classroom.compareTo(sched2.classroom);
        }
        if (sortKey == 4) {
            return this.timeSlot.getStartTime().compareTo(sched2.timeSlot.getStartTime());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchedCourse)) {
            return false;
        }
        SchedCourse that = (SchedCourse)obj;
        return this.classroom.equals(that.classroom) && this.course.equals(that.course) && this.timeSlot.equals(that.timeSlot) && this.crn.equals(that.crn);
    }

    public String toString() {
        int i;
        int i2;
        StringBuffer hold = new StringBuffer(100);
        char space = ' ';
        int crnWidth = 6;
        int courseWidth = 40;
        int professorWidth = 20;
        int timeSlotWidth = 20;
        int roomWidth = 12;
        hold.append(this.crn);
        for (i2 = this.crn.length(); i2 < crnWidth; ++i2) {
            hold.append(space);
        }
        hold.append(this.course.toString());
        for (i2 = this.course.toString().length(); i2 < courseWidth; ++i2) {
            hold.append(space);
        }
        String slot = this.timeSlot.toString();
        hold.append(slot);
        for (i = this.timeSlot.toString().length(); i < timeSlotWidth; ++i) {
            hold.append(space);
        }
        hold.append(this.classroom.toString());
        for (i = this.classroom.toString().length(); i < roomWidth; ++i) {
            hold.append(space);
        }
        hold.append(this.professor.toString());
        for (i = this.professor.toString().length(); i < professorWidth; ++i) {
            hold.append(space);
        }
        if (this.conflict != null) {
            hold.append("  ***");
        }
        return hold.toString();
    }

    public void drawGraphical(Graphics g, int whatChart, Rectangle drawArea) {
        int colWidth = drawArea.width / 6;
        int left = drawArea.x;
        int top = drawArea.y;
        double heightRatio = (double)drawArea.height / 900.0;
        boolean[] days = this.timeSlot.getDaysOfWeek();
        for (int i = 2; i < days.length; ++i) {
            if (!days[i]) continue;
            Rectangle r = new Rectangle((i - 2) * colWidth + left, (int)((double)top + (double)this.timeSlot.getStartTime().getcrMinutes() * heightRatio), colWidth, (int)((double)this.timeSlot.getMinutes() * heightRatio));
            g.drawRect(r.x, r.y, r.width, r.height);
            this.drawText(g, r, whatChart);
        }
    }

    public void drawText(Graphics g, Rectangle r, int whatChart) {
        FontMetrics fm = g.getFontMetrics();
        int textX = r.x + 1;
        int height = fm.getHeight();
        int textY = r.y + height - 3;
        g.drawString(this.course.getField() + " " + this.course.getCourseNumber() + " " + this.course.getSectionPrefix() + this.course.getSectionNumber(), textX, textY);
        int countChars = this.charsThatFit(this.course.getCourseName(), r, fm);
        g.drawString(this.course.getCourseName().substring(0, countChars), textX, textY += height);
        textY += height;
        int wid = 0;
        if (whatChart != 0) {
            g.drawString(this.professor.getLastName() + " ", textX, textY);
            wid = fm.stringWidth(this.professor.getLastName());
        }
        if (whatChart != 1) {
            g.drawString(this.classroom.toString() + " ", textX, textY);
            wid = fm.stringWidth(this.classroom.toString());
        }
        g.drawString(" " + this.timeSlot.toTimeString(), textX + wid, textY);
    }

    private int charsThatFit(String s, Rectangle r, FontMetrics fm) {
        int wid;
        int charCount = 0;
        for (wid = 0; wid < r.width && charCount < s.length(); wid += fm.charWidth(s.charAt(charCount++))) {
        }
        if (wid > r.width) {
            --charCount;
        }
        return charCount;
    }

    public boolean overlap(SchedCourse sc) {
        return this.timeSlot.overlap(sc.timeSlot);
    }

    public static void main(String[] a) {
        Professor colin = new Professor("Colin", "Archibald", 1);
        System.out.println(" a prof: " + colin);
        Classroom room = new Classroom("7", "129", 24);
        System.out.println(" a room: " + room);
        Course course = new Course("COP", "2700", "Intro to Java", "W", 1, 3);
        System.out.println(" a course: " + course);
        CRTime start = null;
        CRTime stop = null;
        boolean[] days = new boolean[]{false, false, true, false, true, true, true, false};
        try {
            start = new CRTime(299);
            stop = new CRTime(350);
        }
        catch (CRTimeException crtE) {
            System.out.println(crtE);
        }
        TimeSlot slot = new TimeSlot(days, start, stop);
        System.out.println("a time slot: " + slot);
    }
}

