/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import panels.TableSorter;
import resources.Textbook;

public class BookPanel
extends JPanel
implements Observer {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private BooksPanelListener booksPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private BookTableModel btm;

    public BookPanel() {
        this.initComponents();
        this.btm = new BookTableModel();
        TableSorter sorter = new TableSorter(this.btm);
        sorter.addMouseListenerToHeaderInTable(this.jTable1);
        this.jTable1.setModel(sorter);
        this.addListeners();
        this.setColumnSizes();
    }

    private void setColumnSizes() {
        TableColumn column = null;
        column = this.jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = this.jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(10);
        column = this.jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
        column = this.jTable1.getColumnModel().getColumn(3);
        column.setPreferredWidth(50);
        column = this.jTable1.getColumnModel().getColumn(4);
        column.setPreferredWidth(20);
        column = this.jTable1.getColumnModel().getColumn(5);
        column.setPreferredWidth(50);
        int avail = this.jTable1.getWidth();
        System.out.println("You've got " + avail + " available to work");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jTextField5 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton2 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Delete Selected Book(s)");
        this.jButton1.setMaximumSize(new Dimension(175, 26));
        this.jButton1.setMinimumSize(new Dimension(250, 26));
        this.jButton1.setPreferredSize(new Dimension(175, 26));
        this.jPanel3.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(17, 17, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new BevelBorder(0)));
        this.jLabel1.setText("Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(17, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Edition:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Author:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Publisher:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("Year:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("ISBN:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BookPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.insets = new Insets(17, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new Insets(6, 6, 0, 18);
        this.jPanel2.add((Component)this.jTextField6, gridBagConstraints);
        this.jButton2.setText("Add Book");
        this.jPanel4.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 17, 0);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(17, 17, 0, 17);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void addListeners() {
        this.booksPanelListener = new BooksPanelListener();
        this.jButton1.addActionListener(this.booksPanelListener);
        this.jButton2.addActionListener(this.booksPanelListener);
    }

    public void update(Observable observable, Object obj) {
        this.btm.fireTableDataChanged();
    }

    public class BookTableModel
    extends AbstractTableModel {
        private Schedule schedule;
        final String[] columnNames = new String[]{"Title", "Ed.", "Author", "Publisher", "Year", "ISBN"};

        public BookTableModel() {
            this.schedule = Schedule.getSchedule();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.schedule.getBooks().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int c) {
            return " ".getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValueAt(int row, int col) {
            Textbook book = (Textbook)this.schedule.getBooks().get(row);
            switch (col) {
                case 0: {
                    return book.getTitle();
                }
                case 1: {
                    return book.getEdition();
                }
                case 2: {
                    return book.getAuthor();
                }
                case 3: {
                    return book.getPublisher();
                }
                case 4: {
                    return book.getYear();
                }
                case 5: {
                    return book.getISBN();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            this.fireTableCellUpdated(row, col);
        }
    }

    class BooksPanelListener
    implements ActionListener {
        BooksPanelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear |" + e.getActionCommand() + "|");
            if (e.getActionCommand().equals("Add Book")) {
                String title = BookPanel.this.jTextField1.getText().trim();
                String edition = BookPanel.this.jTextField2.getText().trim();
                String author = BookPanel.this.jTextField3.getText().trim();
                String publisher = BookPanel.this.jTextField4.getText().trim();
                String year = BookPanel.this.jTextField5.getText().trim();
                String isbn = BookPanel.this.jTextField6.getText().trim();
                if (title.equals("") && author.equals("")) {
                    return;
                }
                Textbook myBook = new Textbook(title, edition, author, publisher, year, isbn);
                System.out.println(myBook);
                BookPanel.this.schedule.addBook(myBook);
                BookPanel.this.jTextField1.setText("");
                BookPanel.this.jTextField2.setText("");
                BookPanel.this.jTextField3.setText("");
                BookPanel.this.jTextField4.setText("");
                BookPanel.this.jTextField5.setText("");
                BookPanel.this.jTextField6.setText("");
            } else if (e.getActionCommand().equals("Modify Book")) {
                System.out.println("I'm Modifying a book over here");
            } else if (e.getActionCommand().equals("Delete Selected Book(s)")) {
                System.out.println("I'm deleting a book over here");
            }
        }
    }
}

