/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.DummySchedule;
import application.Overview;
import application.Schedule;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class HandlerMenu
implements ActionListener {
    private Schedule schedule = Schedule.getSchedule();
    private JFrame parentWindow;

    public HandlerMenu(JFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Save") {
            if (this.schedule.getScheduleName().equals("Untitled.crs")) {
                this.runSaveDialog("File Save Dialog");
            } else {
                this.saveDocument(this.schedule.getDirectory(), this.schedule.getScheduleName());
            }
        } else if (e.getActionCommand() == "Save As...") {
            this.runSaveDialog("File Save Dialog");
        } else if (e.getActionCommand() == "Export CSV (spreadsheet)...") {
            this.runExportCsv();
        } else if (e.getActionCommand() == "New") {
            this.checkForSave();
            this.schedule.resetSchedule(null, "Untitled.crs");
        } else if (e.getActionCommand() == "Open...") {
            if (this.schedule != null) {
                this.checkForSave();
            }
            this.runOpenDialog("Open Schedule");
        } else if (e.getActionCommand() == "Exit") {
            if (this.checkForSave()) {
                System.exit(0);
            }
        } else if (e.getActionCommand() == "How to Use") {
            new Overview((Frame)this.parentWindow, true).setVisible(true);
        } else if (e.getActionCommand() == "Example Schedule") {
            this.makeDummySchedule();
        } else if (e.getActionCommand() == "About") {
            JOptionPane.showMessageDialog(this.parentWindow, "Classroom Scheduler Version 2.0  Released December 4, 2004\n\n Comments to Colin Archibald, PhD\narchibald@cfl.rr.com\n\nReleased under the Free Academic Lisence 2.0\n", "About Classroom Scheduler", 1);
        }
        this.parentWindow.setTitle("Classroom Scheduler: " + this.schedule.getScheduleName() + this.schedule.updated());
    }

    private void runExportCsv() {
        File csvFile = null;
        try {
            String name = this.schedule.getScheduleName();
            int dot = name.indexOf(46);
            String csvName = dot != -1 ? name.substring(0, dot) + ".csv" : name + ".csv";
            JFileChooser saveDialog = new JFileChooser("Export CSV File");
            CsvFileFilter select = new CsvFileFilter();
            saveDialog.addChoosableFileFilter(select);
            saveDialog.setFileFilter(select);
            saveDialog.setSelectedFile(new File(this.schedule.getDirectory(), csvName));
            int result = saveDialog.showSaveDialog(this.parentWindow);
            if (result == 1) {
                return;
            }
            csvName = saveDialog.getSelectedFile().getName();
            if (csvName != null) {
                if (!(csvName = csvName.trim()).endsWith(".csv")) {
                    csvName = csvName + ".csv";
                }
                csvFile = new File(saveDialog.getCurrentDirectory(), csvName);
                this.schedule.exportCsv(csvFile);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.parentWindow, "Failed to write the file" + csvFile + "\n" + ioe);
        }
    }

    private void runOpenDialog(String dlgTitle) {
        File inputFile;
        JFileChooser openDialog = new JFileChooser(dlgTitle);
        CrsFileFilter select = new CrsFileFilter();
        openDialog.addChoosableFileFilter(select);
        openDialog.setFileFilter(select);
        int returnVal = openDialog.showOpenDialog(this.parentWindow);
        if (returnVal == 0 && (inputFile = openDialog.getSelectedFile()) != null) {
            this.loadDocument(inputFile);
        }
    }

    private boolean runSaveDialog(String dlgTitle) {
        String fileName = this.schedule.getScheduleName();
        JFileChooser saveDialog = new JFileChooser(dlgTitle);
        CrsFileFilter select = new CrsFileFilter();
        saveDialog.addChoosableFileFilter(select);
        saveDialog.setFileFilter(select);
        saveDialog.setSelectedFile(new File(this.schedule.getDirectory(), fileName));
        int result = saveDialog.showSaveDialog(this.parentWindow);
        if (result == 1) {
            return false;
        }
        fileName = saveDialog.getSelectedFile().getName();
        if (fileName != null) {
            int response;
            File writeThisOne;
            if (!(fileName = fileName.trim()).endsWith(".crs")) {
                fileName = fileName + ".crs";
            }
            if ((writeThisOne = new File(saveDialog.getCurrentDirectory(), fileName)).exists() && (response = JOptionPane.showConfirmDialog(this.parentWindow, "The file exists. Overwrite?", "File Exists", 0)) == 1) {
                return false;
            }
            this.schedule.setScheduleName(fileName);
            String directory = saveDialog.getCurrentDirectory().toString();
            this.schedule.setDirectory(directory);
            this.parentWindow.setTitle("CPAScheduler: " + fileName + this.schedule.updated());
            this.saveDocument(directory, fileName);
        }
        return true;
    }

    protected void saveDocument(String directory, String fileName) {
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(new FileOutputStream(new File(directory, fileName)));
            objectOut.writeObject(this.schedule);
            this.schedule.setChanged(false);
        }
        catch (IOException eOutput) {
            JOptionPane.showMessageDialog(this.parentWindow, "File Write Error" + eOutput.toString());
        }
    }

    protected boolean checkForSave() {
        if (this.schedule.getChanged()) {
            int response = JOptionPane.showConfirmDialog(this.parentWindow, "The schedule has changed. Save the changes?", "Schedule changed", 1);
            if (response == 2) {
                return false;
            }
            if (response == 0) {
                if (this.schedule.getScheduleName().equals("Untitled.crs")) {
                    if (!this.runSaveDialog("File Save Dialog")) {
                        return false;
                    }
                } else {
                    this.saveDocument(this.schedule.getDirectory(), this.schedule.getScheduleName());
                }
            }
        }
        return true;
    }

    protected void loadDocument(File inputFile) {
        if (inputFile != null) {
            Schedule localSchedule = null;
            try {
                ObjectInputStream objectIn = new ObjectInputStream(new FileInputStream(inputFile));
                localSchedule = (Schedule)objectIn.readObject();
            }
            catch (IOException eInput) {
                JOptionPane.showMessageDialog(this.parentWindow, "File Read Error" + eInput);
            }
            catch (ClassNotFoundException eNoClass) {
                JOptionPane.showMessageDialog(this.parentWindow, "File Read Error - Class not Found?" + eNoClass);
            }
            localSchedule.setDirectory(inputFile.getParent());
            this.schedule.resetSchedule(localSchedule, inputFile.getName());
        }
    }

    private void makeDummySchedule() {
        DummySchedule.makeDummySchedule();
    }

    public class CsvFileFilter
    extends FileFilter {
        private String description;

        public boolean accept(File pathname) {
            this.description = new String("Comma Seperated Value Files (*.csv)");
            return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(".csv");
        }

        public String getDescription() {
            return this.description;
        }
    }

    public class CrsFileFilter
    extends FileFilter {
        private String description;

        public boolean accept(File pathname) {
            this.description = new String("Scheduler Files (*.crs)");
            return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(".crs");
        }

        public String getDescription() {
            return this.description;
        }
    }
}

