/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.HandlerMenu;
import application.Schedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import panels.CoursesPanel;
import panels.ModifySchedule;
import panels.ProfessorsPanel;
import panels.RoomsPanel;
import panels.ScheduleConflicts;
import panels.ScheduleCoursePanel;
import panels.ScheduleSummary;
import panels.TimeSlotsPanel;
import panels.ViewCharts;

public class ClassroomSchedulerFrame
extends JFrame {
    private HandlerMenu handlerMenu = new HandlerMenu(this);
    private JTabbedPane tabPane;

    public ClassroomSchedulerFrame(String title) {
        super(title);
        this.setDefaultCloseOperation(0);
        this.changeTheIcon();
        this.setupJFrame();
        this.addMenusToFrame();
        this.addPanelsToFrame();
        this.setVisible(true);
        this.requestFocus();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                Dimension d = ClassroomSchedulerFrame.this.getSize();
                if (d.getWidth() < 700.0 || d.getHeight() < 540.0) {
                    ClassroomSchedulerFrame.this.setSize(new Dimension(700, 540));
                }
            }
        });
    }

    private void changeTheIcon() {
        ImageIcon img;
        URL imgPath1 = ClassroomSchedulerFrame.class.getProtectionDomain().getCodeSource().getLocation();
        String imgPath2 = imgPath1.toString();
        System.out.println("Path to base class: " + imgPath2);
        imgPath2 = imgPath2.substring(5);
        System.out.println("Path after removing 'file:': " + imgPath2);
        String imgPath3 = imgPath2 + "images/schedulerIcon.gif";
        if (imgPath2.indexOf(".jar") > 0) {
            ClassLoader cl = this.getClass().getClassLoader();
            img = new ImageIcon(cl.getResource("images/schedulerIcon.gif"));
        } else {
            img = new ImageIcon(imgPath3);
        }
        this.setIconImage(img.getImage());
    }

    private void setupJFrame() {
        Toolkit theKit = this.getToolkit();
        Dimension wndSize = theKit.getScreenSize();
        this.setSize(new Dimension(760, 575));
        this.setBounds((wndSize.width - 760) / 2, (wndSize.height - 575) / 2, 760, 575);
        this.addWindowListener(new WindowHandler());
        this.setVisible(true);
    }

    private void addMenusToFrame() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem item = new JMenuItem("New");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Open...");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Save");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Save As...");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Export CSV (spreadsheet)...");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Exit");
        fileMenu.add(item);
        item.addActionListener(this.handlerMenu);
        fileMenu.setMnemonic('F');
        JMenu helpMenu = new JMenu("Help");
        item = new JMenuItem("How to Use");
        helpMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("Example Schedule");
        helpMenu.add(item);
        item.addActionListener(this.handlerMenu);
        item = new JMenuItem("About");
        helpMenu.add(item);
        item.addActionListener(this.handlerMenu);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        this.getContentPane().add((Component)menuBar, "North");
    }

    private void addPanelsToFrame() {
        this.tabPane = new JTabbedPane();
        JTabbedPane resourceTabPane = new JTabbedPane(2);
        ScheduleConflicts conflictsPanel = new ScheduleConflicts();
        ProfessorsPanel professorsPanel = new ProfessorsPanel();
        RoomsPanel roomsPanel = new RoomsPanel();
        TimeSlotsPanel timeSlotsPanel = new TimeSlotsPanel(this);
        CoursesPanel coursesPanel = new CoursesPanel();
        ScheduleCoursePanel scheduleCoursePanel = new ScheduleCoursePanel(this);
        resourceTabPane.addTab("Professors", professorsPanel);
        resourceTabPane.addTab("Classrooms", roomsPanel);
        resourceTabPane.addTab("Time Slots", timeSlotsPanel);
        resourceTabPane.addTab("Courses", coursesPanel);
        resourceTabPane.setToolTipTextAt(0, "Maintain the professors available to schedule");
        resourceTabPane.setToolTipTextAt(1, "The list of classrooms to schedule");
        resourceTabPane.setToolTipTextAt(2, "The timeslots for scheduling");
        resourceTabPane.setToolTipTextAt(3, "The list of courses and sections that can be scheduled");
        ModifySchedule modifySchedule = new ModifySchedule(this);
        ViewCharts viewCharts = new ViewCharts();
        ScheduleSummary summary = new ScheduleSummary();
        this.tabPane.addTab("Modify Schedule", modifySchedule);
        this.tabPane.addTab("View Charts", viewCharts);
        this.tabPane.addTab("Conflicts", conflictsPanel);
        this.tabPane.addTab("Summary", summary);
        this.tabPane.addTab("Resources to Schedule", resourceTabPane);
        this.tabPane.setToolTipTextAt(0, "Edit the schedule here by adding sections, assigning profs, classrooms, etc.");
        this.tabPane.setToolTipTextAt(1, "View and print the schedule as a graphical chart You cannot edit the schedule here.");
        this.tabPane.setToolTipTextAt(2, "These are the conflicts in the schedule.  Fix the conflicts under the Modify Schedule tab.");
        this.tabPane.setToolTipTextAt(3, "This is a read only summary of the schedule.  It will be more useful as people tell us what should be here.");
        this.tabPane.setToolTipTextAt(4, "All of the resources, Classrooms, Professors, Timeslots, etc. are maintained here");
        this.getContentPane().add((Component)this.tabPane, "Center");
        Schedule schedule = Schedule.getSchedule();
        schedule.addObserver(professorsPanel);
        schedule.addObserver(roomsPanel);
        schedule.addObserver(coursesPanel);
        schedule.addObserver(timeSlotsPanel);
        schedule.addObserver(modifySchedule);
        schedule.addObserver(viewCharts);
        schedule.addObserver(conflictsPanel);
        schedule.addObserver(schedule);
    }

    class MyChangeListener
    implements ChangeListener {
        ScheduleSummary summary;

        MyChangeListener(ScheduleSummary summary) {
            this.summary = summary;
        }

        public void stateChanged(ChangeEvent ce) {
            System.out.println("I hear the tabPane event:" + ce.getSource());
            if (ClassroomSchedulerFrame.this.tabPane.getSelectedComponent() == this.summary) {
                System.out.println("The user wants a summary");
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            if (e.getID() == 201 && ClassroomSchedulerFrame.this.handlerMenu.checkForSave()) {
                ClassroomSchedulerFrame.this.dispose();
                System.exit(0);
            }
        }
    }
}

