/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class BasicCursorFactory {
    private static Cursor onItemCursor;
    private static BasicCursorFactory theFactory;
    private static final boolean debug = false;

    public static Cursor getOnItemCursor() {
        BasicCursorFactory.debug("getOnItemCursor");
        if (theFactory == null) {
            theFactory = new BasicCursorFactory();
        }
        if (onItemCursor == null) {
            onItemCursor = theFactory.createCursor("OnItemCursor");
        }
        return onItemCursor;
    }

    private Cursor createCursor(String string) {
        Object object;
        String string2 = null;
        String string3 = null;
        BasicCursorFactory.debug("CreateCursor for " + string);
        InputStream inputStream = this.getClass().getResourceAsStream("images/" + string + ".properties");
        if (inputStream == null) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " not found.");
            return null;
        }
        try {
            object = new PropertyResourceBundle(inputStream);
            string2 = ((ResourceBundle)object).getString("Cursor.File");
            string3 = ((ResourceBundle)object).getString("Cursor.HotSpot");
        }
        catch (MissingResourceException missingResourceException) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " invalid.");
            return null;
        }
        catch (IOException iOException) {
            BasicCursorFactory.debug(this.getClass().getName() + "/" + "images/" + string + ".properties" + " invalid.");
            return null;
        }
        object = null;
        try {
            int n;
            InputStream inputStream2 = this.getClass().getResourceAsStream(string2);
            if (inputStream2 == null) {
                BasicCursorFactory.debug(this.getClass().getName() + "/" + string2 + " not found.");
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            object = new byte[1024];
            while ((n = bufferedInputStream.read((byte[])object)) > 0) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            if (((Object)object).length == 0) {
                BasicCursorFactory.debug("warning: " + string2 + " is zero-length");
                return null;
            }
        }
        catch (IOException iOException) {
            BasicCursorFactory.debug(iOException.toString());
            return null;
        }
        ImageIcon imageIcon = new ImageIcon((byte[])object);
        int n = string3.indexOf(44);
        Point point = new Point(Integer.parseInt(string3.substring(0, n)), Integer.parseInt(string3.substring(n + 1)));
        BasicCursorFactory.debug("Toolkit fetching cursor");
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), point, string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    private static void debug(String string) {
    }
}

