/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.Convert;
import cpusim.util.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class MBNTableCellRenderer
extends DefaultTableCellRenderer
implements CPUSimConstants {
    private int mode = 0;
    private int[] numBits;
    private Set<Integer> outlinedRows;

    public MBNTableCellRenderer(int[] numBits) {
        this.numBits = numBits;
        this.setHorizontalAlignment(4);
        this.outlinedRows = new HashSet<Integer>();
    }

    public void setNumBits(int[] newNumBits) {
        this.numBits = newNumBits;
    }

    public int[] getNumBits() {
        return this.numBits;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelRow = row;
        if (table.getModel() instanceof TableSorter) {
            modelRow = ((TableSorter)table.getModel()).modelIndex(row);
        }
        if (this.mode == 1) {
            value = Convert.fromLongToTwosComplementString((Long)value, this.numBits[modelRow]);
            value = Convert.insertSpacesInString((String)value, 4);
        } else if (this.mode == 2) {
            value = Convert.fromLongToHexadecimalString((Long)value, this.numBits[modelRow]);
            value = Convert.insertSpacesInString((String)value, 4);
        } else if (this.mode == 4) {
            value = Convert.fromLongToAsciiString((Long)value, this.numBits[modelRow]);
        } else if (this.mode == 5) {
            value = Convert.fromLongToUnicodeString((Long)value, this.numBits[modelRow]);
        } else if (this.mode == 3) {
            value = Convert.fromLongToUnsignedDecString((Long)value, this.numBits[modelRow]);
        }
        if (this.outlinedRows.contains(row)) {
            JComponent outlinedComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            outlinedComponent.setBorder(new LineBorder(Color.GREEN));
            return outlinedComponent;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void setMode(int newBase) {
        this.mode = newBase;
        Assert.That(this.mode == 1 || this.mode == 2 || this.mode == 0 || this.mode == 4 || this.mode == 5 || this.mode == 3, "Bad mode " + this.mode + " in MBNTableCellRenderer.setMode()");
    }

    public void setOutlineRows(Set<Integer> outlinedRows) {
        this.outlinedRows = outlinedRows;
    }
}

