/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.OOTableModel;
import cpusim.util.TableSorter;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ExtendedJTable
extends JTable {
    public ExtendedJTable(TableModel model) {
        this(model, (HashMap)null, (HashMap)null);
    }

    public ExtendedJTable(TableModel model, HashMap editors) {
        this(model, editors, null);
    }

    public ExtendedJTable(TableModel model, HashMap editors, HashMap renderers) {
        TableSorter sorter = new TableSorter(model);
        this.setModel(sorter);
        sorter.setTableHeader(this.getTableHeader());
        this.setToolTipText("double-click to edit a cell");
        this.setUpTable(editors, renderers);
        this.setAutoResizeMode(3);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        try {
            super.setValueAt(aValue, row, column);
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), e.getMessage(), "Error", 0);
        }
    }

    public OOTableModel getOOModel() {
        return (OOTableModel)((TableSorter)this.getModel()).getTableModel();
    }

    public void setUpTable(HashMap editors, HashMap renderers) {
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableCellRenderer headerRenderer;
            TableColumn column = this.getColumnModel().getColumn(i);
            String title = column.getHeaderValue().toString();
            if (editors != null && editors.get(title) != null) {
                column.setCellEditor((TableCellEditor)editors.get(title));
            }
            if (renderers != null && renderers.get(title) != null) {
                column.setCellRenderer((TableCellRenderer)renderers.get(title));
            }
            if (!((headerRenderer = column.getHeaderRenderer()) instanceof JComponent)) continue;
            ((JComponent)((Object)headerRenderer)).setToolTipText("Click or shift-click here to sort by " + title);
        }
        this.setColumnSelectionAllowed(false);
        this.sizeColumnsToFit(-1);
    }

    public void selectAndMakeVisibleModelRow(int row) {
        int visibleRow = ((TableSorter)this.getModel()).modelIndex(row);
        this.setRowSelectionInterval(visibleRow, visibleRow);
        this.scrollRectToVisible(this.getCellRect(visibleRow, 0, true));
        this.editCellAt(visibleRow, 0);
    }

    public void deleteSelectedRowWithoutWarning() {
        int selectedRow = this.getSelectedRow();
        int actualRow = ((TableSorter)this.getModel()).modelIndex(selectedRow);
        this.clearSelection();
        this.getOOModel().deleteObject(actualRow);
    }

    public Object getObjectAtSelectedRow() {
        int selectedRow = this.getSelectedRow();
        int actualRow = ((TableSorter)this.getModel()).modelIndex(selectedRow);
        OOTableModel model = this.getOOModel();
        return model.getObject(actualRow);
    }
}

