/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Arithmetic;
import cpusim.microinstruction.MicroFactory;
import cpusim.module.Register;
import cpusim.util.CPUSimConstants;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class ArithmeticFactory
extends MicroFactory
implements CPUSimConstants {
    private Vector currentMicros;
    private Arithmetic prototype;

    public ArithmeticFactory(Machine machine) {
        super(machine);
        this.currentMicros = machine.getMicros("arithmetic");
        Register r = machine.getAllRegisters().size() == 0 ? null : (Register)machine.getAllRegisters().elementAt(0);
        this.prototype = new Arithmetic("???", "ADD", r, r, r, NO_CONDITIONBIT, NO_CONDITIONBIT);
        this.clones = (Microinstruction[])this.createClones();
    }

    @Override
    public HashMap getCellEditors() {
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        Vector registers = this.machine.getAllRegisters();
        Vector conditionBits = (Vector)this.machine.getModule("conditionBits").clone();
        conditionBits.addElement(NO_CONDITIONBIT);
        JComboBox<String> typesCombo = new JComboBox<String>(Arithmetic.OPERATIONS);
        editors.put("type", new DefaultCellEditor(typesCombo));
        JComboBox source1Combo = new JComboBox(registers);
        editors.put("source1", new DefaultCellEditor(source1Combo));
        JComboBox source2Combo = new JComboBox(registers);
        editors.put("source2", new DefaultCellEditor(source2Combo));
        JComboBox destinationCombo = new JComboBox(registers);
        editors.put("destination", new DefaultCellEditor(destinationCombo));
        JComboBox overflowBitCombo = new JComboBox(conditionBits);
        editors.put("overflowBit", new DefaultCellEditor(overflowBitCombo));
        JComboBox carryBitCombo = new JComboBox(conditionBits);
        editors.put("carryBit", new DefaultCellEditor(carryBitCombo));
        return editors;
    }

    @Override
    Microinstruction getPrototype() {
        return this.prototype;
    }

    @Override
    Class getMicroClass() {
        return Arithmetic.class;
    }

    @Override
    public Vector getCurrentMicros() {
        return this.currentMicros;
    }

    @Override
    public String toString() {
        return "Arithmetic";
    }

    @Override
    public String[] getProperties() {
        return new String[]{"name", "type", "source1", "source2", "destination", "overflowBit", "carryBit"};
    }

    @Override
    public void updateCurrentMicrosFromClones() {
        this.machine.setMicros("arithmetic", this.createNewMicroList(this.clones));
    }

    @Override
    public void setClones(Object[] newClones) {
        Arithmetic[] arithmetics = new Arithmetic[newClones.length];
        for (int i = 0; i < newClones.length; ++i) {
            arithmetics[i] = (Arithmetic)newClones[i];
        }
        this.clones = arithmetics;
    }

    @Override
    public boolean checkValidity(Object[] micros) {
        Microinstruction[] arithmetics = new Arithmetic[micros.length];
        for (int i = 0; i < micros.length; ++i) {
            arithmetics[i] = (Arithmetic)micros[i];
        }
        return this.allNamesAreUnique(arithmetics) && !this.someNamesAreEmpty(arithmetics);
    }

    @Override
    public boolean newMicrosAreAllowed() {
        return this.machine.getModule("registers").size() > 0 || this.machine.getModule("registerArrays").size() > 0;
    }

    @Override
    public String getHelpPageID() {
        return "Arithmetic";
    }
}

