/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.gui.RAMTable;
import cpusim.gui.RAMTableColumnModel;
import cpusim.gui.RAMTableModel;
import cpusim.module.RAM;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.Convert;
import cpusim.util.HighlightManager;
import cpusim.util.MBNTableCellEditor;
import cpusim.util.MBNTableCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableCellEditor;

public class RAMWindow
extends BaseInternalFrame
implements CPUSimConstants {
    private RAM ram;
    private RAMTable ramTable;
    private HighlightManager highlightManager;
    private int currentContentsBase;
    private int currentAddressBase;
    private int[] numDataBits;
    private int memCellsPerTableCell;
    private MBNTableCellEditor contentsCellEditor;
    private MBNTableCellRenderer contentsCellRenderer;
    private MBNTableCellRenderer addressCellRenderer;
    private JComboBox rowSizeChoices;
    private JComboBox contentsBaseChoices;
    private JComboBox addressBaseChoices;

    public RAMWindow(RAM ram, HighlightManager highlightManager, InternalFrameListener activateNonAssemblerWindowListener, VetoableChangeListener vetoSelectionListener, boolean debugMode) {
        super("RAM " + ram.getName(), true, true, true, true);
        this.setSize(450, 450);
        Container contentPane = this.getContentPane();
        this.highlightManager = highlightManager;
        this.ram = ram;
        this.currentContentsBase = 0;
        this.currentAddressBase = 0;
        this.memCellsPerTableCell = 1;
        this.numDataBits = new int[ram.getLength()];
        int[] numAddressBits = new int[ram.getLength()];
        int addressBits = 1;
        int addressRange = 2;
        while (addressRange < ram.getLength()) {
            addressRange *= 2;
            ++addressBits;
        }
        for (int i = 0; i < this.numDataBits.length; ++i) {
            this.numDataBits[i] = ram.getCellSize();
            numAddressBits[i] = addressBits;
        }
        this.contentsCellEditor = new MBNTableCellEditor(this.numDataBits);
        this.contentsCellRenderer = new MBNTableCellRenderer(this.numDataBits);
        this.addressCellRenderer = new MBNTableCellRenderer(numAddressBits);
        this.createRAMTable(debugMode);
        contentPane.add((Component)new JScrollPane(this.ramTable), "Center");
        contentPane.add((Component)this.createChoicesPanel(), "North");
        this.setDefaultCloseOperation(1);
        this.addVetoableChangeListener(vetoSelectionListener);
        this.addInternalFrameListener(activateNonAssemblerWindowListener);
        this.setVisible(true);
    }

    public void setDebugMode(boolean mode) {
        ((RAMTableColumnModel)this.ramTable.getColumnModel()).setDebugMode(mode);
    }

    public String getContentBaseString() {
        return DISPLAY_MODE_NAMES[this.currentContentsBase];
    }

    public String getAddressBaseString() {
        return DISPLAY_MODE_NAMES[this.currentAddressBase];
    }

    public void setContentsBase(String newBaseString) {
        int newBase = newBaseString.equals("Decimal") ? 0 : (newBaseString.equals("Binary") ? 1 : (newBaseString.equals("Hexadecimal") ? 2 : (newBaseString.equals("Unsigned Dec") ? 3 : (newBaseString.equals("Ascii") ? 4 : 5))));
        if (newBase == this.currentContentsBase) {
            return;
        }
        this.contentsCellEditor.setMode(newBase);
        this.contentsCellRenderer.setMode(newBase);
        this.currentContentsBase = newBase;
        this.contentsBaseChoices.setSelectedIndex(newBase);
        this.ramTable.repaint();
    }

    public void setAddressBase(String newBaseString) {
        int newBase = newBaseString.equals("Decimal") ? 0 : (newBaseString.equals("Binary") ? 1 : 2);
        if (newBase == this.currentAddressBase) {
            return;
        }
        this.addressCellRenderer.setMode(newBase);
        this.currentAddressBase = newBase;
        this.addressBaseChoices.setSelectedIndex(newBase);
        this.ramTable.repaint();
    }

    public int getNumMemCellsPerTableCell() {
        return this.memCellsPerTableCell;
    }

    public void setNumMemCellsPerTableCell(int newSize) {
        if (newSize * this.ram.getCellSize() > 64) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "There can be at most 64 bits per row.", "IO Error", 0);
            this.rowSizeChoices.setSelectedIndex(this.memCellsPerTableCell - 1);
            return;
        }
        if (newSize == this.memCellsPerTableCell) {
            return;
        }
        this.memCellsPerTableCell = newSize;
        ((RAMTableModel)this.ramTable.getModel()).setNumMemCellsPerTableCell(newSize);
        for (int i = 0; i < this.numDataBits.length / this.memCellsPerTableCell; ++i) {
            this.numDataBits[i] = this.ram.getCellSize() * this.memCellsPerTableCell;
        }
        if (this.numDataBits.length % this.memCellsPerTableCell != 0) {
            this.numDataBits[this.numDataBits.length / this.memCellsPerTableCell] = this.ram.getCellSize() * (this.numDataBits.length % this.memCellsPerTableCell);
        }
        this.ramTable.repaint();
        this.rowSizeChoices.setSelectedIndex(newSize - 1);
        this.highlightRows(this.highlightManager.getAddressesToHighlight(this.ram));
    }

    public boolean finishCurrentEditing() {
        TableCellEditor editor = this.ramTable.getCellEditor();
        return editor == null || editor.stopCellEditing();
    }

    public void updateDataDisplay() {
        ((RAMTableModel)this.ramTable.getModel()).fireTableDataChanged();
    }

    public void cancelCurrentEditing() {
        TableCellEditor editor = this.ramTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    public void updateRAMTable() {
        int i;
        this.numDataBits = new int[this.ram.getLength()];
        int[] numAddressBits = new int[this.ram.getLength()];
        int addressBits = 1;
        int addressRange = 2;
        while (addressRange < this.ram.getLength()) {
            addressRange *= 2;
            ++addressBits;
        }
        for (i = 0; i < numAddressBits.length; ++i) {
            numAddressBits[i] = addressBits;
        }
        if (this.ram.getCellSize() * this.memCellsPerTableCell > 64) {
            this.memCellsPerTableCell = 1;
            this.rowSizeChoices.setSelectedIndex(0);
        }
        ((RAMTableModel)this.ramTable.getModel()).setNumMemCellsPerTableCell(this.memCellsPerTableCell);
        for (i = 0; i < this.numDataBits.length / this.memCellsPerTableCell; ++i) {
            this.numDataBits[i] = this.ram.getCellSize() * this.memCellsPerTableCell;
        }
        if (this.numDataBits.length % this.memCellsPerTableCell != 0) {
            this.numDataBits[this.numDataBits.length / this.memCellsPerTableCell] = this.ram.getCellSize() * (this.numDataBits.length % this.memCellsPerTableCell);
        }
        this.contentsCellEditor.setNumBits(this.numDataBits);
        this.contentsCellRenderer.setNumBits(this.numDataBits);
        this.addressCellRenderer.setNumBits(numAddressBits);
        this.ramTable.repaint();
    }

    public void setTableFont(Font tableFont) {
        for (int i = 0; i < this.ramTable.getColumnCount(); ++i) {
            DefaultCellEditor editor = (DefaultCellEditor)this.ramTable.getCellEditor(0, i);
            editor.getComponent().setFont(tableFont);
        }
        this.ramTable.setRowHeight(tableFont.getSize() + 4);
        this.ramTable.setFont(tableFont);
    }

    public void outlineRows(Set<Integer> addresses) {
        HashSet<Integer> tempSet = new HashSet<Integer>();
        for (Integer address : addresses) {
            tempSet.add(address / this.memCellsPerTableCell);
        }
        this.contentsCellRenderer.setOutlineRows(tempSet);
    }

    public void highlightRows(int[] addresses) {
        Assert.That(addresses != null, "addresses was null in RAMWindow.highlightRows()");
        this.ramTable.clearSelection();
        int length = this.ram.getLength();
        for (int address : addresses) {
            if (address < 0 || address >= length) continue;
            int row = address / this.memCellsPerTableCell;
            this.ramTable.addRowSelectionInterval(row, row);
            this.ramTable.scrollRectToVisible(new Rectangle(0, (row - 4) * this.ramTable.getRowHeight(), 20, 8 * this.ramTable.getRowHeight()));
        }
    }

    public void highlightBreak(int breakAddress) {
        if (breakAddress >= 0 && breakAddress < this.ram.getLength()) {
            int row = breakAddress / this.memCellsPerTableCell;
            this.ramTable.setBreakRow(row);
            this.ramTable.scrollRectToVisible(new Rectangle(0, (row - 4) * this.ramTable.getRowHeight(), 20, 8 * this.ramTable.getRowHeight()));
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            try {
                if (this.isIcon()) {
                    this.setIcon(false);
                }
                this.setSelected(true);
            }
            catch (PropertyVetoException exc) {
                JOptionPane.showMessageDialog(this, "There was an error when attempting to deiconify or select the window containing the break point.", "Window Selection Error", 0);
            }
        }
    }

    public void store(FileDialog fileChooser, int fileFormat) {
        TableCellEditor editor = this.ramTable.getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            return;
        }
        File newFile = this.chooseTextFileToWriteTo(fileChooser);
        if (newFile == null) {
            return;
        }
        this.saveContents(newFile, fileFormat);
    }

    public void load(File file, int fileFormat) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException exc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "CPU Sim could not find the file to open:  " + file.getAbsolutePath(), "IO Error", 0);
            return;
        }
        try {
            this.ram.loadFile(reader, file.getAbsolutePath(), fileFormat);
            reader.close();
        }
        catch (IOException ioExc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "IO Error when reading the file \"" + file.getName() + "\":\n" + ioExc.getMessage(), "IO Error", 0);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "Number Format Error when reading the file \"" + file.getName() + "\":\n" + nfe.getMessage(), "IO Error", 0);
        }
    }

    private File chooseTextFileToWriteTo(FileDialog fileDialog) {
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        String directoryName = fileDialog.getDirectory();
        if (fileName == null) {
            return null;
        }
        return new File(directoryName + fileName);
    }

    private void saveContents(File file, int fileFormat) {
        PrintWriter writer;
        Assert.That(file != null, "Called saveContents with a null file.");
        try {
            writer = new PrintWriter(new FileOutputStream(file));
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(this.getDesktopPane(), "IOException thrown when trying to write to the file: " + file.getAbsolutePath(), "IO Error", 0);
            return;
        }
        RAMTableModel model = (RAMTableModel)this.ramTable.getModel();
        int cellsPerTableCell = model.getNumMemCellsPerTableCell();
        if (fileFormat == 0 || fileFormat == 1) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                Long longValue = (Long)model.getValueAt(i, 2);
                String comment = (String)model.getValueAt(i, 3);
                String longValueString = fileFormat == 0 ? Convert.fromLongToTwosComplementString(longValue, cellsPerTableCell * this.ram.getCellSize()) : Convert.fromLongToHexadecimalString(longValue, cellsPerTableCell * this.ram.getCellSize());
                writer.println(longValueString + " " + comment);
            }
        } else {
            int bitsOfData = cellsPerTableCell * this.ram.getCellSize();
            int bytesPerRow = (bitsOfData + 7) / 8;
            String byteCountString = Convert.fromLongToHexadecimalString(bytesPerRow, 8);
            for (int i = 0; i < model.getRowCount(); ++i) {
                long longValue = (Long)model.getValueAt(i, 2) << bytesPerRow * 8 - bitsOfData;
                String longValueString = Convert.fromLongToHexadecimalString(longValue, bytesPerRow * 8);
                String addressString = Convert.fromLongToHexadecimalString(i * cellsPerTableCell, 16);
                writer.println(":" + byteCountString + addressString + "00" + longValueString + this.getCheckSumString(bytesPerRow, i * cellsPerTableCell, longValue));
            }
            writer.println(":00000001FF");
        }
        writer.close();
    }

    private String getCheckSumString(int byteCount, int address, long value) {
        byte[] bytes;
        int sum = byteCount + address % 256 + address / 256;
        for (byte b : bytes = Convert.fromLongToByteArray(value, byteCount)) {
            sum += b;
        }
        int checkSum = (256 - (sum &= 0xFF)) % 256;
        return Convert.fromLongToHexadecimalString(checkSum, 8);
    }

    private void createRAMTable(boolean debugMode) {
        RAMTableColumnModel columnModel = new RAMTableColumnModel(this.addressCellRenderer, this.contentsCellRenderer, this.contentsCellEditor);
        RAMTableModel model = new RAMTableModel(this.ram, 1);
        this.ramTable = new RAMTable(model, columnModel);
        this.ramTable.setSelectionMode(2);
        this.ramTable.setColumnSelectionAllowed(false);
        this.ramTable.setAutoCreateColumnsFromModel(false);
        this.setDebugMode(debugMode);
    }

    private JPanel createChoicesPanel() {
        JPanel thePanel = new JPanel();
        this.addressBaseChoices = new JComboBox<String>(new String[]{"Decimal", "Binary", "Hexadecimal"});
        this.addressBaseChoices.addActionListener(new AddressBaseComboListener());
        JLabel addrBaseLabel = new JLabel("Address:");
        thePanel.add(addrBaseLabel);
        thePanel.add(this.addressBaseChoices);
        this.contentsBaseChoices = new JComboBox<String>(new String[]{"Decimal", "Binary", "Hexadecimal", "Unsigned Dec", "Ascii", "Unicode"});
        this.contentsBaseChoices.addActionListener(new ContentsBaseComboListener());
        JLabel contentsBaseLabel = new JLabel("Data:");
        thePanel.add(contentsBaseLabel);
        thePanel.add(this.contentsBaseChoices);
        this.rowSizeChoices = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8"});
        this.rowSizeChoices.addActionListener(new RowSizeComboListener());
        JLabel sizeLabel = new JLabel("Row size:");
        thePanel.add(sizeLabel);
        thePanel.add(this.rowSizeChoices);
        return thePanel;
    }

    class RowSizeComboListener
    implements ActionListener {
        RowSizeComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = RAMWindow.this.ramTable.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                RAMWindow.this.rowSizeChoices.setSelectedIndex(RAMWindow.this.memCellsPerTableCell - 1);
                return;
            }
            int newIndex = RAMWindow.this.rowSizeChoices.getSelectedIndex();
            RAMWindow.this.setNumMemCellsPerTableCell(newIndex + 1);
        }
    }

    class ContentsBaseComboListener
    implements ActionListener {
        ContentsBaseComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = RAMWindow.this.ramTable.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                RAMWindow.this.contentsBaseChoices.setSelectedIndex(RAMWindow.this.currentContentsBase);
                return;
            }
            int newBase = RAMWindow.this.contentsBaseChoices.getSelectedIndex();
            if (newBase == RAMWindow.this.currentContentsBase) {
                return;
            }
            RAMWindow.this.contentsCellEditor.setMode(newBase);
            RAMWindow.this.contentsCellRenderer.setMode(newBase);
            RAMWindow.this.currentContentsBase = newBase;
            RAMWindow.this.ramTable.repaint();
        }
    }

    class AddressBaseComboListener
    implements ActionListener {
        AddressBaseComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = RAMWindow.this.ramTable.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                RAMWindow.this.addressBaseChoices.setSelectedIndex(RAMWindow.this.currentAddressBase);
                return;
            }
            int newBase = RAMWindow.this.addressBaseChoices.getSelectedIndex();
            if (newBase == RAMWindow.this.currentAddressBase) {
                return;
            }
            RAMWindow.this.addressCellRenderer.setMode(newBase);
            RAMWindow.this.currentAddressBase = newBase;
            RAMWindow.this.ramTable.repaint();
        }
    }
}

