/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.gui.EditDialog;
import cpusim.gui.LangUnit;
import cpusim.microinstruction.Arithmetic;
import cpusim.microinstruction.ArithmeticFactory;
import cpusim.microinstruction.Branch;
import cpusim.microinstruction.BranchFactory;
import cpusim.microinstruction.CpusimSet;
import cpusim.microinstruction.Decode;
import cpusim.microinstruction.DecodeFactory;
import cpusim.microinstruction.IO;
import cpusim.microinstruction.IOFactory;
import cpusim.microinstruction.Increment;
import cpusim.microinstruction.IncrementFactory;
import cpusim.microinstruction.Logical;
import cpusim.microinstruction.LogicalFactory;
import cpusim.microinstruction.MemoryAccess;
import cpusim.microinstruction.MemoryAccessFactory;
import cpusim.microinstruction.MicroFactory;
import cpusim.microinstruction.SetCondBit;
import cpusim.microinstruction.SetCondBitFactory;
import cpusim.microinstruction.SetFactory;
import cpusim.microinstruction.Shift;
import cpusim.microinstruction.ShiftFactory;
import cpusim.microinstruction.Test;
import cpusim.microinstruction.TestFactory;
import cpusim.microinstruction.TransferAtoR;
import cpusim.microinstruction.TransferAtoRFactory;
import cpusim.microinstruction.TransferRtoA;
import cpusim.microinstruction.TransferRtoAFactory;
import cpusim.microinstruction.TransferRtoR;
import cpusim.microinstruction.TransferRtoRFactory;
import cpusim.util.Assert;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import cpusim.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class MicroDialog
extends EditDialog {
    private MicroFactory currentFactory;
    private JComboBox typeChoices;
    private MicroFactory[] factories;

    public MicroDialog(Frame parent, Machine machine) {
        super(parent, LangUnit.LU_EDIT_MICRO.str(), true);
        this.initializeDialog(machine);
    }

    public MicroDialog(Dialog parent, Machine machine, Class microClass) {
        super(parent, LangUnit.LU_EDIT_MICRO.str(), true);
        this.initializeDialog(machine);
        int index = microClass == CpusimSet.class ? 0 : (microClass == Test.class ? 1 : (microClass == Increment.class ? 2 : (microClass == Shift.class ? 3 : (microClass == Logical.class ? 4 : (microClass == Arithmetic.class ? 5 : (microClass == Branch.class ? 6 : (microClass == TransferRtoR.class ? 7 : (microClass == TransferRtoA.class ? 8 : (microClass == TransferAtoR.class ? 9 : (microClass == Decode.class ? 10 : (microClass == SetCondBit.class ? 11 : (microClass == IO.class ? 12 : (microClass == MemoryAccess.class ? 13 : 0)))))))))))));
        this.typeChoices.setSelectedIndex(index);
    }

    private void initializeDialog(Machine machine) {
        Container contentPane = this.getContentPane();
        this.machine = machine;
        for (MicroFactory factory : this.factories = new MicroFactory[]{new SetFactory(machine), new TestFactory(machine), new IncrementFactory(machine), new ShiftFactory(machine), new LogicalFactory(machine), new ArithmeticFactory(machine), new BranchFactory(machine), new TransferRtoRFactory(machine), new TransferRtoAFactory(machine), new TransferAtoRFactory(machine), new DecodeFactory(machine), new SetCondBitFactory(machine), new IOFactory(machine), new MemoryAccessFactory(machine)}) {
            factory.setParentFrame(this);
        }
        this.currentFactory = this.factories[0];
        JPanel bottomButtonPanel = this.createBottomButtonPanel();
        contentPane.add((Component)bottomButtonPanel, "South");
        contentPane.add((Component)this.createMicroTypeChoicesPanel(), "North");
        JPanel microPanel = new JPanel();
        microPanel.setLayout(new BorderLayout());
        microPanel.add((Component)this.createListAddButtonPanel(), "South");
        this.table = this.createMicroJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        microPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 200));
        microPanel.add((Component)new JScrollPane(this.table), "Center");
        microPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        contentPane.add((Component)microPanel, "Center");
        this.displayCurrentMicros();
    }

    private void displayCurrentMicros() {
        Object[] clones = this.currentFactory.getClones();
        HashMap editors = this.currentFactory.getCellEditors();
        HashMap renderers = this.currentFactory.getCellRenderers();
        OOTableModel model = this.table.getOOModel();
        try {
            model.setObjects(clones, this.currentFactory.getProperties());
            this.table.setUpTable(editors, renderers);
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.newButton.setEnabled(this.currentFactory.newMicrosAreAllowed());
        }
        catch (IntrospectionException exc) {
            Assert.That(false, LangUnit.LU_EXCEPT_DISP_MICRO.str());
        }
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.currentFactory;
    }

    @Override
    protected void updateMachine() {
        Object[] microList = this.getObjectList();
        this.currentFactory.setClones(microList);
        for (MicroFactory factory : this.factories) {
            factory.updateCurrentMicrosFromClones();
        }
    }

    private ExtendedJTable createMicroJTable() {
        ExtendedJTable table = null;
        OOTableModel model = null;
        Object[] clones = this.currentFactory.getClones();
        HashMap editors = this.currentFactory.getCellEditors();
        HashMap renderers = this.currentFactory.getCellRenderers();
        try {
            model = new OOTableModel(clones);
        }
        catch (Exception e) {
            Assert.That(false, LangUnit.LU_EXCEPT_MICRO.str());
        }
        table = new ExtendedJTable((TableModel)model, editors, renderers);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new MicroTableSelectionListener());
        return table;
    }

    private JPanel createMicroTypeChoicesPanel() {
        JPanel thePanel = new JPanel();
        this.typeChoices = new JComboBox<MicroFactory>(this.factories);
        this.typeChoices.addActionListener(new TypesComboListener());
        JLabel label = new JLabel(LangUnit.LU_TYPE_MICRO.str());
        thePanel.add(label);
        thePanel.add(this.typeChoices);
        return thePanel;
    }

    private JPanel createListAddButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton(LangUnit.LU_NEW.str());
        this.newButton.setToolTipText(LangUnit.LU_CREATE_INS.str());
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(LangUnit.LU_DELETE.str());
        this.deleteButton.setToolTipText(LangUnit.LU_DEL_INS.str());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton(LangUnit.LU_DUPLICATE.str());
        this.duplicateButton.setToolTipText(LangUnit.LU_INS_DUP_INS.str());
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return buttonPanel;
    }

    @Override
    public String createUniqueName(Object[] list, String proposedName) {
        String oldName = null;
        for (Object obj : list) {
            oldName = obj.toString();
            if (oldName == null || !oldName.equals(proposedName)) continue;
            return this.createUniqueName(list, proposedName + "?");
        }
        return proposedName;
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Vector instrsThatUseIt;
            TableCellEditor editor = MicroDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            int selectedRow = MicroDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                Assert.That(false, LangUnit.LU_DEL_NONE.str());
                return;
            }
            int actualRow = ((TableSorter)MicroDialog.this.table.getModel()).modelIndex(selectedRow);
            OOTableModel model = MicroDialog.this.table.getOOModel();
            Microinstruction theMicro = (Microinstruction)model.getObject(actualRow);
            Microinstruction oldInstr = MicroDialog.this.currentFactory.getCurrentFromClone(theMicro);
            if (oldInstr != null && (instrsThatUseIt = MicroDialog.this.machine.getInstructionsThatUse(oldInstr)).size() > 0) {
                Object[] options = new String[]{LangUnit.LU_YES_DEL.str(), LangUnit.LU_CANCEL.str()};
                String message = theMicro + LangUnit.LU_USED_BY_INS.str();
                for (int i = 0; i < instrsThatUseIt.size(); ++i) {
                    message = message + instrsThatUseIt.elementAt(i) + " ";
                }
                int response = JOptionPane.showOptionDialog(MicroDialog.this, message = message + LangUnit.LU_REAL_DEL_MICRO.str(), LangUnit.LU_INS_WARN.str(), 0, 2, null, options, options[0]);
                if (response == 1) {
                    return;
                }
            }
            model.deleteObject(actualRow);
            int size = model.getRowCount();
            if (size == 0) {
                MicroDialog.this.deleteButton.setEnabled(false);
                MicroDialog.this.duplicateButton.setEnabled(false);
            } else if (selectedRow < size) {
                MicroDialog.this.table.setRowSelectionInterval(selectedRow, selectedRow);
            } else {
                MicroDialog.this.table.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            }
        }
    }

    class TypesComboListener
    implements ActionListener {
        TypesComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = MicroDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            JComboBox cb = (JComboBox)e.getSource();
            MicroFactory newFactory = null;
            newFactory = (MicroFactory)cb.getSelectedItem();
            if (newFactory == MicroDialog.this.currentFactory) {
                return;
            }
            Object[] objectList = MicroDialog.this.table.getOOModel().getAllObjects();
            boolean allOK = MicroDialog.this.currentFactory.checkValidity(objectList);
            if (!allOK) {
                for (int i = 0; i < MicroDialog.this.factories.length; ++i) {
                    if (MicroDialog.this.factories[i] != MicroDialog.this.currentFactory) continue;
                    cb.setSelectedIndex(i);
                    return;
                }
            }
            MicroDialog.this.currentFactory.setClones(objectList);
            MicroDialog.this.currentFactory = newFactory;
            MicroDialog.this.displayCurrentMicros();
        }
    }

    class MicroTableSelectionListener
    implements ListSelectionListener {
        MicroTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = MicroDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                MicroDialog.this.deleteButton.setEnabled(false);
                MicroDialog.this.duplicateButton.setEnabled(false);
            } else {
                MicroDialog.this.deleteButton.setEnabled(true);
                MicroDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }
}

