/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.assembler.PunctChar;
import cpusim.util.Assert;
import cpusim.util.ExtendedJTable;
import cpusim.util.OOTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.IntrospectionException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class AssemblyPrefsPanel
extends JPanel {
    public AssemblyPrefsPanel(PunctChar[] chars) {
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 2));
        int oneThird = chars.length / 3 + (chars.length % 3 == 0 ? 0 : 1);
        JPanel table1 = this.createExtendedJTablePanel(chars, 0, oneThird);
        containerPanel.add(table1);
        containerPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel table2 = this.createExtendedJTablePanel(chars, oneThird, 2 * oneThird);
        containerPanel.add(table2);
        containerPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel table3 = this.createExtendedJTablePanel(chars, 2 * oneThird, chars.length);
        containerPanel.add(table3);
        this.add((Component)containerPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel createExtendedJTablePanel(PunctChar[] chars, int start, int end2) {
        ExtendedJTable punctCharTable = null;
        OOTableModel model = null;
        Object[] halfChars = new PunctChar[end2 - start];
        for (int i = start; i < end2; ++i) {
            halfChars[i - start] = chars[i];
        }
        HashMap<String, DefaultCellEditor> editors = new HashMap<String, DefaultCellEditor>();
        JComboBox<PunctChar.Use> useCombo = new JComboBox<PunctChar.Use>(new PunctChar.Use[]{PunctChar.Use.symbol, PunctChar.Use.token, PunctChar.Use.comment, PunctChar.Use.label, PunctChar.Use.pseudo, PunctChar.Use.illegal});
        editors.put("use", new DefaultCellEditor(useCombo));
        HashMap<String, 1> renderers = new HashMap<String, 1>();
        renderers.put("char", new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                this.setText(value == null ? "" : " " + value);
            }
        });
        try {
            model = new OOTableModel(halfChars);
            model.setColumns(new String[]{"char", "use"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, "beans introspection exception thrown when trying to create the ExtendedJTable for EQUs");
        }
        punctCharTable = new ExtendedJTable((TableModel)model, editors, renderers);
        punctCharTable.setSelectionMode(0);
        punctCharTable.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        panel.add(punctCharTable);
        return panel;
    }
}

