/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.PunctChar;
import cpusim.assembler.StreamObject;
import cpusim.assembler.Token;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class Scanner {
    private static final int ILLEGAL = 0;
    private static final int START = 1;
    private static final int PSEUDO = 2;
    private static final int NUMBER = 6;
    private static final int NEWLINE = 8;
    private static final int COMMENT = 9;
    private static final int INSTR_VAR = 10;
    private static final int LABEL = 11;
    private static final int OPENDQUOTE = 12;
    private static final int CLOSEDQUOTE = 13;
    private static final int DOTD = 14;
    private static final int DOTDA = 15;
    private static final int DOTDAT = 16;
    private static final int DOTDATA = 17;
    private static final int DOTI = 18;
    private static final int DOTIN = 19;
    private static final int DOTINC = 20;
    private static final int DOTINCL = 21;
    private static final int DOTINCLU = 22;
    private static final int DOTINCLUD = 23;
    private static final int DOTINCLUDE = 24;
    private static final int DOTA = 25;
    private static final int DOTAS = 26;
    private static final int DOTASC = 27;
    private static final int DOTASCI = 28;
    private static final int DOTASCII = 29;
    private static final int OPENSQUOTE = 30;
    private static final int CHARSQUOTE = 31;
    private static final int CLOSESQUOTE = 32;
    private static final int OPENCQUOTE = 33;
    private static final int CLOSECQUOTE = 34;
    private static final int PUNCTUATION = 35;
    private static final int DOTAL = 40;
    private static final int DOTALI = 41;
    private static final int DOTALIG = 42;
    private static final int DOTALIGN = 43;
    private static final int DOTP = 44;
    private static final int DOTPO = 45;
    private static final int DOTPOS = 46;
    private static final int DOTL = 47;
    private static final int DOTLO = 48;
    private static final int DOTLON = 49;
    private static final int DOTLONG = 50;
    private static final int DOTS = 51;
    private static final int DOTSH = 52;
    private static final int DOTSHO = 53;
    private static final int DOTSHOR = 54;
    private static final int DOTSHORT = 55;
    private static final int PLUS = 56;
    private static final int MINUS = 57;
    private static final int EOF = -1;
    private static final int C_DOUBLEQUOTE = 0;
    private static final int C_NUMBER = 1;
    private static final int C_WHITESPACE = 2;
    private static final int C_NEWLINE = 3;
    private static final int C_SEMICOLON = 4;
    private static final int C_PLUSSIGN = 8;
    private static final int C_LETTER = 11;
    private static final int C_a = 12;
    private static final int C_c = 13;
    private static final int C_d = 14;
    private static final int C_e = 15;
    private static final int C_i = 16;
    private static final int C_l = 17;
    private static final int C_n = 18;
    private static final int C_s = 19;
    private static final int C_t = 20;
    private static final int C_u = 21;
    private static final int C_SINGLEQUOTE = 23;
    private static final int C_LCHEVRON = 24;
    private static final int C_RCHEVRON = 25;
    private static final int C_OTHER = 26;
    private static final int C_g = 44;
    private static final int C_p = 45;
    private static final int C_o = 46;
    private static final int C_h = 47;
    private static final int C_r = 48;
    private static final int C_COMMENTCHAR = 49;
    private static final int C_PSEUDOCHAR = 50;
    private static final int C_LABELCHAR = 51;
    private static final int C_MINUSSIGN = 53;
    private static final int C_TOKEN = 55;
    private Stack<StreamObject> streamStack;
    private HashSet<String> filenames = new HashSet();
    private StreamObject top;
    private Machine machine;
    private int[][] nextState;
    private int[] charType;
    private char pseudoChar;
    private boolean plusIsSymbol;
    private boolean minusIsSymbol;
    private boolean plusIsToken;
    private boolean minusIsToken;

    public Scanner(Machine machine) {
        this.streamStack = new Stack();
        this.machine = machine;
        this.initializeCharTypeArray();
        this.initializeNextStateArray();
    }

    public void startScanning(String fullPathName) {
        Token pathToken = new Token("", -1, -1, -1, -1, "\"" + fullPathName + "\"", true);
        this.filenames.clear();
        this.streamStack.clear();
        this.startScanning(pathToken);
    }

    public void startScanning(Token token) {
        String fullPath;
        if (token.filename.equals("")) {
            fullPath = token.contents.substring(1, token.contents.length() - 1);
        } else {
            File f = token.contents.charAt(0) == '<' ? this.machine.getFile() : new File(token.filename);
            String basePath = f != null ? f.getParent() : null;
            String relativePath = token.contents.substring(1, token.contents.length() - 1);
            fullPath = basePath == null ? relativePath : basePath + File.separator + relativePath;
        }
        if (this.filenames.contains(fullPath)) {
            throw new AssemblyException("Error: The .include file \"" + fullPath + "\" is being included recursively\n       and will cause " + "an infinite loop", token);
        }
        this.filenames.add(fullPath);
        this.streamStack.push(new StreamObject(fullPath, token));
        this.top = this.streamStack.peek();
        this.top.currentChar = this.getNextChar();
    }

    public Machine getMachine() {
        return this.machine;
    }

    private void initializeCharTypeArray() {
        int i;
        this.charType = new int[128];
        for (i = 0; i < this.charType.length; ++i) {
            this.charType[i] = 26;
        }
        for (i = 97; i <= 122; ++i) {
            this.charType[i] = 11;
        }
        for (i = 65; i <= 90; ++i) {
            this.charType[i] = 11;
        }
        for (i = 48; i <= 57; ++i) {
            this.charType[i] = 1;
        }
        this.charType[9] = 2;
        this.charType[32] = 2;
        this.charType[10] = 3;
        this.charType[39] = 23;
        this.charType[34] = 0;
        this.charType[60] = 24;
        this.charType[62] = 25;
        this.plusIsSymbol = false;
        this.minusIsSymbol = false;
        this.plusIsToken = false;
        this.minusIsToken = false;
        for (PunctChar c : this.machine.getPunctChars()) {
            if (c.getUse() == PunctChar.Use.symbol && c.getChar() == '+') {
                this.plusIsSymbol = true;
                continue;
            }
            if (c.getUse() == PunctChar.Use.symbol && c.getChar() == '-') {
                this.minusIsSymbol = true;
                continue;
            }
            if (c.getUse() == PunctChar.Use.token && c.getChar() == '+') {
                this.plusIsToken = true;
                continue;
            }
            if (c.getUse() == PunctChar.Use.token && c.getChar() == '-') {
                this.minusIsToken = true;
                continue;
            }
            if (c.getUse() == PunctChar.Use.symbol) {
                this.charType[c.getChar()] = 11;
                continue;
            }
            if (c.getUse() == PunctChar.Use.label) {
                this.charType[c.getChar()] = 51;
                continue;
            }
            if (c.getUse() == PunctChar.Use.pseudo) {
                this.charType[c.getChar()] = 50;
                this.pseudoChar = c.getChar();
                continue;
            }
            this.charType[c.getChar()] = c.getUse() == PunctChar.Use.comment ? 49 : (c.getUse() == PunctChar.Use.illegal ? 26 : 55);
        }
        this.charType[45] = 53;
        this.charType[43] = 8;
        this.charType[97] = 12;
        this.charType[99] = 13;
        this.charType[100] = 14;
        this.charType[101] = 15;
        this.charType[105] = 16;
        this.charType[108] = 17;
        this.charType[110] = 18;
        this.charType[115] = 19;
        this.charType[116] = 20;
        this.charType[117] = 21;
        this.charType[103] = 44;
        this.charType[112] = 45;
        this.charType[111] = 46;
        this.charType[104] = 47;
        this.charType[114] = 48;
    }

    private void initializeNextStateArray() {
        this.nextState = new int[58][56];
        for (int x = 0; x < this.nextState.length; ++x) {
            for (int y = 0; y < this.nextState[0].length; ++y) {
                this.nextState[x][y] = 0;
            }
        }
        this.nextState[1][1] = 6;
        this.nextState[1][2] = 1;
        this.nextState[1][3] = 8;
        this.nextState[1][49] = 9;
        this.nextState[1][50] = 2;
        this.nextState[1][11] = 10;
        this.nextState[1][12] = 10;
        this.nextState[1][13] = 10;
        this.nextState[1][14] = 10;
        this.nextState[1][15] = 10;
        this.nextState[1][16] = 10;
        this.nextState[1][17] = 10;
        this.nextState[1][18] = 10;
        this.nextState[1][19] = 10;
        this.nextState[1][20] = 10;
        this.nextState[1][21] = 10;
        this.nextState[1][44] = 10;
        this.nextState[1][45] = 10;
        this.nextState[1][46] = 10;
        this.nextState[1][47] = 10;
        this.nextState[1][48] = 10;
        this.nextState[1][0] = 12;
        this.nextState[1][23] = 30;
        this.nextState[1][24] = 33;
        this.nextState[1][55] = 35;
        this.nextState[1][53] = 57;
        this.nextState[1][8] = 56;
        this.nextState[56][1] = 6;
        this.nextState[57][1] = 6;
        this.nextState[6][1] = 6;
        this.nextState[6][11] = 6;
        this.nextState[6][12] = 6;
        this.nextState[6][13] = 6;
        this.nextState[6][14] = 6;
        this.nextState[6][15] = 6;
        if (this.plusIsSymbol) {
            this.nextState[56][51] = 11;
            this.nextState[56][11] = 10;
            this.nextState[56][12] = 10;
            this.nextState[56][13] = 10;
            this.nextState[56][14] = 10;
            this.nextState[56][15] = 10;
            this.nextState[56][16] = 10;
            this.nextState[56][17] = 10;
            this.nextState[56][18] = 10;
            this.nextState[56][19] = 10;
            this.nextState[56][20] = 10;
            this.nextState[56][21] = 10;
            this.nextState[56][44] = 10;
            this.nextState[56][45] = 10;
            this.nextState[56][46] = 10;
            this.nextState[56][47] = 10;
            this.nextState[56][48] = 10;
        }
        if (this.minusIsSymbol) {
            this.nextState[57][51] = 11;
            this.nextState[57][11] = 10;
            this.nextState[57][12] = 10;
            this.nextState[57][13] = 10;
            this.nextState[57][14] = 10;
            this.nextState[57][15] = 10;
            this.nextState[57][16] = 10;
            this.nextState[57][17] = 10;
            this.nextState[57][18] = 10;
            this.nextState[57][19] = 10;
            this.nextState[57][20] = 10;
            this.nextState[57][21] = 10;
            this.nextState[57][44] = 10;
            this.nextState[57][45] = 10;
            this.nextState[57][46] = 10;
            this.nextState[57][47] = 10;
            this.nextState[57][48] = 10;
        }
        this.nextState[10][1] = 10;
        this.nextState[10][51] = 11;
        this.nextState[10][11] = 10;
        this.nextState[10][12] = 10;
        this.nextState[10][13] = 10;
        this.nextState[10][14] = 10;
        this.nextState[10][15] = 10;
        this.nextState[10][16] = 10;
        this.nextState[10][17] = 10;
        this.nextState[10][18] = 10;
        this.nextState[10][19] = 10;
        this.nextState[10][20] = 10;
        this.nextState[10][21] = 10;
        this.nextState[10][44] = 10;
        this.nextState[10][45] = 10;
        this.nextState[10][46] = 10;
        this.nextState[10][47] = 10;
        this.nextState[10][48] = 10;
        if (this.plusIsSymbol) {
            this.nextState[10][8] = 10;
        }
        if (this.minusIsSymbol) {
            this.nextState[10][53] = 10;
        }
        this.nextState[9][0] = 9;
        this.nextState[9][1] = 9;
        this.nextState[9][2] = 9;
        this.nextState[9][3] = 0;
        this.nextState[9][50] = 9;
        this.nextState[9][51] = 9;
        this.nextState[9][49] = 9;
        this.nextState[9][11] = 9;
        this.nextState[9][12] = 9;
        this.nextState[9][13] = 9;
        this.nextState[9][14] = 9;
        this.nextState[9][15] = 9;
        this.nextState[9][16] = 9;
        this.nextState[9][17] = 9;
        this.nextState[9][18] = 9;
        this.nextState[9][19] = 9;
        this.nextState[9][20] = 9;
        this.nextState[9][21] = 9;
        this.nextState[9][44] = 9;
        this.nextState[9][45] = 9;
        this.nextState[9][46] = 9;
        this.nextState[9][47] = 9;
        this.nextState[9][48] = 9;
        this.nextState[9][23] = 9;
        this.nextState[9][24] = 9;
        this.nextState[9][25] = 9;
        this.nextState[9][26] = 9;
        this.nextState[9][8] = 9;
        this.nextState[9][53] = 9;
        this.nextState[9][55] = 9;
        this.nextState[30][0] = 31;
        this.nextState[30][1] = 31;
        this.nextState[30][2] = 31;
        this.nextState[30][3] = 31;
        this.nextState[30][11] = 31;
        this.nextState[30][12] = 31;
        this.nextState[30][13] = 31;
        this.nextState[30][14] = 31;
        this.nextState[30][15] = 31;
        this.nextState[30][16] = 31;
        this.nextState[30][17] = 31;
        this.nextState[30][18] = 31;
        this.nextState[30][19] = 31;
        this.nextState[30][20] = 31;
        this.nextState[30][21] = 31;
        this.nextState[30][44] = 31;
        this.nextState[30][45] = 31;
        this.nextState[30][46] = 31;
        this.nextState[30][47] = 31;
        this.nextState[30][48] = 31;
        this.nextState[30][50] = 31;
        this.nextState[30][51] = 31;
        this.nextState[30][49] = 31;
        this.nextState[30][55] = 31;
        this.nextState[30][26] = 31;
        this.nextState[30][24] = 31;
        this.nextState[30][24] = 31;
        this.nextState[30][8] = 31;
        this.nextState[30][53] = 31;
        this.nextState[31][23] = 32;
        this.nextState[12][0] = 13;
        this.nextState[12][1] = 12;
        this.nextState[12][2] = 12;
        this.nextState[12][3] = 0;
        this.nextState[12][50] = 12;
        this.nextState[12][51] = 12;
        this.nextState[12][49] = 12;
        this.nextState[12][11] = 12;
        this.nextState[12][12] = 12;
        this.nextState[12][13] = 12;
        this.nextState[12][14] = 12;
        this.nextState[12][15] = 12;
        this.nextState[12][16] = 12;
        this.nextState[12][17] = 12;
        this.nextState[12][18] = 12;
        this.nextState[12][19] = 12;
        this.nextState[12][20] = 12;
        this.nextState[12][21] = 12;
        this.nextState[12][44] = 12;
        this.nextState[12][45] = 12;
        this.nextState[12][46] = 12;
        this.nextState[12][47] = 12;
        this.nextState[12][48] = 12;
        this.nextState[12][4] = 12;
        this.nextState[12][23] = 12;
        this.nextState[12][24] = 12;
        this.nextState[12][25] = 12;
        this.nextState[12][26] = 12;
        this.nextState[12][8] = 12;
        this.nextState[12][53] = 12;
        this.nextState[12][55] = 12;
        this.nextState[33][1] = 33;
        this.nextState[33][2] = 33;
        this.nextState[33][3] = 0;
        this.nextState[33][50] = 33;
        this.nextState[33][51] = 33;
        this.nextState[33][49] = 33;
        this.nextState[33][11] = 33;
        this.nextState[33][12] = 33;
        this.nextState[33][13] = 33;
        this.nextState[33][14] = 33;
        this.nextState[33][15] = 33;
        this.nextState[33][16] = 33;
        this.nextState[33][17] = 33;
        this.nextState[33][18] = 33;
        this.nextState[33][19] = 33;
        this.nextState[33][20] = 33;
        this.nextState[33][21] = 33;
        this.nextState[33][44] = 33;
        this.nextState[33][45] = 33;
        this.nextState[33][46] = 33;
        this.nextState[33][47] = 33;
        this.nextState[33][48] = 33;
        this.nextState[33][23] = 33;
        this.nextState[33][26] = 33;
        this.nextState[33][53] = 33;
        this.nextState[33][8] = 33;
        this.nextState[33][55] = 33;
        this.nextState[2][14] = 14;
        this.nextState[14][12] = 15;
        this.nextState[15][20] = 16;
        this.nextState[16][12] = 17;
        this.nextState[2][16] = 18;
        this.nextState[18][18] = 19;
        this.nextState[19][13] = 20;
        this.nextState[20][17] = 21;
        this.nextState[21][21] = 22;
        this.nextState[22][14] = 23;
        this.nextState[23][15] = 24;
        this.nextState[2][12] = 25;
        this.nextState[25][19] = 26;
        this.nextState[26][13] = 27;
        this.nextState[27][16] = 28;
        this.nextState[28][16] = 29;
        this.nextState[2][12] = 25;
        this.nextState[25][17] = 40;
        this.nextState[40][16] = 41;
        this.nextState[41][44] = 42;
        this.nextState[42][18] = 43;
        this.nextState[2][45] = 44;
        this.nextState[44][46] = 45;
        this.nextState[45][19] = 46;
        this.nextState[2][17] = 47;
        this.nextState[47][46] = 48;
        this.nextState[48][18] = 49;
        this.nextState[49][44] = 50;
        this.nextState[2][19] = 51;
        this.nextState[51][47] = 52;
        this.nextState[52][46] = 53;
        this.nextState[53][48] = 54;
        this.nextState[54][20] = 55;
    }

    private boolean isFinalState(int state) {
        return state == 11 || state == 10 || state == 13 || state == 8 || state == 9 || state == 6 || state == 24 || state == 29 || state == 17 || (this.plusIsSymbol || this.plusIsToken) && state == 56 || (this.minusIsSymbol || this.minusIsToken) && state == 57 || state == 0 || state == 32 || state == 34 || state == 35 || state == 43 || state == 46 || state == 55 || state == 50;
    }

    private char getNextChar() {
        char c;
        this.top.prevColumnNumber = this.top.columnNumber;
        this.top.prevLineNumber = this.top.lineNumber;
        this.top.prevOffset = this.top.offset;
        try {
            c = (char)this.top.reader.read();
            if (c == '\r') {
                c = (char)this.top.reader.read();
            }
        }
        catch (IOException ioe) {
            throw new AssemblyException("Error: CPU Sim couldn't read a character", new Token(this.top.filename, -1, this.top.lineNumber, this.top.columnNumber, this.top.offset, "", false));
        }
        if (c != '\uffff' && c >= '\u0080') {
            throw new AssemblyException("Error: non-ASCII character found", new Token(this.top.filename, -1, this.top.lineNumber, this.top.columnNumber, this.top.offset, "" + c, false));
        }
        if (c == '\uffff') {
            this.filenames.remove(this.top.filename);
            this.streamStack.pop();
            if (!this.streamStack.empty()) {
                this.top = this.streamStack.peek();
                return this.top.currentChar;
            }
        }
        if (c != '\uffff') {
            if (this.charType[c] == 3) {
                ++this.top.lineNumber;
                this.top.columnNumber = 0;
            } else {
                ++this.top.columnNumber;
            }
            ++this.top.offset;
        }
        return c;
    }

    private int getTokenType(String string, int currentState) {
        boolean isInstr = false;
        List<MachineInstruction> instructions = this.machine.getInstructions();
        for (MachineInstruction instruction : instructions) {
            if (!string.equals(instruction.getName())) continue;
            isInstr = true;
        }
        int tokenType = isInstr ? 0 : (string.equals(this.pseudoChar + "data") ? 1 : (string.equals(this.pseudoChar + "include") ? 14 : (string.equals(this.pseudoChar + "ascii") ? 15 : (string.equals(this.pseudoChar + "pos") ? 23 : (string.equals(this.pseudoChar + "align") ? 22 : (string.equals(this.pseudoChar + "short") ? 25 : (string.equals(this.pseudoChar + "long") ? 24 : (string.equals("EQU") ? 6 : (string.equals("MACRO") ? 10 : (string.equals("ENDM") ? 11 : (currentState == 11 ? 4 : (currentState == 13 ? 16 : (currentState == 8 ? 3 : (currentState == 9 ? 9 : (currentState == 6 ? 5 : (currentState == 56 ? 2 : (currentState == 57 ? 2 : (currentState == 0 ? -1 : (currentState == 32 ? 5 : (currentState == 34 ? 16 : (currentState == 35 ? 21 : 2)))))))))))))))))))));
        return tokenType;
    }

    public void pushTokens(List<Token> v) {
        for (int i = v.size() - 1; i >= 0; --i) {
            this.top.tokenStack.push(v.get(i));
        }
    }

    public Token getNextToken() {
        if (!this.top.tokenStack.empty()) {
            return this.top.tokenStack.pop();
        }
        StringBuffer buffer = new StringBuffer();
        int currentState = 1;
        int startingLineNumber = this.top.prevLineNumber;
        int startingColumnNumber = this.top.prevColumnNumber;
        int startingOffset = this.top.prevOffset;
        while (this.top.currentChar != '\uffff' && this.nextState[currentState][this.charType[this.top.currentChar]] != 0) {
            currentState = this.nextState[currentState][this.charType[this.top.currentChar]];
            if (this.charType[this.top.currentChar] != 2 || currentState == 9 || currentState == 12 || currentState == 31) {
                buffer.append(this.top.currentChar);
            } else {
                ++startingColumnNumber;
                ++startingOffset;
            }
            this.top.currentChar = this.getNextChar();
        }
        if (this.isFinalState(currentState)) {
            int ttype = this.getTokenType(buffer.toString(), currentState);
            return new Token(this.top.filename, ttype, startingLineNumber, startingColumnNumber, startingOffset, buffer.toString(), true);
        }
        if (this.top.currentChar == '\uffff' && currentState == 1) {
            return new Token(this.top.filename, 8, startingLineNumber, startingColumnNumber, startingOffset, "", true);
        }
        buffer.append(this.top.currentChar);
        if (this.top.currentChar != '\uffff') {
            this.top.currentChar = this.getNextChar();
        }
        int tokenType = this.getTokenType(buffer.toString(), currentState);
        return new Token(this.top.filename, tokenType, startingLineNumber, startingColumnNumber, startingOffset, buffer.toString(), false);
    }
}

