/*
 * Decompiled with CFR 0.152.
 */
package cpusim.xml;

import cpusim.Field;
import cpusim.FieldValue;
import cpusim.FileChannel;
import cpusim.IOChannel;
import cpusim.Machine;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.assembler.EQU;
import cpusim.assembler.PunctChar;
import cpusim.microinstruction.Arithmetic;
import cpusim.microinstruction.Branch;
import cpusim.microinstruction.Comment;
import cpusim.microinstruction.CpusimSet;
import cpusim.microinstruction.Decode;
import cpusim.microinstruction.End;
import cpusim.microinstruction.IO;
import cpusim.microinstruction.Increment;
import cpusim.microinstruction.Logical;
import cpusim.microinstruction.MemoryAccess;
import cpusim.microinstruction.SetCondBit;
import cpusim.microinstruction.Shift;
import cpusim.microinstruction.Test;
import cpusim.microinstruction.TransferAtoR;
import cpusim.microinstruction.TransferRtoA;
import cpusim.microinstruction.TransferRtoR;
import cpusim.module.ConditionBit;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.util.CPUSimConstants;
import cpusim.util.MachineReaderException;
import cpusim.util.RegisterRAMPair;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import cpusim.xml.Lax;
import java.awt.Rectangle;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class MachineReader
implements CPUSimConstants {
    private Machine machine;
    private HashMap components;
    private MachineInstruction currentInstruction;
    private String currentFormat;
    private String opcodeString;
    private String opcodeLine;
    private Locator locator;
    private Vector<RegisterRAMPair> registerRAMPairs;
    private HashMap windowInfo;
    private HashMap cellSizeInfo;
    private HashMap contentBaseInfo;
    private HashMap addressBaseInfo;
    private HashMap channels;
    private RegisterArray currentRegisterArray;
    private int currentRegisterArrayIndex;
    private HashMap<String, Field> fields;
    private Set<Character> allPunctCharacters;
    private List<PunctChar> chars;

    public MachineReader() {
        this.reset();
        this.allPunctCharacters = new HashSet<Character>();
        this.allPunctCharacters.add(Character.valueOf('!'));
        this.allPunctCharacters.add(Character.valueOf('@'));
        this.allPunctCharacters.add(Character.valueOf('$'));
        this.allPunctCharacters.add(Character.valueOf('%'));
        this.allPunctCharacters.add(Character.valueOf('^'));
        this.allPunctCharacters.add(Character.valueOf('&'));
        this.allPunctCharacters.add(Character.valueOf('*'));
        this.allPunctCharacters.add(Character.valueOf('('));
        this.allPunctCharacters.add(Character.valueOf(')'));
        this.allPunctCharacters.add(Character.valueOf('_'));
        this.allPunctCharacters.add(Character.valueOf('='));
        this.allPunctCharacters.add(Character.valueOf('{'));
        this.allPunctCharacters.add(Character.valueOf('}'));
        this.allPunctCharacters.add(Character.valueOf('['));
        this.allPunctCharacters.add(Character.valueOf(']'));
        this.allPunctCharacters.add(Character.valueOf('|'));
        this.allPunctCharacters.add(Character.valueOf('\\'));
        this.allPunctCharacters.add(Character.valueOf(':'));
        this.allPunctCharacters.add(Character.valueOf(';'));
        this.allPunctCharacters.add(Character.valueOf(','));
        this.allPunctCharacters.add(Character.valueOf('.'));
        this.allPunctCharacters.add(Character.valueOf('?'));
        this.allPunctCharacters.add(Character.valueOf('/'));
        this.allPunctCharacters.add(Character.valueOf('~'));
        this.allPunctCharacters.add(Character.valueOf('-'));
        this.allPunctCharacters.add(Character.valueOf('+'));
        this.allPunctCharacters.add(Character.valueOf('#'));
        this.allPunctCharacters.add(Character.valueOf('`'));
    }

    public void reset() {
        this.machine = null;
        this.components = new HashMap();
        this.currentInstruction = null;
        this.currentFormat = "";
        this.opcodeString = null;
        this.opcodeLine = null;
        this.locator = null;
        this.registerRAMPairs = new Vector();
        this.windowInfo = new HashMap();
        this.cellSizeInfo = new HashMap();
        this.contentBaseInfo = new HashMap();
        this.addressBaseInfo = new HashMap();
        this.channels = new HashMap();
        this.currentRegisterArray = null;
        this.currentRegisterArrayIndex = 0;
        this.fields = new HashMap();
        this.chars = new ArrayList<PunctChar>();
    }

    public void parseDataFromFile(File fileToOpen) throws Exception {
        Lax lax = new Lax();
        lax.reset();
        this.reset();
        lax.addHandler(this);
        lax.parseDocument(true, lax, fileToOpen);
    }

    public HashMap getWindowInfo() {
        return this.windowInfo;
    }

    public HashMap getCellSizeInfo() {
        return this.cellSizeInfo;
    }

    public HashMap getContentBaseInfo() {
        return this.contentBaseInfo;
    }

    public HashMap getAddressBaseInfo() {
        return this.addressBaseInfo;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public Vector<RegisterRAMPair> getRegisterRAMPairs() {
        return this.registerRAMPairs;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private String getCurrentLine() {
        if (this.locator == null) {
            return "";
        }
        return "The error is on or near line " + this.locator.getLineNumber() + ".\n";
    }

    public void startMachine(Attributes alAttrs) {
        String name = alAttrs.getValue("name");
        if (name.endsWith(".xml") || name.endsWith(".cpu")) {
            name = name.substring(0, name.length() - 4);
        }
        this.machine = new Machine(name);
        this.machine.getFields().clear();
    }

    public void endMachine() {
        try {
            Object[] instrs = this.machine.getInstructions().toArray(new MachineInstruction[0]);
            Validate.allOpcodesAreUnique((MachineInstruction[])instrs);
            Validate.allNamesAreUnique(instrs);
        }
        catch (ValidationException e) {
            throw new MachineReaderException(this.getCurrentLine() + e.getMessage());
        }
        PunctChar[] punctChars = this.chars.toArray(new PunctChar[0]);
        if (punctChars.length == 0) {
            punctChars = this.machine.getDefaultPunctChars();
        }
        try {
            Validate.punctIsValid(punctChars);
        }
        catch (ValidationException exc) {
            throw new MachineReaderException(this.getCurrentLine() + exc.getMessage());
        }
        this.machine.setPunctChars(punctChars);
        if (this.machine.getModule("rams").size() > 0 && this.machine.getCodeStore() == null) {
            this.machine.setCodeStore((RAM)this.machine.getModule("rams").elementAt(0));
        }
    }

    public void startPunctChar(Attributes attrs) {
        String cAsString = attrs.getValue("char");
        if (cAsString.length() != 1) {
            throw new MachineReaderException(this.getCurrentLine() + "There must be only one punctuation character per line.");
        }
        char c = cAsString.charAt(0);
        if (!this.allPunctCharacters.contains(Character.valueOf(c))) {
            throw new MachineReaderException(this.getCurrentLine() + "Only the punctuation characters !@$%^&*()_={}[]|\\:;,.?/~+-#`" + " are allowed here.");
        }
        String useString = attrs.getValue("use");
        PunctChar.Use use = Enum.valueOf(PunctChar.Use.class, useString);
        this.chars.add(new PunctChar(c, use));
    }

    public void startField(Attributes attrs) {
        String name = attrs.getValue("name");
        if (this.fields.get(name) != null) {
            throw new MachineReaderException(this.getCurrentLine() + "There are two fields with the same name: \"" + name + "\".\nAll field names must be unique.");
        }
        String typeString = attrs.getValue("type");
        Field.Type type = Enum.valueOf(Field.Type.class, typeString);
        String relativityString = attrs.getValue("relativity");
        Field.Relativity rel = Enum.valueOf(Field.Relativity.class, relativityString);
        String signedString = attrs.getValue("signed");
        boolean signed = "true".equals(signedString);
        String offsetString = attrs.getValue("defaultValue");
        String defaultValueString = attrs.getValue("defaultValue");
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the Field \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the Field \"" + name + "\" must non-negative, not \"" + numBits + "\".");
        }
        int defaultValue = 0;
        try {
            defaultValue = Integer.parseInt(defaultValueString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The defaultValue value of the Field \"" + name + "\" must be an integer, not \"" + defaultValueString + "\".");
        }
        if (numBits > 0 && !signed && (defaultValue < 0 || (double)defaultValue > Math.pow(2.0, numBits) - 1.0)) {
            throw new MachineReaderException(this.getCurrentLine() + "The default value of the unsigned Field \"" + name + "\" must be in the range 0 to 2^" + numBits + "-1.");
        }
        if (numBits > 0 && signed && ((double)defaultValue < -Math.pow(2.0, numBits - 1) || (double)defaultValue > Math.pow(2.0, numBits - 1) - 1.0)) {
            throw new MachineReaderException(this.getCurrentLine() + "The default value of the signed Field \"" + name + "\" must be in the range -(2^" + (numBits - 1) + ") and" + "(2^" + (numBits - 1) + "-1).");
        }
        int offset = 0;
        try {
            offset = Integer.parseInt(offsetString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The offset value of the Field \"" + name + "\" must be an integer, not \"" + offsetString + "\".");
        }
        Field f = new Field(name, type, numBits, rel, new ArrayList<FieldValue>(), defaultValue, signed, offset);
        this.machine.getFields().add(f);
        this.fields.put(name, f);
    }

    public void startFieldValue(Attributes attrs) {
        String name = attrs.getValue("name");
        String valueString = attrs.getValue("value");
        int value = 0;
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The value of FieldValue \"" + name + "\" must be an integer, not \"" + valueString + "\".");
        }
        Field lastField = this.machine.getFields().get(this.machine.getFields().size() - 1);
        lastField.getValues().add(new FieldValue(name, value));
    }

    public void startRegister(Attributes attrs) {
        Register r;
        int width;
        String name = attrs.getValue("name");
        String widthString = attrs.getValue("width");
        try {
            width = Integer.parseInt(widthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The width of register \"" + name + "\" must be an integer, not \"" + widthString + "\".");
        }
        if (width <= 0 || width > 64) {
            throw new MachineReaderException(this.getCurrentLine() + "The width of register \"" + name + "\" must be between 1 and 64, not " + width);
        }
        String id = attrs.getValue("id");
        if (this.currentRegisterArray != null) {
            if (this.currentRegisterArrayIndex >= this.currentRegisterArray.getLength()) {
                throw new MachineReaderException(this.getCurrentLine() + "The length " + "of register array " + this.currentRegisterArray.getName() + " does not match the list of registers for it");
            }
            r = this.currentRegisterArray.registers()[this.currentRegisterArrayIndex];
            ++this.currentRegisterArrayIndex;
        } else {
            r = new Register(name, width);
            this.machine.getModule("registers").addElement(r);
        }
        this.components.put(id, r);
    }

    public void startRegisterArray(Attributes attrs) {
        String name = attrs.getValue("name");
        String widthString = attrs.getValue("width");
        int width = 0;
        try {
            width = Integer.parseInt(widthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The width of register \"" + name + "\" must be an integer, not \"" + widthString + "\".");
        }
        if (width <= 0 || width > 64) {
            throw new MachineReaderException(this.getCurrentLine() + "The width of the registers " + "in register array \"" + name + "\" must be between 1 and 64, not " + width + ".");
        }
        String lengthString = attrs.getValue("length");
        int length = 0;
        try {
            length = Integer.parseInt(lengthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The length of register " + "array \"" + name + "\" must be an integer, not \"" + lengthString + "\".");
        }
        if (length <= 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The length of register " + "array \"" + name + "\" must be positive, not " + width + ".");
        }
        RegisterArray r = new RegisterArray(name, length, width);
        String id = attrs.getValue("id");
        this.components.put(id, r);
        this.machine.getModule("registerArrays").addElement(r);
        this.currentRegisterArray = r;
        this.currentRegisterArrayIndex = 0;
    }

    public void endRegisterArray() {
        this.currentRegisterArray = null;
    }

    public void startConditionBit(Attributes attrs) {
        String name = attrs.getValue("name");
        String haltString = attrs.getValue("halt");
        boolean halt = haltString.equals("true");
        String registerID = attrs.getValue("register");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The register attribute " + "of condition bit \"" + name + "\" is not valid.");
        }
        Register register = (Register)object;
        String bitString = attrs.getValue("bit");
        int bit = 0;
        try {
            bit = Integer.parseInt(bitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The bit index of condition bit \"" + name + "\" must be an integer, not \"" + bitString + "\".");
        }
        if (bit < 0 || bit >= register.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The bit index of condition bit \"" + name + "\" is " + bit + ", which is out of range.");
        }
        ConditionBit c = new ConditionBit(name, register, bit, halt);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getModule("conditionBits").addElement(c);
    }

    public void startRAM(Attributes attrs) {
        int cellSize;
        String name = attrs.getValue("name");
        String lengthString = attrs.getValue("length");
        int length = 0;
        try {
            length = Integer.parseInt(lengthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The length of RAM \"" + name + "\" must be an integer, not \"" + lengthString + "\".");
        }
        if (length <= 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The length of RAM \"" + name + "\" must be positive, not " + length + ".");
        }
        String cellSizeString = attrs.getValue("cellSize");
        if (cellSizeString == null) {
            cellSize = 8;
        } else {
            try {
                cellSize = Integer.parseInt(cellSizeString);
            }
            catch (NumberFormatException e) {
                throw new MachineReaderException(this.getCurrentLine() + "The number of bits of each cell of RAM \"" + name + "\" must be an integer, not \"" + lengthString + "\".");
            }
        }
        if (cellSize <= 0 || cellSize > 64) {
            throw new MachineReaderException(this.getCurrentLine() + "The number of bits of each cell of RAM \"" + name + "\" must be a positive integer at most" + " 64, not " + length + ".");
        }
        RAM ram = new RAM(name, length, cellSize);
        String id = attrs.getValue("id");
        this.components.put(id, ram);
        this.machine.getModule("rams").addElement(ram);
    }

    public void startIncrement(Attributes attrs) {
        ConditionBit overflowBit;
        String name = attrs.getValue("name");
        String deltaString = attrs.getValue("delta");
        int delta = 0;
        try {
            delta = Integer.parseInt(deltaString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The delta value of the " + "Increment microinstruction \"" + name + "\" must be an integer, not \"" + deltaString + "\".");
        }
        String registerID = attrs.getValue("register");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The register attribute " + "of Increment microinstruction \"" + name + "\" is not valid.");
        }
        Register register = (Register)object;
        String overflowBitID = attrs.getValue("overflowBit");
        if (overflowBitID == null) {
            overflowBit = CPUSimConstants.NO_CONDITIONBIT;
        } else {
            object = this.components.get(overflowBitID);
            if (object == null || !(object instanceof ConditionBit)) {
                throw new MachineReaderException(this.getCurrentLine() + "The overflowBit attribute " + "of Increment microinstruction \"" + name + "\" is not valid.");
            }
            overflowBit = (ConditionBit)object;
        }
        Increment c = new Increment(name, delta, register, overflowBit);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("increment").addElement(c);
    }

    public void startArithmetic(Attributes attrs) {
        ConditionBit carryBit;
        ConditionBit overflowBit;
        String name = attrs.getValue("name");
        String type = attrs.getValue("type");
        String registerID = attrs.getValue("source1");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source1 attribute " + "of Arithmetic microinstruction \"" + name + "\" is not valid.");
        }
        Register source1 = (Register)object;
        registerID = attrs.getValue("source2");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source2 attribute " + "of Arithmetic microinstruction \"" + name + "\" is not valid.");
        }
        Register source2 = (Register)object;
        registerID = attrs.getValue("destination");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The destinations attribute " + "of Arithmetic microinstruction \"" + name + "\" is not valid.");
        }
        Register destination = (Register)object;
        String overflowBitID = attrs.getValue("overflowBit");
        if (overflowBitID == null) {
            overflowBit = CPUSimConstants.NO_CONDITIONBIT;
        } else {
            object = this.components.get(overflowBitID);
            if (object == null || !(object instanceof ConditionBit)) {
                throw new MachineReaderException(this.getCurrentLine() + "The overflowBit attribute " + "of Arithmetic microinstruction \"" + name + "\" is not valid.");
            }
            overflowBit = (ConditionBit)object;
        }
        String carryBitID = attrs.getValue("carryBit");
        if (carryBitID == null) {
            carryBit = CPUSimConstants.NO_CONDITIONBIT;
        } else {
            object = this.components.get(carryBitID);
            if (object == null || !(object instanceof ConditionBit)) {
                throw new MachineReaderException(this.getCurrentLine() + "The carryBit attribute " + "of Arithmetic microinstruction \"" + name + "\" is not valid.");
            }
            carryBit = (ConditionBit)object;
        }
        Arithmetic c = new Arithmetic(name, type, source1, source2, destination, overflowBit, carryBit);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("arithmetic").addElement(c);
    }

    public void startTransferRtoR(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("source");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source attribute " + "of TransferRtoR microinstruction \"" + name + "\" is not valid.");
        }
        Register source = (Register)object;
        registerID = attrs.getValue("dest");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The dest attribute " + "of TransferRtoR microinstruction \"" + name + "\" is not valid.");
        }
        Register dest = (Register)object;
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferRtoR microinstruction \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferRtoR microinstruction \"" + name + "\" must be nonnegative, not " + numBits + ".");
        }
        String srcStartBitString = attrs.getValue("srcStartBit");
        int srcStartBit = 0;
        try {
            srcStartBit = Integer.parseInt(srcStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferRtoR microinstruction \"" + name + "\" must be an integer, not \"" + srcStartBitString + "\".");
        }
        if (srcStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferRtoR microinstruction \"" + name + "\" must be nonnegative, not " + srcStartBit + ".");
        }
        String destStartBitString = attrs.getValue("destStartBit");
        int destStartBit = 0;
        try {
            destStartBit = Integer.parseInt(destStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferRtoR microinstruction \"" + name + "\" must be an integer, not \"" + destStartBitString + "\".");
        }
        if (destStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferRtoR microinstruction \"" + name + "\" must be nonnegative, not " + destStartBit + ".");
        }
        if (destStartBit + numBits > dest.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The destination bits of the " + "TransferRtoR microinstruction \"" + name + "\" are out of range for the destination register.");
        }
        if (srcStartBit + numBits > source.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The source bits of the " + "TransferRtoR microinstruction \"" + name + "\" are out of range for the source register.");
        }
        TransferRtoR c = new TransferRtoR(name, source, srcStartBit, dest, destStartBit, numBits);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("transferRtoR").addElement(c);
    }

    public void startTransferRtoA(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("source");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source attribute " + "of TransferRtoA microinstruction \"" + name + "\" is not valid.");
        }
        Register source = (Register)object;
        registerID = attrs.getValue("dest");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof RegisterArray)) {
            throw new MachineReaderException(this.getCurrentLine() + "The dest attribute " + "of TransferRtoA microinstruction \"" + name + "\" is not valid.");
        }
        RegisterArray dest = (RegisterArray)object;
        registerID = attrs.getValue("index");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The index attribute " + "of TransferRtoA microinstruction \"" + name + "\" is not valid.");
        }
        Register index = (Register)object;
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferRtoA microinstruction \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferRtoA microinstruction \"" + name + "\" must be nonnegative, not " + numBits + ".");
        }
        String srcStartBitString = attrs.getValue("srcStartBit");
        int srcStartBit = 0;
        try {
            srcStartBit = Integer.parseInt(srcStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferRtoA microinstruction \"" + name + "\" must be an integer, not \"" + srcStartBitString + "\".");
        }
        if (srcStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferRtoA microinstruction \"" + name + "\" must be nonnegative, not " + srcStartBit + ".");
        }
        String indexNumBitsString = attrs.getValue("indexNumBits");
        int indexNumBits = index.getWidth();
        if (indexNumBitsString != null) {
            try {
                indexNumBits = Integer.parseInt(indexNumBitsString);
            }
            catch (NumberFormatException e) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexNumBits value of the " + "TransferRtoA microinstruction \"" + name + "\" must be an integer, not \"" + indexNumBitsString + "\".");
            }
            if (indexNumBits <= 0) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexNumBits value of the " + "TransferRtoA microinstruction \"" + name + "\" must be positive, not " + indexNumBits + ".");
            }
        }
        String indexStartString = attrs.getValue("indexStart");
        int indexStart = 0;
        if (indexStartString != null) {
            try {
                indexStart = Integer.parseInt(indexStartString);
            }
            catch (NumberFormatException e) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexStart value of the " + "TransferRtoA microinstruction \"" + name + "\" must be an integer, not \"" + indexStartString + "\".");
            }
            if (indexStart < 0) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexStart value of the " + "TransferRtoA microinstruction \"" + name + "\" must be nonnegative, not " + indexStart + ".");
            }
        }
        String destStartBitString = attrs.getValue("destStartBit");
        int destStartBit = 0;
        try {
            destStartBit = Integer.parseInt(destStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferRtoA microinstruction \"" + name + "\" must be an integer, not \"" + destStartBitString + "\".");
        }
        if (destStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferRtoA microinstruction \"" + name + "\" must be nonnegative, not " + destStartBit + ".");
        }
        if (destStartBit + numBits > dest.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The destination bits of the " + "TransferRtoA microinstruction \"" + name + "\" are out of range for the destination register.");
        }
        if (srcStartBit + numBits > source.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The source bits of the " + "TransferRtoA microinstruction \"" + name + "\" are out of range for the source register.");
        }
        if (indexStart + indexNumBits > index.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The specified bits of the " + "TransferRtoA microinstruction \"" + name + "\" are out of range for the index register.");
        }
        TransferRtoA c = new TransferRtoA(name, source, srcStartBit, dest, destStartBit, numBits, index, indexStart, indexNumBits);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("transferRtoA").addElement(c);
    }

    public void startTransferAtoR(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("source");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof RegisterArray)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source attribute " + "of TransferAtoR microinstruction \"" + name + "\" is not valid.");
        }
        RegisterArray source = (RegisterArray)object;
        registerID = attrs.getValue("dest");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The dest attribute " + "of TransferAtoR microinstruction \"" + name + "\" is not valid.");
        }
        Register dest = (Register)object;
        registerID = attrs.getValue("index");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The index attribute " + "of TransferAtoR microinstruction \"" + name + "\" is not valid.");
        }
        Register index = (Register)object;
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferAtoR microinstruction \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "TransferAtoR microinstruction \"" + name + "\" must be nonnegative, not " + numBits + ".");
        }
        String srcStartBitString = attrs.getValue("srcStartBit");
        int srcStartBit = 0;
        try {
            srcStartBit = Integer.parseInt(srcStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferAtoR microinstruction \"" + name + "\" must be an integer, not \"" + srcStartBitString + "\".");
        }
        if (srcStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The srcStartBit value of the " + "TransferAtoR microinstruction \"" + name + "\" must be nonnegative, not " + srcStartBit + ".");
        }
        String indexNumBitsString = attrs.getValue("indexNumBits");
        int indexNumBits = index.getWidth();
        if (indexNumBitsString != null) {
            try {
                indexNumBits = Integer.parseInt(indexNumBitsString);
            }
            catch (NumberFormatException e) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexNumBits value of the " + "TransferAtoR microinstruction \"" + name + "\" must be an integer, not \"" + indexNumBitsString + "\".");
            }
            if (indexNumBits <= 0) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexNumBits value of the " + "TransferAtoR microinstruction \"" + name + "\" must be positive, not " + indexNumBits + ".");
            }
        }
        String indexStartString = attrs.getValue("indexStart");
        int indexStart = 0;
        if (indexStartString != null) {
            try {
                indexStart = Integer.parseInt(indexStartString);
            }
            catch (NumberFormatException e) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexStart value of the " + "TransferAtoR microinstruction \"" + name + "\" must be an integer, not \"" + indexStartString + "\".");
            }
            if (indexStart < 0) {
                throw new MachineReaderException(this.getCurrentLine() + "The indexStart value of the " + "TransferAtoR microinstruction \"" + name + "\" must be nonnegative, not " + indexStart + ".");
            }
        }
        String destStartBitString = attrs.getValue("destStartBit");
        int destStartBit = 0;
        try {
            destStartBit = Integer.parseInt(destStartBitString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferAtoR microinstruction \"" + name + "\" must be an integer, not \"" + destStartBitString + "\".");
        }
        if (destStartBit < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The destStartBit value of the " + "TransferAtoR microinstruction \"" + name + "\" must be nonnegative, not " + destStartBit + ".");
        }
        if (destStartBit + numBits > dest.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The destination bits of the " + "TransferAtoR microinstruction \"" + name + "\" are out of range for the destination register.");
        }
        if (srcStartBit + numBits > source.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The source bits of the " + "TransferAtoR microinstruction \"" + name + "\" are out of range for the source register.");
        }
        if (indexStart + indexNumBits > index.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The specified bits of the " + "TransferAtoR microinstruction \"" + name + "\" are out of range for the index register.");
        }
        TransferAtoR c = new TransferAtoR(name, source, srcStartBit, dest, destStartBit, numBits, index, indexStart, indexNumBits);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("transferAtoR").addElement(c);
    }

    public void startShift(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("source");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source attribute " + "of Shift microinstruction \"" + name + "\" is not valid.");
        }
        Register source = (Register)object;
        registerID = attrs.getValue("destination");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The dest attribute " + "of Shift microinstruction \"" + name + "\" is not valid.");
        }
        Register dest = (Register)object;
        if (source.getWidth() != dest.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The source and destination " + "registers of the Shift microinstruction \"" + name + "\" must have equal widths.");
        }
        String distanceString = attrs.getValue("distance");
        int distance = 0;
        try {
            distance = Integer.parseInt(distanceString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The distance value of the " + "Shift microinstruction \"" + name + "\" must be an integer, not \"" + distanceString + "\".");
        }
        if (distance < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The distance value of the " + "Shift microinstruction \"" + name + "\" must be nonnegative, not " + distance + ".");
        }
        String type = attrs.getValue("type");
        String direction = attrs.getValue("direction");
        Shift c = new Shift(name, source, dest, direction, distance, type);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("shift").addElement(c);
    }

    public void startBranch(Attributes attrs) {
        String name = attrs.getValue("name");
        String amountString = attrs.getValue("amount");
        int amount = 0;
        try {
            amount = Integer.parseInt(amountString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The amount value of the " + "Branch microinstruction \"" + name + "\" must be an integer, not \"" + amountString + "\".");
        }
        Branch c = new Branch(name, amount, this.machine.getControlUnit());
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("branch").addElement(c);
    }

    public void startLogical(Attributes attrs) {
        String name = attrs.getValue("name");
        String type = attrs.getValue("type");
        String registerID = attrs.getValue("source1");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source1 attribute " + "of Logical microinstruction \"" + name + "\" is not valid.");
        }
        Register source1 = (Register)object;
        registerID = attrs.getValue("source2");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The source2 attribute " + "of Logical microinstruction \"" + name + "\" is not valid.");
        }
        Register source2 = (Register)object;
        registerID = attrs.getValue("destination");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The destinations attribute " + "of Logical microinstruction \"" + name + "\" is not valid.");
        }
        Register destination = (Register)object;
        if (source1.getWidth() != source2.getWidth() || source2.getWidth() != destination.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The two source and destination " + "registers of Logical microinstruction \"" + name + "\" are not the same width.");
        }
        Logical c = new Logical(name, type, source1, source2, destination);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("logical").addElement(c);
    }

    public void startSet(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("register");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The register attribute " + "of Set microinstruction \"" + name + "\" is not valid.");
        }
        Register register = (Register)object;
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "Set microinstruction \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits <= 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "Set microinstruction " + name + " must be positive, not " + numBits + ".");
        }
        String startString = attrs.getValue("start");
        int start = 0;
        try {
            start = Integer.parseInt(startString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The start value of the " + "Set microinstruction \"" + name + "\" must be an integer, not \"" + startString + "\".");
        }
        if (start < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The start value of the " + "Set microinstruction \"" + name + "\" must be nonnegative, not " + start + ".");
        }
        if (start + numBits > register.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The register bits of the " + "Set microinstruction \"" + name + "\" are out of range for the register register.");
        }
        String valueString = attrs.getValue("value");
        int value = 0;
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The value attribute of the " + "Set microinstruction \"" + name + "\" must be an integer, not \"" + valueString + "\".");
        }
        BigInteger bigValue = BigInteger.valueOf(value);
        BigInteger twoToBits = BigInteger.valueOf(2L).pow(numBits);
        BigInteger twoToBitsMinusOne = BigInteger.valueOf(2L).pow(numBits - 1);
        if (bigValue.compareTo(twoToBits) >= 0 || bigValue.compareTo(twoToBitsMinusOne.negate()) < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The value attribute of the " + "Set microinstruction \"" + name + "\" doesn't fit in the given number of bits.");
        }
        CpusimSet c = new CpusimSet(name, register, start, numBits, value);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("set").addElement(c);
    }

    public void startTest(Attributes attrs) {
        String name = attrs.getValue("name");
        String comparison = attrs.getValue("comparison");
        String registerID = attrs.getValue("register");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The register attribute " + "of Test microinstruction \"" + name + "\" is not valid.");
        }
        Register register = (Register)object;
        String numBitsString = attrs.getValue("numBits");
        int numBits = 0;
        try {
            numBits = Integer.parseInt(numBitsString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "Test microinstruction \"" + name + "\" must be an integer, not \"" + numBitsString + "\".");
        }
        if (numBits < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The numBits value of the " + "Test microinstruction \"" + name + "\" must be nonnegative, not " + numBits + ".");
        }
        String startString = attrs.getValue("start");
        int start = 0;
        try {
            start = Integer.parseInt(startString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The start value of the " + "Test microinstruction \"" + name + "\" must be an integer, not \"" + startString + "\".");
        }
        if (start < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The start value of the " + "Test microinstruction \"" + name + "\" must be nonnegative, not " + start + ".");
        }
        if (start + numBits > register.getWidth()) {
            throw new MachineReaderException(this.getCurrentLine() + "The bits of the " + "Test microinstruction \"" + name + "\" are out of range for the selected register.");
        }
        String valueString = attrs.getValue("value");
        int value = 0;
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The value attribute of the " + "Test microinstruction \"" + name + "\" must be an integer, not \"" + valueString + "\".");
        }
        String omissionString = attrs.getValue("omission");
        int omission = 0;
        try {
            omission = Integer.parseInt(omissionString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The omission attribute of the " + "Test microinstruction \"" + name + "\" must be an integer, not \"" + omissionString + "\".");
        }
        Test c = new Test(name, register, start, numBits, comparison, value, omission, this.machine.getControlUnit());
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("test").addElement(c);
    }

    public void startDecode(Attributes attrs) {
        String name = attrs.getValue("name");
        String registerID = attrs.getValue("ir");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The ir attribute " + "of the Decode microinstruction \"" + name + "\" is not valid.");
        }
        Register ir = (Register)object;
        Decode c = new Decode(name, ir, this.machine);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("decode").addElement(c);
    }

    public void startFileChannel(Attributes attrs) {
        String fileName = attrs.getValue("file");
        if (this.channelsUse(fileName)) {
            throw new MachineReaderException(this.getCurrentLine() + "There can be at most one channel per file." + "  File \"" + fileName + "\" has two or more channels.");
        }
        FileChannel f = new FileChannel(new File(fileName));
        String id = attrs.getValue("id");
        this.channels.put(id, f);
    }

    public void startIO(Attributes attrs) {
        IOChannel connection;
        String name = attrs.getValue("name");
        String direction = attrs.getValue("direction");
        String type = attrs.getValue("type");
        if ("character".equals(type)) {
            throw new MachineReaderException(this.getCurrentLine() + "IO microinstructions of type " + "character are not yet implemented.  The microinstruction \"" + name + "\" is not valid.");
        }
        String registerID = attrs.getValue("buffer");
        Object object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The buffer attribute " + "of the IO microinstruction \"" + name + "\" is not valid.");
        }
        Register buffer = (Register)object;
        String channelID = attrs.getValue("connection");
        if (channelID == null || channelID.equals("") || channelID.equals("[console]")) {
            connection = CONSOLE_CHANNEL;
        } else if (channelID.equals("[user]")) {
            connection = USER_CHANNEL;
        } else {
            object = this.channels.get(channelID);
            if (object == null) {
                throw new MachineReaderException(this.getCurrentLine() + "The connection attribute " + "of the IO microinstruction \"" + name + "\" is not valid.");
            }
            connection = (FileChannel)object;
        }
        IO c = new IO(name, direction, type, buffer, connection);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("io").addElement(c);
    }

    public void startMemoryAccess(Attributes attrs) {
        String name = attrs.getValue("name");
        String direction = attrs.getValue("direction");
        String ramID = attrs.getValue("memory");
        Object object = this.components.get(ramID);
        if (object == null || !(object instanceof RAM)) {
            throw new MachineReaderException(this.getCurrentLine() + "The memory attribute " + "of the MemoryAccess microinstruction \"" + name + "\" is not valid.");
        }
        RAM memory = (RAM)object;
        String registerID = attrs.getValue("data");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The data register attribute " + "of the MemoryAccess microinstruction \"" + name + "\" is not valid.");
        }
        Register data = (Register)object;
        registerID = attrs.getValue("address");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The address register attribute " + "of the MemoryAccess microinstruction \"" + name + "\" is not valid.");
        }
        Register address = (Register)object;
        MemoryAccess c = new MemoryAccess(name, direction, memory, data, address);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("memoryAccess").addElement(c);
    }

    public void startSetCondBit(Attributes attrs) {
        String name = attrs.getValue("name");
        String value = attrs.getValue("value");
        String bitID = attrs.getValue("bit");
        Object object = this.components.get(bitID);
        if (object == null || !(object instanceof ConditionBit)) {
            throw new MachineReaderException(this.getCurrentLine() + "The bit attribute " + "of SetCondBit microinstruction \"" + name + "\" is not valid.");
        }
        ConditionBit bit = (ConditionBit)object;
        SetCondBit c = new SetCondBit(name, bit, value);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.getMicros("setCondBit").addElement(c);
    }

    public void startEnd(Attributes attrs) {
        End c = new End(this.machine);
        String id = attrs.getValue("id");
        this.components.put(id, c);
        this.machine.setEnd(c);
    }

    public void startComment(Attributes attrs) {
        String name = attrs.getValue("name");
        Comment c = new Comment();
        c.setName(name);
        String id = attrs.getValue("id");
        this.components.put(id, c);
    }

    public void startFetchSequence(Attributes attrs) {
        this.currentInstruction = this.machine.getFetchSequence();
    }

    public void startMachineInstruction(Attributes attrs) {
        if (this.machine.getFields().size() == 0) {
            for (int i = 1; i <= 16; ++i) {
                String name1 = "" + i;
                Field f1 = new Field(name1, Field.Type.required, i, Field.Relativity.absolute, new ArrayList<FieldValue>(), 0, true, 0);
                this.machine.getFields().add(f1);
                this.fields.put(name1, f1);
                String name2 = "-" + i;
                Field f2 = new Field(name2, Field.Type.ignored, i, Field.Relativity.absolute, new ArrayList<FieldValue>(), 0, true, 0);
                this.machine.getFields().add(f2);
                this.fields.put(name2, f2);
            }
        }
        String name = attrs.getValue("name");
        try {
            Validate.nameIsValidAssembly(name, this.chars.toArray(new PunctChar[0]));
        }
        catch (ValidationException e) {
            throw new MachineReaderException(this.getCurrentLine() + e.getMessage());
        }
        this.opcodeString = attrs.getValue("opcode");
        this.opcodeLine = this.getCurrentLine();
        long opcode = 0L;
        try {
            opcode = Long.parseLong(this.opcodeString, 16);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The opcode value " + "of the machine instruction\n\"" + name + "\" must be a" + " hexadecimal integer of at most 16 hex characters,\n" + "not \"" + this.opcodeString + "\".");
        }
        if (this.opcodeString.charAt(0) == '-') {
            throw new MachineReaderException(this.getCurrentLine() + "The opcode value " + "of the machine instruction\n \"" + name + "\" must be a" + " nonnegative hexadecimal integer" + ", not \"" + this.opcodeString + "\".");
        }
        this.currentFormat = attrs.getValue("format");
        if (this.currentFormat == null) {
            this.currentFormat = "";
        }
        this.currentInstruction = new MachineInstruction(name, opcode, this.currentFormat, this.machine);
        this.machine.getInstructions().add(this.currentInstruction);
    }

    public void endMachineInstruction() {
        try {
            this.currentInstruction.setFormat(this.currentFormat);
            Validate.fieldsListIsNotEmpty(this.currentInstruction);
            Validate.opcodeFits(this.currentInstruction);
            Validate.firstFieldIsProper(this.currentInstruction);
            Validate.fieldLengthsAreAtMost64(this.currentInstruction);
        }
        catch (ValidationException e) {
            throw new MachineReaderException((this.locator == null ? "" : "The error is in the MachineInstruction element ending at line ") + this.locator.getLineNumber() + ".\n" + e.getMessage());
        }
    }

    public void startFieldLength(Attributes attrs) {
        String lengthString = attrs.getValue("length");
        int length = 0;
        try {
            length = Integer.parseInt(lengthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "Field lengths of" + " machine instruction \"" + this.currentInstruction.getName() + "\" must be an integer, not \"" + lengthString + "\".");
        }
        if (length == 0) {
            throw new MachineReaderException(this.getCurrentLine() + "Field lengths of" + " machine instruction \"" + this.currentInstruction.getName() + "\" must not be zero.  One is " + length + ".");
        }
        this.currentFormat = this.currentFormat + " " + length;
    }

    public void startMicroinstruction(Attributes attrs) {
        String microID = attrs.getValue("microRef");
        Object object = this.components.get(microID);
        if (object == null || !(object instanceof Microinstruction)) {
            throw new MachineReaderException(this.getCurrentLine() + "The microRef attribute \"" + microID + "\" of one of \nthe microinstructions for the " + "instruction \"" + this.currentInstruction.getName() + "\" is not valid.");
        }
        Microinstruction micro = (Microinstruction)object;
        this.currentInstruction.getMicros().add(micro);
    }

    public void startEQU(Attributes attrs) {
        String name = attrs.getValue("name");
        String valueString = attrs.getValue("value");
        long value = 0L;
        try {
            value = Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The value of EQU \"" + name + "\" must be an integer, not \"" + valueString + "\".");
        }
        this.machine.getEQUs().addElement(new EQU(name, value));
    }

    public void startRegisterRAMPair(Attributes attrs) {
        String ramID = attrs.getValue("ram");
        Object object = this.components.get(ramID);
        if (object == null || !(object instanceof RAM)) {
            throw new MachineReaderException(this.getCurrentLine() + "The ram attribute \"" + ramID + "\" of a RegisterRAMPair is not valid.");
        }
        RAM ram = (RAM)object;
        String registerID = attrs.getValue("register");
        object = this.components.get(registerID);
        if (object == null || !(object instanceof Register)) {
            throw new MachineReaderException(this.getCurrentLine() + "The register attribute \"" + registerID + "\"of a RegisterRAMPair is not valid.");
        }
        Register register = (Register)object;
        String dynamicString = attrs.getValue("dynamic");
        boolean dynamic = "true".equals(dynamicString);
        this.registerRAMPairs.add(new RegisterRAMPair(register, ram, dynamic));
    }

    public void startLoadingInfo(Attributes attrs) {
        String ramID = attrs.getValue("ram");
        Object object = this.components.get(ramID);
        if (object == null || !(object instanceof RAM)) {
            throw new MachineReaderException(this.getCurrentLine() + "The ram attribute \"" + ramID + "\" of a LoadingInfo element is not a valid RAM ID.");
        }
        RAM ram = (RAM)object;
        String addressString = attrs.getValue("startingAddress");
        int startAddress = 0;
        try {
            startAddress = Integer.parseInt(addressString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The starting address " + "must be an integer, not \"" + addressString + "\".");
        }
        if (startAddress < 0) {
            throw new MachineReaderException(this.getCurrentLine() + "The starting address " + startAddress + "\" must be a nonnegative integer.");
        }
        this.machine.setCodeStore(ram);
        this.machine.setStartingAddressForLoading(startAddress);
    }

    public void startRegisterWindowInfo(Attributes attrs) {
        this.windowInfo.put("Registers", this.getRectangle(attrs));
        String baseString = attrs.getValue("base");
        if (baseString == null) {
            baseString = "Decimal";
        } else if (baseString.equals("UnsignedDec")) {
            baseString = "Unsigned Dec";
        }
        this.contentBaseInfo.put("Registers", baseString);
    }

    public void startRegisterArrayWindowInfo(Attributes attrs) {
        String arrayID = attrs.getValue("array");
        Object object = this.components.get(arrayID);
        if (object == null || !(object instanceof RegisterArray)) {
            throw new MachineReaderException(this.getCurrentLine() + "The array attribute \"" + arrayID + "\" of a \nRegisterArrayWindowInfo element is " + "not a valid register array ID.");
        }
        this.windowInfo.put(object, this.getRectangle(attrs));
        String baseString = attrs.getValue("base");
        if (baseString == null) {
            baseString = "Decimal";
        } else if (baseString.equals("UnsignedDec")) {
            baseString = "Unsigned Dec";
        }
        this.contentBaseInfo.put(object, baseString);
    }

    public void startRAMWindowInfo(Attributes attrs) {
        String ramID = attrs.getValue("ram");
        Object object = this.components.get(ramID);
        if (object == null || !(object instanceof RAM)) {
            throw new MachineReaderException(this.getCurrentLine() + "The ram attribute \"" + ramID + "\" of a RAMWindowInfo element is not a valid RAM ID.");
        }
        this.windowInfo.put(object, this.getRectangle(attrs));
        String contentBaseString = attrs.getValue("contentsbase");
        String addressBaseString = attrs.getValue("addressbase");
        String oldBaseString = attrs.getValue("base");
        if (contentBaseString != null && contentBaseString.equals("UnsignedDec")) {
            this.contentBaseInfo.put(object, "Unsigned Dec");
        } else if (contentBaseString != null) {
            this.contentBaseInfo.put(object, contentBaseString);
        } else if (oldBaseString != null) {
            this.contentBaseInfo.put(object, oldBaseString);
        } else {
            this.contentBaseInfo.put(object, "Decimal");
        }
        if (addressBaseString != null) {
            this.addressBaseInfo.put(object, addressBaseString);
        } else if (oldBaseString != null && !oldBaseString.equals("Ascii")) {
            this.addressBaseInfo.put(object, oldBaseString);
        } else {
            this.addressBaseInfo.put(object, "Decimal");
        }
        String cellSizeString = attrs.getValue("cellSize");
        int rowSize = 0;
        try {
            rowSize = Integer.parseInt(cellSizeString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The row size " + "(called 'cellSize') must be an integer, not \"" + cellSizeString + "\".");
        }
        if (rowSize < 1 || rowSize > 8) {
            throw new MachineReaderException(this.getCurrentLine() + "The row size " + "(called 'cellSize') must be an integer from 1 to 8," + " not \"" + cellSizeString + "\".");
        }
        this.cellSizeInfo.put(object, new Integer(rowSize));
    }

    private Rectangle getRectangle(Attributes attrs) {
        String topString = attrs.getValue("top");
        int top = 0;
        try {
            top = Integer.parseInt(topString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The top attribute " + "must be an integer, not \"" + topString + "\".");
        }
        String leftString = attrs.getValue("left");
        int left = 0;
        try {
            left = Integer.parseInt(leftString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The left attribute " + "must be an integer, not \"" + leftString + "\".");
        }
        String widthString = attrs.getValue("width");
        int width = 0;
        try {
            width = Integer.parseInt(widthString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The width attribute " + "must be an integer, not \"" + widthString + "\".");
        }
        String heightString = attrs.getValue("height");
        int height = 0;
        try {
            height = Integer.parseInt(heightString);
        }
        catch (NumberFormatException e) {
            throw new MachineReaderException(this.getCurrentLine() + "The height attribute " + "must be an integer, not \"" + heightString + "\".");
        }
        return new Rectangle(left, top, width, height);
    }

    private boolean channelsUse(String fileName) {
        Collection e = this.channels.values();
        for (FileChannel channel : e) {
            if (!channel.getFile().toString().equals(fileName)) continue;
            return true;
        }
        return false;
    }
}

