/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import cpusim.util.Convert;
import cpusim.util.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class MBNTableCellEditor
extends DefaultCellEditor
implements CPUSimConstants {
    Class[] argTypes = new Class[]{String.class};
    Constructor constructor;
    Object value;
    int mode;
    int[] numBits;
    int currentNumBits;

    public MBNTableCellEditor(int[] numBits) {
        super(new JTextField());
        ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        this.mode = 0;
        this.numBits = numBits;
    }

    public void setNumBits(int[] newNumBits) {
        this.numBits = newNumBits;
    }

    public int[] getNumBits() {
        return this.numBits;
    }

    public void setMode(int newBase) {
        this.mode = newBase;
        Assert.That(this.mode == 1 || this.mode == 2 || this.mode == 0 || this.mode == 4 || this.mode == 5 || this.mode == 3, "Bad mode " + this.mode + " in MBNTableCellEditor.setMode()");
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        try {
            if (this.mode == 1) {
                s = Convert.removeAllWhiteSpace(s);
                s = Long.toString(Convert.fromBinaryStringToLong(s, this.currentNumBits));
            } else if (this.mode == 2) {
                s = Convert.removeAllWhiteSpace(s);
                s = Long.toString(Convert.fromHexadecimalStringToLong(s, this.currentNumBits));
            } else if (this.mode == 4) {
                s = Long.toString(Convert.fromAsciiStringToLong(s, this.currentNumBits));
            } else if (this.mode == 0) {
                s = Convert.removeAllWhiteSpace(s);
                s = Long.toString(Convert.fromDecimalStringToLong(s, this.currentNumBits));
            } else if (this.mode == 3) {
                s = Convert.removeAllWhiteSpace(s);
                s = Long.toString(Convert.fromUnsignedDecStringToLong(s, this.currentNumBits));
            } else if (this.mode == 5) {
                s = Long.toString(Convert.fromUnicodeStringToLong(s, this.currentNumBits));
            }
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<Object> type = table.getColumnClass(column);
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(this.argTypes);
        }
        catch (Exception e) {
            return null;
        }
        int modelRow = row;
        if (table.getModel() instanceof TableSorter) {
            modelRow = ((TableSorter)table.getModel()).modelIndex(row);
        }
        this.currentNumBits = this.numBits[modelRow];
        if (this.mode == 1) {
            value = Convert.fromLongToTwosComplementString((Long)value, this.currentNumBits);
            value = Convert.insertSpacesInString((String)value, 4);
        } else if (this.mode == 2) {
            value = Convert.fromLongToHexadecimalString((Long)value, this.currentNumBits).toUpperCase();
            value = Convert.insertSpacesInString((String)value, 4);
        } else if (this.mode == 4) {
            value = Convert.fromLongToAsciiString((Long)value, this.currentNumBits);
        } else if (this.mode == 5) {
            value = Convert.fromLongToUnicodeString((Long)value, this.currentNumBits);
        } else if (this.mode == 3) {
            value = Convert.fromLongToUnsignedDecString((Long)value, this.currentNumBits);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

