/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Machine;
import cpusim.Module;
import cpusim.gui.Desktop;
import cpusim.gui.EditDialog;
import cpusim.gui.LangUnit;
import cpusim.module.ConditionBitFactory;
import cpusim.module.ModuleFactory;
import cpusim.module.RAM;
import cpusim.module.RAMFactory;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.module.RegisterArrayFactory;
import cpusim.module.RegisterFactory;
import cpusim.util.Assert;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.OOTableModel;
import cpusim.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class ModuleDialog
extends EditDialog {
    private ModuleFactory currentFactory;
    private ModuleFactory[] factories;
    private ConditionBitFactory conditionBitFactory;
    private RAMFactory ramFactory;
    private RegisterFactory registerFactory;
    private RegisterArrayFactory arrayFactory;

    public ModuleDialog(Desktop parent, Machine machine) {
        super(parent, LangUnit.LU_EDIT_MODULE.str(), true);
        Container contentPane = this.getContentPane();
        this.machine = machine;
        this.registerFactory = new RegisterFactory(machine);
        this.arrayFactory = new RegisterArrayFactory(machine);
        this.conditionBitFactory = new ConditionBitFactory(machine, this.registerFactory, this.arrayFactory);
        this.registerFactory.setBitFactory(this.conditionBitFactory);
        this.arrayFactory.setBitFactory(this.conditionBitFactory);
        this.ramFactory = new RAMFactory(machine);
        this.factories = new ModuleFactory[]{this.registerFactory, this.arrayFactory, this.conditionBitFactory, this.ramFactory};
        this.currentFactory = this.factories[0];
        for (int i = 0; i < this.factories.length; ++i) {
            this.factories[i].setParentFrame(this);
        }
        JPanel bottomButtonPanel = this.createBottomButtonPanel();
        contentPane.add((Component)bottomButtonPanel, "South");
        contentPane.add((Component)this.createModuleTypeChoicesPanel(), "North");
        JPanel modulePanel = new JPanel();
        modulePanel.setLayout(new BorderLayout());
        modulePanel.add((Component)this.createListAddButtonPanel(), "South");
        this.table = this.createExtendedJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        modulePanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        modulePanel.add((Component)new JScrollPane(this.table), "Center");
        modulePanel.setBorder(BorderFactory.createRaisedBevelBorder());
        contentPane.add((Component)modulePanel, "Center");
        this.displayCurrentModules();
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.currentFactory;
    }

    private void displayCurrentModules() {
        Object[] clones = this.currentFactory.getClones();
        HashMap editors = this.currentFactory.getCellEditors();
        TableSorter sorterModel = (TableSorter)this.table.getModel();
        OOTableModel model = this.table.getOOModel();
        try {
            model.setObjects(clones, this.currentFactory.getProperties());
            this.table.setUpTable(editors, null);
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.newButton.setEnabled(this.currentFactory.newModulesAreAllowed());
        }
        catch (IntrospectionException exc) {
            Assert.That(false, LangUnit.LU_EXCEPT_DISP.str());
        }
    }

    @Override
    protected void updateMachine() {
        this.currentFactory.setClones(this.getObjectList());
        this.machine.setRAMs(this.sortVectorByName(this.ramFactory.createNewModulesList(this.ramFactory.getClones())));
        this.machine.setRegisters(this.sortVectorByName(this.registerFactory.createNewModulesList(this.registerFactory.getClones())));
        this.machine.setRegisterArrays(this.sortVectorByName(this.arrayFactory.createNewModulesList(this.arrayFactory.getClones())));
        this.machine.setConditionBits(this.sortVectorByName(this.conditionBitFactory.createNewModulesList(this.conditionBitFactory.getClones())));
        if (!this.machine.getModule("rams").contains(this.machine.getCodeStore())) {
            if (this.machine.getModule("rams").size() != 0) {
                this.machine.setCodeStore((RAM)this.machine.getModule("rams").elementAt(0));
            } else {
                this.machine.setCodeStore(null);
            }
        }
        this.desktop.addPropertyChangeListenerToAllModules(this.desktop.getBackupManager());
        this.desktop.adjustWindowsForNewModules();
        this.desktop.adjustMenusForNewModules();
        this.desktop.getHighlightManager().updatePairsForNewRegistersAndRAMs();
    }

    private Vector sortVectorByName(Vector modules) {
        for (int i = 0; i < modules.size() - 1; ++i) {
            String nameOfSmallest = ((Module)modules.elementAt(i)).getName();
            int indexOfSmallest = i;
            for (int j = i + 1; j < modules.size(); ++j) {
                Module next = (Module)modules.elementAt(j);
                if (next.getName().compareTo(nameOfSmallest) >= 0) continue;
                indexOfSmallest = j;
                nameOfSmallest = next.getName();
            }
            Object temp = modules.elementAt(i);
            modules.setElementAt(modules.elementAt(indexOfSmallest), i);
            modules.setElementAt(temp, indexOfSmallest);
        }
        return modules;
    }

    private ExtendedJTable createExtendedJTable() {
        ExtendedJTable table = null;
        OOTableModel model = null;
        Object[] clones = this.currentFactory.getClones();
        HashMap editors = this.currentFactory.getCellEditors();
        try {
            model = new OOTableModel(clones);
        }
        catch (Exception e) {
            Assert.That(false, LangUnit.LU_EXCEPT_CREATE_EXTJT.str());
        }
        table = new ExtendedJTable((TableModel)model, editors);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ModuleTableSelectionListener());
        return table;
    }

    private JPanel createModuleTypeChoicesPanel() {
        JPanel thePanel = new JPanel();
        JComboBox<ModuleFactory> typeChoices = new JComboBox<ModuleFactory>(this.factories);
        typeChoices.addActionListener(new TypesComboListener());
        JLabel label = new JLabel(LangUnit.LU_MODULE_TYPE.str());
        thePanel.add(label);
        thePanel.add(typeChoices);
        return thePanel;
    }

    private JPanel createListAddButtonPanel() {
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton(LangUnit.LU_NEW.str());
        this.newButton.setToolTipText(LangUnit.LU_CREATE_MODULE.str());
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(LangUnit.LU_DELETE.str());
        this.deleteButton.setToolTipText(LangUnit.LU_DEL_SEL_MOD.str());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton(LangUnit.LU_DUPLICATE.str());
        this.duplicateButton.setToolTipText(LangUnit.LU_DUP_SEL_MOD.str());
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return buttonPanel;
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap microsThatUseIt;
            Vector cBitsThatUseIt;
            TableCellEditor editor = ModuleDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            int selectedRow = ModuleDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                Assert.That(false, LangUnit.LU_DEL_NONE.str());
                return;
            }
            int actualRow = ((TableSorter)ModuleDialog.this.table.getModel()).modelIndex(selectedRow);
            OOTableModel model = ModuleDialog.this.table.getOOModel();
            Module theModule = (Module)model.getObject(actualRow);
            if ((theModule instanceof Register || theModule instanceof RegisterArray) && (cBitsThatUseIt = ModuleDialog.this.conditionBitFactory.getBitClonesThatUse(theModule)).size() > 0) {
                String message = theModule + LangUnit.LU_USED_BY_BITS.str();
                for (int i = 0; i < cBitsThatUseIt.size(); ++i) {
                    message = message + cBitsThatUseIt.elementAt(i) + (i == cBitsThatUseIt.size() - 1 ? "" : ",  ");
                }
                message = message + LangUnit.LU_DEL_COND_BITS.str();
                JOptionPane.showMessageDialog(ModuleDialog.this, message, LangUnit.LU_DEL_ERR.str(), 0);
                return;
            }
            Module oldModule = ModuleDialog.this.currentFactory.getCurrentFromClone(theModule);
            if (oldModule != null && (microsThatUseIt = ModuleDialog.this.machine.getMicrosThatUse(oldModule)).size() > 0) {
                Object[] options = new String[]{LangUnit.LU_YES_DEL.str(), LangUnit.LU_CANCEL.str()};
                String message = theModule + LangUnit.LU_USED_BY_MICRO.str();
                Set s = microsThatUseIt.keySet();
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    message = message + it.next() + (it.hasNext() ? ",  " : "");
                }
                int response = JOptionPane.showOptionDialog(ModuleDialog.this, message = message + LangUnit.LU_REAL_DEL.str(), LangUnit.LU_INS_WARN.str(), 0, 2, null, options, options[0]);
                if (response == 1) {
                    return;
                }
            }
            model.deleteObject(actualRow);
            int size = model.getRowCount();
            if (size == 0) {
                ModuleDialog.this.deleteButton.setEnabled(false);
                ModuleDialog.this.duplicateButton.setEnabled(false);
            } else if (selectedRow < size) {
                ModuleDialog.this.table.setRowSelectionInterval(selectedRow, selectedRow);
            } else {
                ModuleDialog.this.table.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            }
        }
    }

    class TypesComboListener
    implements ActionListener {
        TypesComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = ModuleDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            JComboBox cb = (JComboBox)e.getSource();
            ModuleFactory newFactory = null;
            newFactory = (ModuleFactory)cb.getSelectedItem();
            if (newFactory == ModuleDialog.this.currentFactory) {
                return;
            }
            Object[] objectList = ModuleDialog.this.table.getOOModel().getAllObjects();
            boolean allOK = ModuleDialog.this.currentFactory.checkValidity(objectList);
            if (!allOK) {
                for (int i = 0; i < ModuleDialog.this.factories.length; ++i) {
                    if (ModuleDialog.this.factories[i] != ModuleDialog.this.currentFactory) continue;
                    cb.setSelectedIndex(i);
                    return;
                }
            }
            ModuleDialog.this.currentFactory.setClones(objectList);
            ModuleDialog.this.currentFactory = newFactory;
            ModuleDialog.this.displayCurrentModules();
        }
    }

    class ModuleTableSelectionListener
    implements ListSelectionListener {
        ModuleTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = ModuleDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                ModuleDialog.this.deleteButton.setEnabled(false);
                ModuleDialog.this.duplicateButton.setEnabled(false);
            } else {
                ModuleDialog.this.deleteButton.setEnabled(true);
                ModuleDialog.this.duplicateButton.setEnabled(true);
            }
        }
    }
}

