/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.FileChannel;
import cpusim.gui.Desktop;
import cpusim.gui.IOOptionsDialog;
import cpusim.util.Assert;
import cpusim.util.CPUSimConstants;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class IOConnectionsCellEditor
extends DefaultCellEditor
implements CPUSimConstants {
    Object currentSelection;

    public IOConnectionsCellEditor(final JDialog parentFrame) {
        super(new JComboBox());
        final JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.addItem(CONSOLE_CHANNEL);
        comboBox.addItem(USER_CHANNEL);
        comboBox.addItem(FILE_CHANNEL);
        HashMap<String, FileChannel> channelTable = ((IOOptionsDialog)parentFrame).getChannelTable();
        HashSet<FileChannel> allFileChannels = new HashSet<FileChannel>();
        for (FileChannel channel : channelTable.values()) {
            if (allFileChannels.contains(channel)) continue;
            comboBox.addItem(channel);
            allFileChannels.add(channel);
        }
        this.currentSelection = null;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                Assert.That(value != CPUSimConstants.FILE_CHANNEL, "FILE_CHANNEL is value in IOConnectionsCellEditor.delegate.setValue()");
                IOConnectionsCellEditor.this.currentSelection = value;
                comboBox.setSelectedItem(value);
            }

            @Override
            public Object getCellEditorValue() {
                File currentDirectory;
                Object o = comboBox.getSelectedItem();
                if (o != CPUSimConstants.FILE_CHANNEL) {
                    IOConnectionsCellEditor.this.currentSelection = o;
                    return o;
                }
                if (IOConnectionsCellEditor.this.currentSelection != CPUSimConstants.USER_CHANNEL & IOConnectionsCellEditor.this.currentSelection != CPUSimConstants.CONSOLE_CHANNEL) {
                    currentDirectory = ((FileChannel)IOConnectionsCellEditor.this.currentSelection).getFile();
                } else {
                    Desktop desktop = (Desktop)parentFrame.getOwner();
                    currentDirectory = desktop.getCurrentTextDirectory();
                }
                FileDialog dialog = new FileDialog((Dialog)parentFrame, "Open input file", 0);
                dialog.setDirectory(currentDirectory.getAbsolutePath());
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName == null) {
                    comboBox.setSelectedItem(IOConnectionsCellEditor.this.currentSelection);
                    return IOConnectionsCellEditor.this.currentSelection;
                }
                String directoryName = dialog.getDirectory();
                File newFile = new File(directoryName + fileName);
                HashMap<String, FileChannel> channelTable = ((IOOptionsDialog)parentFrame).getChannelTable();
                FileChannel channel = channelTable.get(newFile.toString());
                if (channel == null) {
                    channel = new FileChannel(newFile);
                    channelTable.put(newFile.toString(), channel);
                    comboBox.addItem(channel);
                }
                comboBox.setSelectedItem(channel);
                IOConnectionsCellEditor.this.currentSelection = channel;
                return channel;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
        comboBox.addActionListener(this.delegate);
    }
}

