/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.gui.AssemblerWindow;
import cpusim.gui.Desktop;
import cpusim.gui.DialogLayout;
import cpusim.gui.LangUnit;
import cpusim.syntax.JEditTextArea;
import cpusim.syntax.SyntaxDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class FindDialog
extends JDialog {
    private static final char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};
    protected Desktop m_owner;
    protected JTabbedPane m_tb;
    protected Document m_docFind;
    protected Document m_docReplace;
    protected ButtonModel m_modelWord;
    protected ButtonModel m_modelCase;
    protected ButtonModel m_modelUp;
    protected ButtonModel m_modelDown;
    protected JTextField m_txtFind1;
    protected JTextField m_txtFind2;
    protected int m_searchIndex = -1;
    protected boolean m_searchUp = false;
    protected String m_searchData;

    public FindDialog(Desktop owner, int index) {
        super(owner, LangUnit.LU_FIND_REP.str(), false);
        this.m_owner = owner;
        this.m_tb = new JTabbedPane();
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel pc1 = new JPanel(new BorderLayout());
        JPanel pf = new JPanel();
        pf.setLayout(new DialogLayout(20, 5));
        pf.setBorder(new EmptyBorder(8, 5, 8, 0));
        pf.add(new JLabel(LangUnit.LU_FIND_WHAT.str()));
        this.m_txtFind1 = new JTextField();
        this.m_docFind = this.m_txtFind1.getDocument();
        pf.add(this.m_txtFind1);
        pc1.add((Component)pf, "Center");
        JPanel po = new JPanel(new GridLayout(2, 2, 8, 2));
        po.setBorder(new TitledBorder(new EtchedBorder(), LangUnit.LU_FIND_OPT.str()));
        JCheckBox chkWord = new JCheckBox(LangUnit.LU_WHOLE_WORDS.str());
        chkWord.setMnemonic('w');
        this.m_modelWord = chkWord.getModel();
        po.add(chkWord);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rdUp = new JRadioButton(LangUnit.LU_SEARCH_UP.str());
        rdUp.setMnemonic('u');
        this.m_modelUp = rdUp.getModel();
        bg.add(rdUp);
        po.add(rdUp);
        JCheckBox chkCase = new JCheckBox(LangUnit.LU_MATCH_CASE.str());
        chkCase.setMnemonic('c');
        this.m_modelCase = chkCase.getModel();
        po.add(chkCase);
        JRadioButton rdDown = new JRadioButton(LangUnit.LU_SEARCH_DOWN.str(), true);
        rdDown.setMnemonic('d');
        this.m_modelDown = rdDown.getModel();
        bg.add(rdDown);
        po.add(rdDown);
        pc1.add((Component)po, "South");
        p1.add((Component)pc1, "Center");
        JPanel p01 = new JPanel(new FlowLayout());
        JPanel p = new JPanel(new GridLayout(2, 1, 2, 8));
        ActionListener findAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findNext(false, true);
            }
        };
        JButton btFind = new JButton(LangUnit.LU_FIND_NEXT.str());
        btFind.addActionListener(findAction);
        btFind.setMnemonic('f');
        p.add(btFind);
        ActionListener closeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.setVisible(false);
            }
        };
        JButton btClose = new JButton(LangUnit.LU_FIND_CLOSE.str());
        btClose.addActionListener(closeAction);
        btClose.setDefaultCapable(true);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(closeAction, stroke, 2);
        p.add(btClose);
        p01.add(p);
        p1.add((Component)p01, "East");
        this.m_tb.addTab(LangUnit.LU_FIND_FIND.str(), p1);
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel pc2 = new JPanel(new BorderLayout());
        JPanel pc = new JPanel();
        pc.setLayout(new DialogLayout(20, 5));
        pc.setBorder(new EmptyBorder(8, 5, 8, 0));
        pc.add(new JLabel(LangUnit.LU_FIND_WHAT.str()));
        this.m_txtFind2 = new JTextField();
        this.m_txtFind2.setDocument(this.m_docFind);
        pc.add(this.m_txtFind2);
        pc.add(new JLabel(LangUnit.LU_FIND_REP_C.str()));
        JTextField txtReplace = new JTextField();
        this.m_docReplace = txtReplace.getDocument();
        pc.add(txtReplace);
        pc2.add((Component)pc, "Center");
        po = new JPanel(new GridLayout(2, 2, 8, 2));
        po.setBorder(new TitledBorder(new EtchedBorder(), LangUnit.LU_FIND_OPT.str()));
        chkWord = new JCheckBox(LangUnit.LU_WHOLE_WORDS.str());
        chkWord.setMnemonic('w');
        chkWord.setModel(this.m_modelWord);
        po.add(chkWord);
        bg = new ButtonGroup();
        rdUp = new JRadioButton(LangUnit.LU_SEARCH_UP.str());
        rdUp.setMnemonic('u');
        rdUp.setModel(this.m_modelUp);
        bg.add(rdUp);
        po.add(rdUp);
        chkCase = new JCheckBox(LangUnit.LU_MATCH_CASE.str());
        chkCase.setMnemonic('c');
        chkCase.setModel(this.m_modelCase);
        po.add(chkCase);
        rdDown = new JRadioButton(LangUnit.LU_SEARCH_DOWN.str(), true);
        rdDown.setMnemonic('d');
        rdDown.setModel(this.m_modelDown);
        bg.add(rdDown);
        po.add(rdDown);
        pc2.add((Component)po, "South");
        p2.add((Component)pc2, "Center");
        JPanel p02 = new JPanel(new FlowLayout());
        p = new JPanel(new GridLayout(4, 1, 2, 8));
        btFind = new JButton(LangUnit.LU_FIND_NEXT.str());
        btFind.addActionListener(findAction);
        btFind.setMnemonic('f');
        p.add(btFind);
        ActionListener replaceAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.findNext(true, true);
            }
        };
        JButton btReplace = new JButton(LangUnit.LU_FIND_REP_B.str());
        btReplace.addActionListener(replaceAction);
        btReplace.setMnemonic('r');
        p.add(btReplace);
        ActionListener replaceAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int counter = 0;
                while (true) {
                    int result;
                    if ((result = FindDialog.this.findNext(true, false)) < 0) {
                        return;
                    }
                    if (result == 0) break;
                    ++counter;
                }
                JOptionPane.showMessageDialog(FindDialog.this.m_owner, counter + LangUnit.LU_REP_DONE.str(), LangUnit.LU_INFO.str(), 1);
            }
        };
        JButton btReplaceAll = new JButton(LangUnit.LU_REP_ALL.str());
        btReplaceAll.addActionListener(replaceAllAction);
        btReplaceAll.setMnemonic('a');
        p.add(btReplaceAll);
        btClose = new JButton(LangUnit.LU_FIND_CLOSE.str());
        btClose.addActionListener(closeAction);
        btClose.setDefaultCapable(true);
        p.add(btClose);
        p02.add(p);
        p2.add((Component)p02, "East");
        p01.setPreferredSize(p02.getPreferredSize());
        this.m_tb.addTab(LangUnit.LU_REP_TAB.str(), p2);
        this.m_tb.setSelectedIndex(index);
        this.getContentPane().add((Component)this.m_tb, "Center");
        WindowAdapter flst = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindDialog.this.m_searchIndex = -1;
                if (FindDialog.this.m_tb.getSelectedIndex() == 0) {
                    FindDialog.this.m_txtFind1.requestFocus();
                    FindDialog.this.m_txtFind1.selectAll();
                } else {
                    FindDialog.this.m_txtFind2.requestFocus();
                    FindDialog.this.m_txtFind2.selectAll();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                FindDialog.this.m_searchData = null;
            }
        };
        this.addWindowListener(flst);
        this.pack();
        this.setResizable(false);
    }

    public void setSelectedIndex(int index) {
        this.m_tb.setSelectedIndex(index);
    }

    public int findNext(boolean doReplace, boolean showWarnings) {
        int xFinish;
        int xStart;
        AssemblerWindow selectedFrame;
        block24: {
            JInternalFrame internalFrame = this.m_owner.getSelectedFrame();
            if (internalFrame == null || !(internalFrame instanceof AssemblerWindow)) {
                this.displayWarning(LangUnit.LU_WARN_SELECT1.str() + LangUnit.LU_WARN_SELECT2.str());
                return -1;
            }
            selectedFrame = (AssemblerWindow)internalFrame;
            JEditTextArea monitor = selectedFrame.getTextArea();
            int pos = monitor.getCaretPosition();
            if (this.m_modelUp.isSelected() != this.m_searchUp) {
                this.m_searchUp = this.m_modelUp.isSelected();
                this.m_searchIndex = -1;
            }
            if (this.m_searchIndex == -1) {
                try {
                    SyntaxDocument doc = monitor.getSyntaxDocument();
                    this.m_searchData = this.m_searchUp ? doc.getText(0, pos) : doc.getText(pos, doc.getLength() - pos);
                    this.m_searchIndex = pos;
                }
                catch (BadLocationException ex) {
                    this.displayWarning(ex.toString());
                    return -1;
                }
            }
            String key = "";
            try {
                key = this.m_docFind.getText(0, this.m_docFind.getLength());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            if (key.length() == 0) {
                this.displayWarning(LangUnit.LU_ENTER_TARGET.str());
                return -1;
            }
            if (!this.m_modelCase.isSelected()) {
                this.m_searchData = this.m_searchData.toLowerCase();
                key = key.toLowerCase();
            }
            if (this.m_modelWord.isSelected()) {
                for (int k = 0; k < WORD_SEPARATORS.length; ++k) {
                    if (key.indexOf(WORD_SEPARATORS[k]) < 0) continue;
                    this.displayWarning(LangUnit.LU_WARN_ILLEGAL.str() + LangUnit.LU_WARN_CHAR1.str() + WORD_SEPARATORS[k] + LangUnit.LU_WARN_CHAR2.str());
                    return -1;
                }
            }
            xStart = -1;
            xFinish = -1;
            String replacement = "";
            if (doReplace) {
                try {
                    replacement = this.m_docReplace.getText(0, this.m_docReplace.getLength());
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
                String selectedText = monitor.getSelectedText();
                if (!this.m_modelCase.isSelected() && selectedText != null) {
                    selectedText = selectedText.toLowerCase();
                }
                if (key.equals(selectedText)) {
                    xStart = monitor.getSelectionStart();
                    monitor.setSelectedText(replacement);
                    if (this.m_searchUp) {
                        monitor.setCaretPosition(xStart);
                    } else {
                        monitor.setCaretPosition(xStart + replacement.length());
                    }
                    this.m_searchIndex = -1;
                    return this.findNext(false, false);
                }
            }
            while (true) {
                boolean b2;
                if ((xStart = this.m_searchUp ? this.m_searchData.lastIndexOf(key, pos - 1) : this.m_searchData.indexOf(key, pos - this.m_searchIndex)) < 0) {
                    if (showWarnings) {
                        this.displayWarning(LangUnit.LU_NOT_FOUND.str());
                    }
                    return 0;
                }
                xFinish = xStart + key.length();
                if (!this.m_modelWord.isSelected()) break block24;
                boolean s1 = xStart > 0;
                boolean b1 = s1 && !this.isSeparator(this.m_searchData.charAt(xStart - 1));
                boolean s2 = xFinish < this.m_searchData.length();
                boolean bl = b2 = s2 && !this.isSeparator(this.m_searchData.charAt(xFinish));
                if (!b1 && !b2) break block24;
                if (this.m_searchUp && s1) {
                    pos = xStart;
                    continue;
                }
                if (this.m_searchUp || !s2) break;
                pos = xFinish + this.m_searchIndex;
            }
            if (showWarnings) {
                this.displayWarning(LangUnit.LU_NOT_FOUND.str());
            }
            return 0;
        }
        if (!this.m_searchUp) {
            xStart += this.m_searchIndex;
            xFinish += this.m_searchIndex;
        }
        selectedFrame.setSelection(xStart, xFinish, this.m_searchUp);
        return 1;
    }

    private boolean isSeparator(char ch) {
        for (int k = 0; k < WORD_SEPARATORS.length; ++k) {
            if (ch != WORD_SEPARATORS[k]) continue;
            return true;
        }
        return false;
    }

    protected void displayWarning(String message) {
        JOptionPane.showMessageDialog(this.m_owner, message, LangUnit.LU_FIND_WARN.str(), 1);
    }
}

