/*
 * Decompiled with CFR 0.152.
 */
package cpusim.assembler;

import cpusim.Field;
import cpusim.Machine;
import cpusim.assembler.AssemblyException;
import cpusim.assembler.EQU;
import cpusim.assembler.InstructionCall;
import cpusim.assembler.Token;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Normalizer {
    private HashMap<Token, Token> labelHash;
    private Machine machine;

    public Normalizer(Machine machine) {
        this.machine = machine;
        this.labelHash = new HashMap();
    }

    public List<InstructionCall> normalize(List<InstructionCall> parsedInstructions, HashMap<Token, Token> parsedEqus, int startingAddress) {
        this.replaceEqusWithValues(parsedInstructions, parsedEqus);
        this.processLabels(parsedInstructions, startingAddress);
        this.replaceVars(parsedInstructions, startingAddress);
        return parsedInstructions;
    }

    public HashMap getLabelHash() {
        return this.labelHash;
    }

    private void replaceEqusWithValues(List<InstructionCall> instructions, HashMap<Token, Token> equs) {
        Vector globalEqus = this.machine.getEQUs();
        for (int i = 0; i < globalEqus.size(); ++i) {
            String key = ((EQU)globalEqus.elementAt(i)).getName();
            long value = ((EQU)globalEqus.elementAt(i)).getValue();
            Token tokenKey = new Token(null, 2, -1, -1, -1, key, true);
            Token tokenValue = new Token(null, 5, -1, -1, -1, value + "", true);
            if (equs.get(tokenKey) != null) continue;
            equs.put(tokenKey, tokenValue);
        }
        this.fillInEqus(equs);
        this.fillInInstructions(equs, instructions);
    }

    private void fillInEqus(HashMap<Token, Token> equs) {
        for (Token key : equs.keySet()) {
            Token value = equs.get(key);
            while (value.type == 2) {
                value = equs.get(value);
            }
            equs.put(key, value);
        }
    }

    private void fillInInstructions(HashMap equs, List<InstructionCall> instructions) {
        for (InstructionCall instrCall : instructions) {
            List<Token> operands = instrCall.operands;
            for (int i = 0; i < operands.size(); ++i) {
                Token op = operands.get(i);
                if (op.type != 2 || equs.get(op) == null) continue;
                Token tkn = (Token)equs.get(op);
                operands.set(i, new Token(op.filename, tkn.type, op.lineNumber, op.columnNumber, op.offset, tkn.contents, tkn.isLegal));
            }
        }
    }

    private void processLabels(List<InstructionCall> instructions, int startingAddress) {
        this.labelHash.clear();
        int cellSize = this.machine.getCodeStore().getCellSize();
        int currAddressInBits = startingAddress * cellSize;
        for (InstructionCall instrCall : instructions) {
            for (Token label : instrCall.labels) {
                Token labelAddress = new Token(null, 5, -11, 0, 0, currAddressInBits / cellSize + "", true);
                Token clone = new Token(label.filename, label.type, label.lineNumber, label.columnNumber, label.offset, label.contents.substring(0, label.contents.length() - 1), label.isLegal);
                if (this.labelHash.get(clone) != null) {
                    throw new AssemblyException("Error: The label \"" + clone.contents + "\" is used earlier in the program " + "and so cannot be used here", clone);
                }
                this.labelHash.put(clone, labelAddress);
            }
            currAddressInBits += instrCall.getLength();
        }
    }

    private void replaceVars(List<InstructionCall> instructions, int startingAddress) {
        int cellSize = this.machine.getCodeStore().getCellSize();
        int currAddressInBits = startingAddress * cellSize;
        for (InstructionCall instrCall : instructions) {
            List<Token> operands;
            if (instrCall.machineInstruction == null) {
                operands = instrCall.operands;
                for (int i = 0; i < operands.size(); ++i) {
                    Token op = operands.get(i);
                    if (op.type != 2 || this.labelHash.get(op) == null) continue;
                    Token tkn = this.labelHash.get(op);
                    operands.set(i, new Token(op.filename, tkn.type, op.lineNumber, op.columnNumber, op.offset, tkn.contents, tkn.isLegal));
                }
            } else {
                operands = instrCall.operands;
                List<Field> fields = instrCall.machineInstruction.getFields();
                int opIndex = 0;
                for (int i = 1; i < fields.size(); ++i) {
                    Field field = fields.get(i);
                    if (field.getNumBits() == 0) continue;
                    Token op = operands.get(opIndex);
                    if (op.type == 2 && this.labelHash.get(op) != null) {
                        Token opValue = this.labelHash.get(op);
                        String newContents = opValue.contents;
                        if (field.getRelativity() == Field.Relativity.pcRelativePreIncr) {
                            newContents = "" + (Integer.parseInt(newContents) - currAddressInBits / cellSize);
                        } else if (field.getRelativity() == Field.Relativity.pcRelativePostIncr) {
                            newContents = "" + (Integer.parseInt(newContents) - (currAddressInBits + instrCall.getLength()) / cellSize);
                        }
                        for (int j = newContents.length(); j < op.contents.length(); ++j) {
                            newContents = ' ' + newContents;
                        }
                        Token newOpToken = new Token(op.filename, op.type, op.lineNumber, op.columnNumber, op.offset, newContents, true);
                        operands.set(opIndex, newOpToken);
                    } else if (op.type == 2 && field.getValue(op.contents) != null) {
                        String newContents = "" + field.getValue(op.contents).getValue();
                        for (int j = newContents.length(); j < op.contents.length(); ++j) {
                            newContents = '0' + newContents;
                        }
                        Token newOpToken = new Token(op.filename, op.type, op.lineNumber, op.columnNumber, op.offset, newContents, true);
                        operands.set(opIndex, newOpToken);
                    } else if (op.type == 2 && field.getValues().size() != 0) {
                        throw new AssemblyException("Error: The value \"" + op.contents + "\" is not one of the acceptable " + "field values", op);
                    }
                    ++opIndex;
                }
            }
            currAddressInBits += instrCall.getLength();
        }
    }
}

