/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.Field;
import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.microinstruction.Comment;
import cpusim.util.Convert;
import cpusim.util.NamedObject;
import cpusim.util.Validate;
import cpusim.xml.HtmlEncoder;
import java.util.ArrayList;
import java.util.List;

public class MachineInstruction
implements Cloneable,
NamedObject {
    private String name;
    private List<Microinstruction> micros;
    private long opcode;
    private Machine machine;
    private String format;

    public MachineInstruction(String name, long opcode, int[] fieldLengths, Machine machine) {
        this(name, opcode, Convert.lengths2Format(fieldLengths), machine);
    }

    public MachineInstruction(String name, long opcode, String format, Machine machine) {
        this.name = name;
        this.opcode = opcode;
        this.micros = new ArrayList<Microinstruction>();
        this.machine = machine;
        this.setFormat(format);
    }

    public Machine getMachine() {
        return this.machine;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.getFields();
    }

    public int[] getPositiveFieldLengths() {
        List<Field> fields = this.getFields();
        int size = 0;
        for (Field field : fields) {
            if (field.getNumBits() <= 0) continue;
            ++size;
        }
        int[] lengths = new int[size];
        int j = 0;
        for (Field field : fields) {
            if (field.getNumBits() <= 0) continue;
            lengths[j] = field.getNumBits();
            ++j;
        }
        return lengths;
    }

    public boolean[] getPosLenFieldSigns() {
        List<Field> fields = this.getFields();
        int size = 0;
        for (Field field : fields) {
            if (field.getNumBits() <= 0) continue;
            ++size;
        }
        boolean[] isSigned = new boolean[size];
        int j = 0;
        for (Field field : fields) {
            if (field.getNumBits() <= 0) continue;
            isSigned[j] = field.isSigned();
            ++j;
        }
        return isSigned;
    }

    public List<Field> getFields() {
        return Validate.getFieldsFromFormat(this.format, this.machine.getFields());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public List<Microinstruction> getMicros() {
        return this.micros;
    }

    public void setMicros(List<Microinstruction> v) {
        this.micros = v;
    }

    public long getOpcode() {
        return this.opcode;
    }

    public void setOpcode(long newOpcode) {
        this.opcode = newOpcode;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Object clone() {
        MachineInstruction theClone = new MachineInstruction(this.name, this.opcode, this.format, this.machine);
        theClone.setMicros((List)((ArrayList)this.micros).clone());
        return theClone;
    }

    public int length() {
        int length = 0;
        for (Field field : this.getFields()) {
            length += field.getNumBits();
        }
        return length;
    }

    public boolean usesMicro(Microinstruction m) {
        return this.micros.contains(m);
    }

    public void removeMicro(Microinstruction m) {
        boolean didRemoval = this.micros.remove(m);
        if (didRemoval) {
            this.removeMicro(m);
        }
    }

    public boolean usesField(Field f) {
        return this.getFields().contains(f);
    }

    public String getXMLDescription(String indent) {
        String nl = System.getProperty("line.separator");
        String result = indent + "<MachineInstruction name=\"" + HtmlEncoder.sEncode(this.getName()) + "\" opcode=\"" + Long.toHexString(this.getOpcode()) + "\" format=\"" + this.format + "\" >" + nl;
        for (Microinstruction micro : this.micros) {
            result = result + indent + "\t<Microinstruction microRef=\"" + micro.getID() + "\" />" + nl;
        }
        result = result + indent + "</MachineInstruction>";
        return result;
    }

    public String getHTMLDescription() {
        String result = "<TR><TD>" + HtmlEncoder.sEncode(this.getName()) + "</TD><TD>" + Convert.fromLongToHexadecimalString(this.getOpcode(), this.getFields().get(0).getNumBits()) + "</TD><TD>" + this.format;
        result = result + "</TD><TD>";
        for (int i = 0; i < this.getMicros().size(); ++i) {
            Microinstruction micro = this.getMicros().get(i);
            String htmlName = micro.getHTMLName();
            if (micro instanceof Comment) {
                htmlName = "<em><font color=gray>" + htmlName + "</em></font>";
            }
            result = result + htmlName + "<BR>";
        }
        return result + "</TD></TR>";
    }
}

