/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.ErrorWindow;
import acm.util.JTFTools;
import acm.util.MovieClipListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class MovieClip
extends Container {
    private static final int MIN_QUICKTIME_VERSION = 7;
    private static final int CONTROLLER_HEIGHT = 16;
    private static final int DEFAULT_TIME_SCALE = 600;
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 200);
    private Class<?> movieClass;
    private Class<?> movieControllerClass;
    private Class<?> openMovieFileClass;
    private Class<?> qdRectClass;
    private Class<?> qtDataRefClass;
    private Class<?> qtFactoryClass;
    private Class<?> qtFileClass;
    private Class<?> qtSessionClass;
    private Class<?> timeRecordClass;
    private Object controller;
    private Object movie;
    private String movieName;
    private String errorMessage;
    private int version;
    private boolean hasQuickTime;
    private boolean controllerVisible;
    private double clipVolume;
    private double clipRate;
    private static Object lock = new Object();

    public MovieClip(String filename) {
        this(filename, filename);
    }

    public MovieClip(File file) {
        this(file, file.getName());
    }

    public MovieClip(URL url) {
        this(url, JTFTools.getURLSuffix(url.toString()));
    }

    public void play() {
        this.setLooping(false);
        this.startMovie();
    }

    public void loop() {
        this.setLooping(true);
        this.startMovie();
    }

    public synchronized void stop() {
        this.stopMovie();
        this.setLooping(false);
    }

    @Override
    public String getName() {
        return this.movieName;
    }

    @Override
    public void setName(String name) {
        this.movieName = name;
    }

    public int getFrameCount() {
        return this.getQTDuration();
    }

    public double getFrameRate() {
        return this.getQTTimeScale();
    }

    public double getDuration() {
        return (double)this.getFrameCount() / this.getFrameRate();
    }

    public int getFrameIndex() {
        return this.getCurrentTime();
    }

    public void setFrameIndex(int frameIndex) {
        this.setCurrentTime(frameIndex);
    }

    public void rewind() {
        this.setFrameIndex(0);
    }

    public double getVolume() {
        return this.clipVolume;
    }

    public void setVolume(double volume) {
        this.clipVolume = volume;
        this.setControllerVolume(volume);
    }

    public double getPlaybackRate() {
        return this.clipRate;
    }

    public void setPlaybackRate(double rate) {
        this.clipRate = rate;
        if (!this.isStopped()) {
            this.setRate(rate);
        }
    }

    public void enableController() {
        if (this.hasQuickTime) {
            this.setControllerVisible(true);
        }
    }

    public void disableController() {
        if (this.hasQuickTime) {
            this.setControllerVisible(false);
        }
    }

    public boolean isControllerEnabled() {
        return this.controllerVisible;
    }

    public int getControllerHeight() {
        return this.controller == null ? 0 : 16;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.movie == null) {
            return DEFAULT_SIZE;
        }
        try {
            Method getNaturalBoundsRect = this.movieClass.getMethod("getNaturalBoundsRect", new Class[0]);
            Method getWidth = this.qdRectClass.getMethod("getWidth", new Class[0]);
            Method getHeight = this.qdRectClass.getMethod("getHeight", new Class[0]);
            Object rect = getNaturalBoundsRect.invoke(this.movie, new Object[0]);
            int width = (Integer)getWidth.invoke(rect, new Object[0]);
            int height = (Integer)getHeight.invoke(rect, new Object[0]);
            Dimension size = new Dimension(width, height + this.getControllerHeight());
            return size;
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private MovieClip(Object source, String name) {
        this.startQuickTime();
        this.movieName = name;
        this.clipVolume = 1.0;
        this.clipRate = 1.0;
        this.setLayout(new BorderLayout());
        if (this.hasQuickTime) {
            try {
                this.readMovie(source);
            }
            catch (Exception ex) {
                this.add((Component)new ErrorWindow(name, "Can't read movie file"), "Center");
            }
        } else {
            this.add((Component)new ErrorWindow(name, this.errorMessage), "Center");
        }
        this.addComponentListener(new MovieClipListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuickTime() {
        this.hasQuickTime = false;
        try {
            this.movieClass = Class.forName("quicktime.std.movies.Movie");
            this.movieControllerClass = Class.forName("quicktime.std.movies.MovieController");
            this.openMovieFileClass = Class.forName("quicktime.io.OpenMovieFile");
            this.qdRectClass = Class.forName("quicktime.qd.QDRect");
            this.qtDataRefClass = Class.forName("quicktime.std.movies.media.DataRef");
            this.qtFactoryClass = Class.forName("quicktime.app.view.QTFactory");
            this.qtFileClass = Class.forName("quicktime.io.QTFile");
            this.qtSessionClass = Class.forName("quicktime.QTSession");
            this.timeRecordClass = Class.forName("quicktime.std.clocks.TimeRecord");
            Method isInitialized = this.qtSessionClass.getMethod("isInitialized", new Class[0]);
            Object object = lock;
            synchronized (object) {
                if (isInitialized.invoke(null, new Object[0]).equals(Boolean.FALSE)) {
                    Method open = this.qtSessionClass.getMethod("open", new Class[0]);
                    open.invoke(null, new Object[0]);
                }
            }
            Method getMajorVersion = this.qtSessionClass.getMethod("getMajorVersion", new Class[0]);
            this.version = (Integer)getMajorVersion.invoke(null, new Object[0]);
            if (this.version < 7) {
                throw new ErrorException("MovieClip requires QuickTime V7 or later");
            }
            this.hasQuickTime = true;
        }
        catch (Exception ex) {
            this.errorMessage = ex.getMessage();
        }
    }

    private void startMovie() {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Float.TYPE};
            Object[] args = new Object[]{new Float((float)this.clipRate)};
            Method play = this.movieControllerClass.getMethod("play", types);
            play.invoke(this.controller, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void stopMovie() {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Float.TYPE};
            Object[] args = new Object[]{new Float(0.0)};
            Method play = this.movieControllerClass.getMethod("play", types);
            play.invoke(this.controller, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setLooping(boolean flag) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{new Boolean(flag)};
            Method setLooping = this.movieControllerClass.getMethod("setLooping", types);
            setLooping.invoke(this.controller, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void readMovie(Object source) {
        try {
            if (source instanceof String) {
                String name = (String)source;
                if (name.startsWith("http:")) {
                    try {
                        this.movie = this.readMovieFromURL(new URL(name));
                    }
                    catch (MalformedURLException ex) {
                        throw new ErrorException("MovieClip: Malformed URL");
                    }
                } else {
                    this.movie = this.readMovieFromFile(new File(name));
                }
            } else if (source instanceof File) {
                this.movie = this.readMovieFromFile((File)source);
            } else if (source instanceof URL) {
                this.movie = this.readMovieFromURL((URL)source);
            }
            this.controller = this.createController();
            this.controllerVisible = true;
            this.addQTComponent(this.controller);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private Object createController() throws Exception {
        Class[] types = new Class[]{this.movie.getClass()};
        Object[] args = new Object[]{this.movie};
        Constructor<?> movieControllerConstructor = this.movieControllerClass.getConstructor(types);
        return movieControllerConstructor.newInstance(args);
    }

    private void addQTComponent(Object obj) throws Exception {
        if (!(obj instanceof Component)) {
            Class[] types = new Class[]{obj.getClass()};
            Object[] args = new Object[]{obj};
            Method makeQTComponent = this.qtFactoryClass.getMethod("makeQTComponent", types);
            obj = makeQTComponent.invoke(null, args);
            if (!(obj instanceof Component)) {
                Class<?> qtClass = obj.getClass();
                Method asComponent = qtClass.getMethod("asComponent", new Class[0]);
                obj = asComponent.invoke(obj, new Object[0]);
            }
        }
        this.removeAll();
        this.add((Component)obj, "Center");
    }

    private Object readMovieFromFile(File file) {
        try {
            Class[] types1 = new Class[]{Class.forName("java.io.File")};
            Object[] args1 = new Object[]{file};
            Constructor<?> qtFileConstructor = this.qtFileClass.getConstructor(types1);
            Object qtFile = qtFileConstructor.newInstance(args1);
            Class[] types2 = new Class[]{this.qtFileClass};
            Object[] args2 = new Object[]{qtFile};
            Method asRead = this.openMovieFileClass.getMethod("asRead", types2);
            Object openMovieFile = asRead.invoke(null, args2);
            Class[] types3 = new Class[]{this.openMovieFileClass};
            Object[] args3 = new Object[]{openMovieFile};
            Method fromFile = this.movieClass.getMethod("fromFile", types3);
            return fromFile.invoke(null, args3);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private Object readMovieFromURL(URL url) {
        try {
            Class[] types1 = new Class[]{Class.forName("java.lang.String")};
            Object[] args1 = new Object[]{url.toString()};
            Constructor<?> qtDataRefConstructor = this.qtDataRefClass.getConstructor(types1);
            Object qtFile = qtDataRefConstructor.newInstance(args1);
            Class[] types2 = new Class[]{this.qtDataRefClass, Integer.TYPE};
            Object[] args2 = new Object[]{qtFile, new Integer(0)};
            Method fromDataRef = this.movieClass.getMethod("fromDataRef", types2);
            return fromDataRef.invoke(null, args2);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setControllerVisible(boolean flag) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        if (flag != this.controllerVisible) {
            try {
                Class[] types = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{new Boolean(flag)};
                Method setVisible = this.movieControllerClass.getMethod("setVisible", types);
                setVisible.invoke(this.controller, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
            this.controllerVisible = flag;
        }
    }

    private int getCurrentTime() {
        if (!this.hasQuickTime || this.movie == null) {
            return 0;
        }
        try {
            Method getCurrentTime = this.movieControllerClass.getMethod("getCurrentTime", new Class[0]);
            return (Integer)getCurrentTime.invoke(this.controller, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setCurrentTime(int time) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{this.timeRecordClass};
            Object[] args = new Object[]{this.createTimeRecord(time)};
            Method goToTime = this.movieControllerClass.getMethod("goToTime", types);
            goToTime.invoke(this.controller, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setControllerVolume(double volume) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Float.TYPE};
            Object[] args = new Object[]{new Float((float)volume)};
            Method setVolume = this.movieControllerClass.getMethod("setVolume", types);
            setVolume.invoke(this.controller, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private void setRate(double volume) {
        if (!this.hasQuickTime || this.movie == null) {
            return;
        }
        try {
            Class[] types = new Class[]{Float.TYPE};
            Object[] args = new Object[]{new Float((float)volume)};
            Method setRate = this.movieClass.getMethod("setRate", types);
            setRate.invoke(this.movie, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private boolean isStopped() {
        if (!this.hasQuickTime || this.movie == null) {
            return true;
        }
        try {
            Method getPlayRate = this.movieControllerClass.getMethod("getPlayRate", new Class[0]);
            return (double)((Float)getPlayRate.invoke(this.controller, new Object[0])).floatValue() == 0.0;
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private int getQTDuration() {
        if (!this.hasQuickTime || this.movie == null) {
            return 0;
        }
        try {
            Method getDuration = this.movieClass.getMethod("getDuration", new Class[0]);
            return (Integer)getDuration.invoke(this.movie, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private int getQTTimeScale() {
        if (!this.hasQuickTime || this.movie == null) {
            return 600;
        }
        try {
            Method getTimeScale = this.movieClass.getMethod("getTimeScale", new Class[0]);
            return (Integer)getTimeScale.invoke(this.movie, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    private Object createTimeRecord(int time) {
        try {
            Class[] types = new Class[]{Integer.TYPE, Long.TYPE};
            Object[] args = new Object[]{new Integer(this.getQTTimeScale()), new Long(time)};
            Constructor<?> newTimeRecord = this.timeRecordClass.getConstructor(types);
            return newTimeRecord.newInstance(args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }
}

