/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.ConsoleModel;
import acm.io.IOConsole;
import acm.program.ProgramMenuBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.PrintJob;
import java.io.BufferedReader;
import java.io.IOException;

class SystemConsoleModel
implements ConsoleModel {
    private IOConsole console;
    private BufferedReader inputScript;
    private String text = "";

    @Override
    public void setConsole(IOConsole owner) {
        this.console = owner;
    }

    @Override
    public IOConsole getConsole() {
        return this.console;
    }

    @Override
    public void clear() {
    }

    @Override
    public void print(String str, int style) {
        System.out.print(str);
        this.text = this.text + str;
    }

    @Override
    public String readLine() {
        System.out.flush();
        String line = "";
        try {
            while (true) {
                int ch;
                if ((ch = this.inputScript == null ? System.in.read() : this.inputScript.read()) == -1 && line.length() == 0) {
                    try {
                        if (this.inputScript != null) {
                            this.inputScript.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    this.inputScript = null;
                    continue;
                }
                if (ch != -1 && ch != 10) {
                    line = line + (char)ch;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.inputScript != null) {
            this.print(line + "\n", 1);
        }
        return line;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getText(int start, int end2) {
        return this.text.substring(start, end2);
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    public Component getConsoleModel() {
        return null;
    }

    @Override
    public Component getTextPane() {
        return null;
    }

    public void setFont(Font font) {
        if (font != font) {
            // empty if block
        }
    }

    @Override
    public void setInputStyle(int style) {
    }

    @Override
    public void setInputColor(Color color) {
    }

    @Override
    public void setErrorStyle(int style) {
    }

    @Override
    public void setErrorColor(Color color) {
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void selectAll() {
    }

    @Override
    public boolean isPointSelection() {
        return true;
    }

    @Override
    public void print(PrintJob pj) {
    }

    @Override
    public void setInputScript(BufferedReader rd) {
        this.inputScript = rd;
    }

    @Override
    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    @Override
    public Component getConsolePane() {
        return null;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setMenuBar(ProgramMenuBar mbar) {
    }
}

