/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.ArrayList;

class VertexList
implements Serializable {
    private ArrayList<GPoint> vertices = new ArrayList();
    private double cx = 0.0;
    private double cy = 0.0;

    public VertexList() {
    }

    public VertexList(VertexList oldList) {
        this();
        for (int i = 0; i < oldList.vertices.size(); ++i) {
            this.vertices.add(oldList.vertices.get(i));
        }
    }

    public synchronized void addVertex(double x, double y) {
        this.cx = x;
        this.cy = y;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public synchronized void addEdge(double dx, double dy) {
        this.cx += dx;
        this.cy += dy;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public void addArc(double arcWidth, double arcHeight, double start, double sweep) {
        double aspectRatio = arcHeight / arcWidth;
        double rx = arcWidth / 2.0;
        double ry = arcHeight / 2.0;
        double x0 = this.cx - rx * GMath.cosDegrees(start);
        double y0 = this.cy + ry * GMath.sinDegrees(start);
        if (sweep > 359.99) {
            sweep = 360.0;
        }
        if (sweep < -359.99) {
            sweep = -360.0;
        }
        double dt = Math.atan2(1.0, Math.max(arcWidth, arcHeight));
        int nSteps = (int)(GMath.toRadians(Math.abs(sweep)) / dt);
        dt = GMath.toRadians(sweep) / (double)nSteps;
        double theta = GMath.toRadians(start);
        for (int i = 0; i < nSteps; ++i) {
            double px = x0 + rx * Math.cos(theta += dt);
            double py = y0 - rx * Math.sin(theta) * aspectRatio;
            this.addVertex(px, py);
        }
    }

    public synchronized void add(GPoint[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.vertices.add(new GPoint(array[i].getX(), array[i].getY()));
        }
    }

    public synchronized void remove(GPoint vertex) {
        this.vertices.remove(vertex);
    }

    public synchronized void clear() {
        this.vertices.clear();
    }

    public int size() {
        return this.vertices.size();
    }

    public GPoint getCurrentPoint() {
        return this.vertices.size() == 0 ? null : new GPoint(this.cx, this.cy);
    }

    public synchronized GRectangle getBounds(double x0, double y0, double xScale, double yScale, double rotation) {
        int nPoints = this.vertices.size();
        if (nPoints == 0) {
            return new GRectangle();
        }
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        double sinTheta = GMath.sinDegrees(rotation);
        double cosTheta = GMath.cosDegrees(rotation);
        boolean first = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint vertex = this.vertices.get(i);
            double x = x0 + xScale * (cosTheta * vertex.getX() + sinTheta * vertex.getY());
            double y = y0 + yScale * (cosTheta * vertex.getY() - sinTheta * vertex.getX());
            if (first) {
                xMin = x;
                xMax = x;
                yMin = y;
                yMax = y;
                first = false;
                continue;
            }
            xMin = Math.min(xMin, x);
            xMax = Math.max(xMax, x);
            yMin = Math.min(yMin, y);
            yMax = Math.max(yMax, y);
        }
        return new GRectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public synchronized boolean contains(double x, double y) {
        int nPoints = this.vertices.size();
        boolean isContained = false;
        for (int i = 0; i < nPoints; ++i) {
            GPoint v1 = this.vertices.get(i);
            GPoint v2 = this.vertices.get((i + 1) % nPoints);
            if (!(v1.getY() < y && v2.getY() >= y) && (!(v2.getY() < y) || !(v1.getY() >= y)) || !(v1.getX() + (y - v1.getY()) / (v2.getY() - v1.getY()) * (v2.getX() - v1.getX()) < x)) continue;
            isContained = !isContained;
        }
        return isContained;
    }

    public synchronized Polygon createPolygon(double x0, double y0, double xScale, double yScale, double rotation) {
        double sinTheta = GMath.sinDegrees(rotation);
        double cosTheta = GMath.cosDegrees(rotation);
        Polygon poly = new Polygon();
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint vertex = this.vertices.get(i);
            double x = x0 + xScale * (cosTheta * vertex.getX() + sinTheta * vertex.getY());
            double y = y0 + yScale * (cosTheta * vertex.getY() - sinTheta * vertex.getX());
            poly.addPoint(GMath.round(x), GMath.round(y));
        }
        return poly;
    }

    public void recenter() {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        boolean first = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint vertex = this.vertices.get(i);
            if (first) {
                xMin = vertex.getX();
                xMax = vertex.getX();
                yMin = vertex.getY();
                yMax = vertex.getY();
                first = false;
                continue;
            }
            xMin = Math.min(xMin, vertex.getX());
            xMax = Math.max(xMax, vertex.getX());
            yMin = Math.min(yMin, vertex.getY());
            yMax = Math.max(yMax, vertex.getY());
        }
        double xc = (xMin + xMax) / 2.0;
        double yc = (yMin + yMax) / 2.0;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint vertex = this.vertices.get(i);
            vertex.translate(-xc, -yc);
        }
    }
}

