/*
 * Decompiled with CFR 0.152.
 */
package cpusim.util;

import cpusim.BreakException;
import cpusim.gui.AssemblerWindow;
import cpusim.gui.Desktop;
import cpusim.gui.RAMWindow;
import cpusim.module.RAM;
import cpusim.module.Register;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.util.RegisterRAMPair;
import cpusim.util.SourceLine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class HighlightManager
implements PropertyChangeListener {
    private Desktop desktop;
    private int breakAddress;
    private RAM breakRAM;
    private HashMap<RAM, Vector<RegisterRAMPair>> highlightingPairs;

    public HighlightManager(Desktop desktop) {
        this.desktop = desktop;
        this.highlightingPairs = new HashMap();
        this.breakAddress = -1;
        desktop.getMachine().addPropertyChangeListener(this);
    }

    public void setRegisterRAMPairs(Vector<RegisterRAMPair> newPairs) {
        int i;
        this.highlightingPairs.clear();
        Vector rams = this.desktop.getMachine().getModule("rams");
        for (i = 0; i < rams.size(); ++i) {
            this.highlightingPairs.put((RAM)rams.elementAt(i), new Vector());
        }
        for (i = 0; i < newPairs.size(); ++i) {
            RegisterRAMPair pair = newPairs.elementAt(i);
            this.highlightingPairs.get(pair.getRam()).addElement(pair);
        }
    }

    public Vector<RegisterRAMPair> getRegisterRAMPairs() {
        Vector<RegisterRAMPair> result = new Vector<RegisterRAMPair>();
        for (Vector<RegisterRAMPair> pairs : this.highlightingPairs.values()) {
            for (int i = 0; i < pairs.size(); ++i) {
                result.addElement(pairs.elementAt(i));
            }
        }
        return result;
    }

    public void updatePairsForNewRegistersAndRAMs() {
        Vector rams = this.desktop.getMachine().getModule("rams");
        for (Object ram : rams) {
            if (this.highlightingPairs.containsKey(ram)) continue;
            this.highlightingPairs.put((RAM)ram, new Vector());
        }
        HashSet<RAM> keyset = new HashSet<RAM>(this.highlightingPairs.keySet());
        for (RAM ram : keyset) {
            if (rams.contains(ram)) continue;
            this.highlightingPairs.remove(ram);
        }
        Vector allRegisters = this.desktop.getMachine().getAllRegisters();
        for (Vector<RegisterRAMPair> pairs : this.highlightingPairs.values()) {
            for (int i = pairs.size() - 1; i >= 0; --i) {
                RegisterRAMPair pair = pairs.elementAt(i);
                if (allRegisters.contains(pair.getRegister())) continue;
                pairs.remove(pair);
            }
        }
    }

    public void highlightCellsAndText() {
        HashMap<Object, BaseInternalFrame> moduleWindows = this.desktop.getModuleWindows();
        for (Object key : moduleWindows.keySet()) {
            if (!(key instanceof RAM)) continue;
            RAM ram = (RAM)key;
            RAMWindow window = (RAMWindow)moduleWindows.get(ram);
            int[] addresses = this.getAddressesToHighlight(ram);
            window.highlightRows(addresses);
            this.highlightText(ram, addresses);
            if (ram != this.breakRAM) continue;
            window.highlightBreak(this.breakAddress);
            this.breakRAM = null;
        }
    }

    private void highlightText(RAM ram, int[] addresses) {
        for (int i = 0; i < addresses.length; ++i) {
            SourceLine sourceLine = ram.getSourceLine(addresses[i]);
            if (sourceLine == null) continue;
            File file = new File(sourceLine.getFileName());
            if (!file.canRead()) {
                JOptionPane.showMessageDialog(this.desktop.getDesktopPane(), "CPU Sim could not find the file to open and highlight:  " + file.getAbsolutePath(), "IO Error", 0);
                return;
            }
            AssemblerWindow window = this.desktop.openWindowForFile(file);
            window.highlightAndScrollToLine(sourceLine.getLine());
        }
    }

    public int[] getAddressesToHighlight(RAM ram) {
        Vector<RegisterRAMPair> registerRAMPairs = this.highlightingPairs.get(ram);
        int[] addresses = new int[registerRAMPairs.size()];
        for (int i = 0; i < addresses.length; ++i) {
            RegisterRAMPair info = registerRAMPairs.elementAt(i);
            Register register = info.getRegister();
            addresses[i] = info.isDynamic() ? (int)register.getValue() : info.getAddressAtStart();
            if (addresses[i] >= 0 || register.getWidth() >= 32) continue;
            int n = i;
            addresses[n] = addresses[n] + (1 << register.getWidth());
        }
        return addresses;
    }

    public void saveStartOfCycleValues() {
        Collection<Vector<RegisterRAMPair>> c = this.highlightingPairs.values();
        Iterator<Vector<RegisterRAMPair>> i$ = c.iterator();
        while (i$.hasNext()) {
            Vector<RegisterRAMPair> aC;
            Vector<RegisterRAMPair> infos = aC = i$.next();
            for (int i = 0; i < infos.size(); ++i) {
                RegisterRAMPair info = infos.elementAt(i);
                info.setAddressAtStart((int)info.getRegister().getValue());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("start of machine cycle")) {
            this.saveStartOfCycleValues();
        } else if (propertyName.equals("break")) {
            this.breakAddress = ((BreakException)event.getNewValue()).breakAddress;
            this.breakRAM = ((BreakException)event.getNewValue()).breakRAM;
        }
    }
}

