/*
 * Decompiled with CFR 0.152.
 */
package cpusim.scrollabledesktop;

import cpusim.gui.AssemblerWindow;
import cpusim.scrollabledesktop.BaseInternalFrame;
import cpusim.scrollabledesktop.DesktopConstants;
import cpusim.scrollabledesktop.DesktopScrollPane;
import cpusim.util.Assert;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;

public class FramePositioning
implements DesktopConstants {
    private DesktopScrollPane desktopScrollpane;
    private boolean autoTile;

    public FramePositioning(DesktopScrollPane desktopScrollpane) {
        this.desktopScrollpane = desktopScrollpane;
    }

    public void setAutoTile(boolean autoTile) {
        this.autoTile = autoTile;
        if (autoTile) {
            this.tileInternalFrames();
        } else {
            this.cascadeInternalFrames();
        }
    }

    public boolean getAutoTile() {
        return this.autoTile;
    }

    public void cascadeInternalFrames() {
        JInternalFrame[] frames = this.desktopScrollpane.getAllFrames();
        int frameCounter = 0;
        for (int i = frames.length - 1; i >= 0; --i) {
            BaseInternalFrame f = (BaseInternalFrame)frames[i];
            if (f.isIcon() || !(f instanceof AssemblerWindow)) continue;
            f.setSize(f.getInitialDimensions());
            f.setLocation(this.cascadeInternalFrame(f, frameCounter++));
            f.moveToFront();
            if (i != 0) continue;
            try {
                f.setSelected(true);
                continue;
            }
            catch (PropertyVetoException e) {
                Assert.That(false, "Setting frame " + f.getTitle() + " selected during" + " cascading threw PropertyVetoException.");
            }
        }
    }

    public Point cascadeInternalFrame(JInternalFrame f) {
        return this.cascadeInternalFrame(f, this.desktopScrollpane.getNumberOfFrames());
    }

    private Point cascadeInternalFrame(JInternalFrame f, int count) {
        int numFramesHigh;
        int windowWidth = f.getWidth();
        int windowHeight = f.getHeight();
        Rectangle viewP = this.desktopScrollpane.getViewport().getViewRect();
        int numFramesWide = (viewP.width - windowWidth) / 30;
        if (numFramesWide < 1) {
            numFramesWide = 1;
        }
        if ((numFramesHigh = (viewP.height - windowHeight) / 30) < 1) {
            numFramesHigh = 1;
        }
        int xLoc = viewP.x + 30 * (count - (numFramesWide - 1) * (count / numFramesWide));
        int yLoc = viewP.y + 30 * (count - numFramesHigh * (count / numFramesHigh));
        return new Point(xLoc, yLoc);
    }

    public void tileInternalFrames() {
        Rectangle viewP = this.desktopScrollpane.getViewport().getViewRect();
        int totalNonIconFrames = 0;
        JInternalFrame[] frames = this.desktopScrollpane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon() || !(frames[i] instanceof AssemblerWindow)) continue;
            ++totalNonIconFrames;
        }
        int curCol = 0;
        int curRow = 0;
        int i = 0;
        if (totalNonIconFrames > 0) {
            int numCols = (int)Math.sqrt(totalNonIconFrames);
            int frameWidth = viewP.width / numCols;
            for (curCol = 0; curCol < numCols; ++curCol) {
                int numRows = totalNonIconFrames / numCols;
                int remainder = totalNonIconFrames % numCols;
                if (numCols - curCol <= remainder) {
                    ++numRows;
                }
                int frameHeight = viewP.height / numRows;
                for (curRow = 0; curRow < numRows; ++curRow) {
                    while (frames[i].isIcon() || !(frames[i] instanceof AssemblerWindow)) {
                        ++i;
                    }
                    frames[i].setBounds(curCol * frameWidth, curRow * frameHeight, frameWidth, frameHeight);
                    frames[i].moveToFront();
                    ++i;
                }
            }
        }
    }
}

