/*
 * Decompiled with CFR 0.152.
 */
package cpusim.scrollabledesktop;

import cpusim.scrollabledesktop.BaseToggleButton;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public class BaseInternalFrame
extends JInternalFrame {
    private JToggleButton associatedButton;
    private JRadioButtonMenuItem associatedMenuButton;
    private boolean isClosable;
    private int initialWidth;
    private int initialHeight;

    public BaseInternalFrame(String title, ImageIcon icon, JPanel frameContents, boolean isClosable) {
        super(title, true, isClosable, true, true);
        this.isClosable = isClosable;
        this.setBackground(Color.white);
        this.setForeground(Color.blue);
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.getContentPane().add(frameContents);
        this.pack();
        this.saveSize();
        this.setVisible(true);
    }

    private void saveSize() {
        this.initialWidth = this.getWidth();
        this.initialHeight = this.getHeight();
    }

    public BaseInternalFrame() {
        this.saveSize();
    }

    public BaseInternalFrame(String title) {
        super(title);
        this.saveSize();
    }

    public BaseInternalFrame(String title, boolean resizable) {
        super(title, resizable);
        this.saveSize();
    }

    public BaseInternalFrame(String title, boolean resizable, boolean closable) {
        super(title, resizable, closable);
        this.isClosable = closable;
        this.saveSize();
    }

    public BaseInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        super(title, resizable, closable, maximizable);
        this.isClosable = closable;
        this.saveSize();
    }

    public BaseInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.isClosable = closable;
        this.saveSize();
    }

    @Override
    public void setTitle(String newTitle) {
        super.setTitle(newTitle);
        if (this.associatedMenuButton != null) {
            String oldMenuText = this.associatedMenuButton.getText();
            String number = oldMenuText.substring(0, oldMenuText.indexOf(" "));
            this.associatedMenuButton.setText(number + " " + newTitle);
        }
    }

    public void setAssociatedMenuButton(JRadioButtonMenuItem associatedMenuButton) {
        this.associatedMenuButton = associatedMenuButton;
    }

    public JRadioButtonMenuItem getAssociatedMenuButton() {
        return this.associatedMenuButton;
    }

    public void setAssociatedButton(JToggleButton associatedButton) {
        this.associatedButton = associatedButton;
    }

    public JToggleButton getAssociatedButton() {
        return this.associatedButton;
    }

    public Dimension getInitialDimensions() {
        return new Dimension(this.initialWidth, this.initialHeight);
    }

    @Override
    public String toString() {
        return "BaseInternalFrame: " + this.getTitle();
    }

    public void selectFrameAndAssociatedButtons() {
        if (this.associatedButton != null) {
            this.associatedButton.setSelected(true);
            ((BaseToggleButton)this.associatedButton).flagContentsChanged(false);
        }
        if (this.associatedMenuButton != null) {
            this.associatedMenuButton.setSelected(true);
        }
        try {
            this.setSelected(true);
            this.setIcon(false);
        }
        catch (PropertyVetoException pve) {
            System.out.println("PropertyVetoException thrown: " + pve.getMessage());
        }
        this.setVisible(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.initialWidth == 0 && this.initialHeight == 0) {
            this.saveSize();
        }
    }
}

