/*
 * Decompiled with CFR 0.152.
 */
package cpusim.module;

import cpusim.Machine;
import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.microinstruction.CpusimSet;
import cpusim.microinstruction.Logical;
import cpusim.microinstruction.Shift;
import cpusim.microinstruction.Test;
import cpusim.microinstruction.TransferAtoR;
import cpusim.microinstruction.TransferRtoA;
import cpusim.microinstruction.TransferRtoR;
import cpusim.module.Register;
import cpusim.module.RegisterArray;
import cpusim.util.Assert;
import cpusim.util.Factory;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public abstract class ModuleFactory
implements Factory {
    Machine machine;
    HashMap assocList;
    Module[] clones;
    JDialog parentFrame;

    public ModuleFactory(Machine machine) {
        this.machine = machine;
        this.assocList = new HashMap();
        this.clones = null;
        this.parentFrame = null;
    }

    public void setParentFrame(JDialog parent) {
        this.parentFrame = parent;
    }

    public Module getNewModule(String newName) {
        Module prototype = this.getPrototype();
        Module clone = (Module)prototype.clone();
        clone.setName(newName);
        return clone;
    }

    public Module[] getClones() {
        Assert.That(this.clones != null, "clones == null in ModuleFactory.getClones()");
        return this.clones;
    }

    public Module getCurrentFromClone(Module clone) {
        return (Module)this.assocList.get(clone);
    }

    @Override
    public String getHelpPageID() {
        return "hardwarea";
    }

    public abstract void setClones(Object[] var1);

    public abstract HashMap getCellEditors();

    @Override
    public abstract boolean checkValidity(Object[] var1);

    public abstract String toString();

    public abstract String[] getProperties();

    @Override
    public Object[] createClones() {
        Vector currentModules = this.getCurrentModules();
        Object[] clones = (Module[])Array.newInstance(this.getModuleClass(), currentModules.size());
        for (int i = 0; i < currentModules.size(); ++i) {
            Module clone = (Module)((Module)currentModules.elementAt(i)).clone();
            clones[i] = clone;
            this.assocList.put(clone, currentModules.elementAt(i));
        }
        return clones;
    }

    public Vector createNewModulesList(Module[] list) {
        Vector<Module> newModules = new Vector<Module>();
        for (int i = 0; i < list.length; ++i) {
            Module module = list[i];
            Module oldModule = (Module)this.assocList.get(module);
            if (oldModule != null) {
                module.copyDataTo(oldModule);
                newModules.addElement(oldModule);
                continue;
            }
            newModules.addElement(module);
        }
        return newModules;
    }

    boolean allNamesAreUnique(Module[] list) {
        for (int i = 0; i < list.length - 1; ++i) {
            for (int j = i + 1; j < list.length; ++j) {
                if (!list[i].getName().equals(list[j].getName())) continue;
                this.displayError("The name \"" + list[i].getName() + "\" is used more than once.\nAll names must " + "be unique.");
                return false;
            }
        }
        return true;
    }

    boolean someNamesAreEmpty(Module[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getName().equals("")) continue;
            this.displayError("One or more names are empty.\nAll names must have at least one character.");
            return true;
        }
        return false;
    }

    public boolean registerWidthsAreOkayForMicros(HashMap h) {
        int i;
        HashMap<Object, Integer> newWidths = new HashMap<Object, Integer>();
        for (i = 0; i < this.machine.getModule("registers").size(); ++i) {
            newWidths.put(this.machine.getModule("registers").elementAt(i), ((Register)this.machine.getModule("registers").elementAt(i)).getWidth());
        }
        for (i = 0; i < this.machine.getModule("registerArrays").size(); ++i) {
            RegisterArray array = (RegisterArray)this.machine.getModule("registerArrays").elementAt(i);
            for (int j = 0; j < array.getLength(); ++j) {
                newWidths.put(array.registers()[j], array.registers()[j].getWidth());
            }
        }
        newWidths.putAll(h);
        Vector<Microinstruction> shifts = this.machine.getMicros("shift");
        for (int i2 = 0; i2 < shifts.size(); ++i2) {
            int destWidth;
            Shift shift = (Shift)shifts.elementAt(i2);
            Register source = shift.getSource();
            int sourceWidth = (Integer)newWidths.get(source);
            if (sourceWidth == (destWidth = ((Integer)newWidths.get(shift.getDestination())).intValue())) continue;
            this.displayError("The new width " + sourceWidth + " of register " + shift.getSource() + "\nand new width " + destWidth + " of register " + shift.getDestination() + "\ncauses microinstruction " + shift + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> logicals = this.machine.getMicros("logical");
        for (int i3 = 0; i3 < logicals.size(); ++i3) {
            Logical logical = (Logical)logicals.elementAt(i3);
            int source1Width = (Integer)newWidths.get(logical.getSource1());
            int source2Width = (Integer)newWidths.get(logical.getSource2());
            int destWidth = (Integer)newWidths.get(logical.getDestination());
            if (source1Width == destWidth && source2Width == destWidth) continue;
            this.displayError("The new width " + source1Width + " of register " + logical.getSource1() + "\nand new width " + source2Width + " of register " + logical.getSource2() + "\nand new width " + destWidth + " of register " + logical.getDestination() + "\ncauses microinstruction " + logical + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> sets = this.machine.getMicros("set");
        for (int i4 = 0; i4 < sets.size(); ++i4) {
            CpusimSet set = (CpusimSet)sets.elementAt(i4);
            int newWidth = (Integer)newWidths.get(set.getRegister());
            if (newWidth >= set.getStart() + set.getNumBits()) continue;
            this.displayError("The new width " + newWidth + " of register " + set.getRegister() + "\ncauses microinstruction " + set + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> tests = this.machine.getMicros("test");
        for (int i5 = 0; i5 < tests.size(); ++i5) {
            Test test = (Test)tests.elementAt(i5);
            int newWidth = (Integer)newWidths.get(test.getRegister());
            if (newWidth >= test.getStart() + test.getNumBits()) continue;
            this.displayError("The new width " + newWidth + " of register " + test.getRegister() + "\ncauses microinstruction " + test + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> transferRtoRs = this.machine.getMicros("transferRtoR");
        for (int i6 = 0; i6 < transferRtoRs.size(); ++i6) {
            TransferRtoR t = (TransferRtoR)transferRtoRs.elementAt(i6);
            int sourceWidth = (Integer)newWidths.get(t.getSource());
            int destWidth = (Integer)newWidths.get(t.getDest());
            if (sourceWidth >= t.getSrcStartBit() + t.getNumBits() && destWidth >= t.getDestStartBit() + t.getNumBits()) continue;
            this.displayError("The new width " + sourceWidth + " of register " + t.getSource() + "\nor new width " + destWidth + " of register " + t.getDest() + "\ncauses microinstruction " + t + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> transferRtoAs = this.machine.getMicros("transferRtoA");
        for (int i7 = 0; i7 < transferRtoAs.size(); ++i7) {
            TransferRtoA t = (TransferRtoA)transferRtoAs.elementAt(i7);
            int sourceWidth = (Integer)newWidths.get(t.getSource());
            if (sourceWidth < t.getSrcStartBit() + t.getNumBits()) {
                this.displayError("The new width " + sourceWidth + " of register " + t.getSource() + "\ncauses microinstruction " + t + " to be invalid.");
                return false;
            }
            int indexWidth = (Integer)newWidths.get(t.getIndex());
            if (indexWidth >= t.getIndexStart() + t.getIndexNumBits()) continue;
            this.displayError("The new width " + indexWidth + " of register " + t.getIndex() + "\ncauses microinstruction " + t + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> transferAtoRs = this.machine.getMicros("transferAtoR");
        for (int i8 = 0; i8 < transferAtoRs.size(); ++i8) {
            TransferAtoR t = (TransferAtoR)transferAtoRs.elementAt(i8);
            int destWidth = (Integer)newWidths.get(t.getDest());
            if (destWidth < t.getDestStartBit() + t.getNumBits()) {
                this.displayError("The new width " + destWidth + " of register " + t.getDest() + "\ncauses microinstruction " + t + " to be invalid.");
                return false;
            }
            int indexWidth = (Integer)newWidths.get(t.getIndex());
            if (indexWidth >= t.getIndexStart() + t.getIndexNumBits()) continue;
            this.displayError("The new width " + indexWidth + " of register " + t.getIndex() + "\ncauses microinstruction " + t + " to be invalid.");
            return false;
        }
        return true;
    }

    public boolean registerArrayWidthsAreOkayForTransferMicros(RegisterArray[] arrays) {
        int i;
        HashMap<Object, Integer> newWidths = new HashMap<Object, Integer>();
        for (i = 0; i < this.machine.getModule("registerArrays").size(); ++i) {
            newWidths.put(this.machine.getModule("registerArrays").elementAt(i), new Integer(((RegisterArray)this.machine.getModule("registerArrays").elementAt(i)).getWidth()));
        }
        for (i = 0; i < arrays.length; ++i) {
            RegisterArray oldArray = (RegisterArray)this.getCurrentFromClone(arrays[i]);
            if (oldArray == null) continue;
            newWidths.put(oldArray, new Integer(arrays[i].getWidth()));
        }
        Vector<Microinstruction> transferAtoRs = this.machine.getMicros("transferAtoR");
        for (int i2 = 0; i2 < transferAtoRs.size(); ++i2) {
            TransferAtoR t = (TransferAtoR)transferAtoRs.elementAt(i2);
            int sourceWidth = (Integer)newWidths.get(t.getSource());
            if (sourceWidth >= t.getSrcStartBit() + t.getNumBits()) continue;
            this.displayError("The new width " + sourceWidth + " of register array " + t.getSource() + "\ncauses microinstruction " + t + " to be invalid.");
            return false;
        }
        Vector<Microinstruction> transferRtoAs = this.machine.getMicros("transferRtoA");
        for (int i3 = 0; i3 < transferRtoAs.size(); ++i3) {
            TransferRtoA t = (TransferRtoA)transferRtoAs.elementAt(i3);
            int destWidth = (Integer)newWidths.get(t.getDest());
            if (destWidth >= t.getDestStartBit() + t.getNumBits()) continue;
            this.displayError("The new width " + destWidth + " of register array " + t.getDest() + "\ncauses microinstruction " + t + " to be invalid.");
            return false;
        }
        return true;
    }

    @Override
    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }

    @Override
    public Object getNewObject(String name) {
        return this.getNewModule(name);
    }

    abstract Module getPrototype();

    abstract Class getModuleClass();

    public abstract Vector getCurrentModules();

    public abstract boolean newModulesAreAllowed();
}

