/*
 * Decompiled with CFR 0.152.
 */
package cpusim.microinstruction;

import cpusim.Microinstruction;
import cpusim.Module;
import cpusim.module.ControlUnit;
import cpusim.module.Register;
import cpusim.util.Assert;

public class Test
extends Microinstruction {
    public static final String[] COMPARISONS = new String[]{"EQ", "NE", "LT", "GT", "LE", "GE"};
    private Register register;
    private int start;
    private int numBits;
    private String comparison;
    private long value;
    private int omission;
    private ControlUnit controlUnit;

    public Test(String name, Register register, int start, int numBits, String comparison, long value, int omission, ControlUnit controlUnit) {
        super(name);
        this.register = register;
        this.start = start;
        this.numBits = numBits;
        this.comparison = comparison;
        this.value = value;
        this.omission = omission;
        this.controlUnit = controlUnit;
    }

    public void setRegister(Register newRegister) {
        this.register = newRegister;
    }

    public void setStart(int lb) {
        this.start = lb;
    }

    public void setNumBits(int num) {
        this.numBits = num;
    }

    public void setComparison(String newComparison) {
        this.comparison = newComparison;
    }

    public void setValue(long newVal) {
        this.value = newVal;
    }

    public void setOmission(int newOmission) {
        this.omission = newOmission;
    }

    public Register getRegister() {
        return this.register;
    }

    public int getStart() {
        return this.start;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public String getComparison() {
        return this.comparison;
    }

    public long getValue() {
        return this.value;
    }

    public int getOmission() {
        return this.omission;
    }

    @Override
    public Object clone() {
        return new Test(this.getName(), this.getRegister(), this.getStart(), this.getNumBits(), this.getComparison(), this.getValue(), this.getOmission(), this.controlUnit);
    }

    @Override
    public void copyDataTo(Microinstruction newMicro) {
        Assert.That(newMicro instanceof Test, "Passed non-Test to Test.copyDataTo()");
        Test newTest = (Test)newMicro;
        newTest.setName(this.getName());
        newTest.setRegister(this.getRegister());
        newTest.setStart(this.getStart());
        newTest.setNumBits(this.getNumBits());
        newTest.setComparison(this.getComparison());
        newTest.setValue(this.getValue());
        newTest.setOmission(this.getOmission());
        newTest.controlUnit = this.controlUnit;
    }

    @Override
    public boolean uses(Module m) {
        return m == this.register;
    }

    @Override
    public void execute() {
        long signedSegment;
        long registerValue = this.register.getValue();
        int width = this.register.getWidth();
        long unsignedSegment = signedSegment = registerValue << 64 - width + this.start >> 64 - this.numBits;
        if (this.numBits < 64 && signedSegment < 0L) {
            unsignedSegment = signedSegment + (1L << this.numBits);
        }
        if (this.comparison.equals("EQ")) {
            if (signedSegment == this.value || unsignedSegment == this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        } else if (this.comparison.equals("NE")) {
            if (signedSegment != this.value && unsignedSegment != this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        } else if (this.comparison.equals("LT")) {
            if (signedSegment < this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        } else if (this.comparison.equals("GT")) {
            if (signedSegment > this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        } else if (this.comparison.equals("LE")) {
            if (signedSegment <= this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        } else {
            Assert.That(this.comparison.equals("GE"), "Illegal comparison in Test microinstruction " + this.getName());
            if (signedSegment >= this.value) {
                this.controlUnit.incrementMicroIndex(this.omission);
            }
        }
    }

    @Override
    public String getXMLDescription() {
        return "<Test name=\"" + this.getHTMLName() + "\" register=\"" + this.getRegister().getID() + "\" start=\"" + this.getStart() + "\" numBits=\"" + this.getNumBits() + "\" comparison=\"" + this.getComparison() + "\" value=\"" + this.getValue() + "\" omission=\"" + this.getOmission() + "\" id=\"" + this.getID() + "\" />";
    }

    @Override
    public String getHTMLDescription() {
        return "<TR><TD>" + this.getHTMLName() + "</TD><TD>" + this.getRegister().getHTMLName() + "</TD><TD>" + this.getStart() + "</TD><TD>" + this.getNumBits() + "</TD><TD>" + this.getComparison() + "</TD><TD>" + this.getValue() + "</TD><TD>" + this.getOmission() + "</TD></TR>";
    }
}

