/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.assembler.PunctChar;
import cpusim.gui.AssemblyPrefsPanel;
import cpusim.gui.Desktop;
import cpusim.gui.FontData;
import cpusim.gui.FontPrefsPanel;
import cpusim.gui.HelpDialog;
import cpusim.gui.LangUnit;
import cpusim.util.CPUSimConstants;
import cpusim.util.Validate;
import cpusim.util.ValidationException;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class PreferencesDialog
extends JDialog
implements CPUSimConstants {
    private Desktop desktop;
    private FontPrefsPanel fontPrefsPanel;
    private PunctChar[] chars;
    private PunctChar[] clones;

    public PreferencesDialog(Desktop desktop) {
        super(desktop, LangUnit.LU_PREF_DESK.str(), false);
        this.desktop = desktop;
        this.getContentPane().setLayout(new BorderLayout());
        this.chars = desktop.getMachine().getPunctChars();
        this.clones = new PunctChar[this.chars.length];
        for (int i = 0; i < this.chars.length; ++i) {
            this.clones[i] = new PunctChar(this.chars[i].getChar(), this.chars[i].getUse());
        }
        JTabbedPane tabPane = new JTabbedPane();
        this.fontPrefsPanel = new FontPrefsPanel(desktop);
        tabPane.add(LangUnit.LU_FONT.str(), this.fontPrefsPanel);
        AssemblyPrefsPanel assemblyPrefsPanel = new AssemblyPrefsPanel(this.clones);
        tabPane.add(LangUnit.LU_PUNCTUATION.str(), assemblyPrefsPanel);
        this.getContentPane().add("Center", tabPane);
        this.getContentPane().add("South", this.createBottomButtonPanel());
    }

    private void displayError(String s) {
        JOptionPane.showMessageDialog(this, s, LangUnit.LU_ERR.str(), 0);
    }

    protected JPanel createBottomButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 10));
        JButton applyButton = new JButton(LangUnit.LU_APPLY.str());
        JButton closeButton = new JButton(LangUnit.LU_CLOSE.str());
        JButton helpButton = new JButton();
        if (MAC_OS_X) {
            helpButton.putClientProperty("JButton.buttonType", "help");
        } else {
            helpButton.setText(LangUnit.LU_HELP_B.str());
        }
        applyButton.addActionListener(new ApplyButtonListener());
        CloseButtonListener closeListener = new CloseButtonListener();
        closeButton.addActionListener(closeListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(closeListener, stroke, 2);
        helpButton.addActionListener(new HelpButtonListener());
        buttonPanel.add(helpButton);
        JPanel invisiblePanel = new JPanel();
        buttonPanel.add(invisiblePanel);
        buttonPanel.add(applyButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected class HelpButtonListener
    implements ActionListener {
        protected HelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpDialog d = new HelpDialog(PreferencesDialog.this);
            d.showPage("preferencesDialog");
        }
    }

    protected class CloseButtonListener
    implements ActionListener {
        protected CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.setVisible(false);
        }
    }

    protected class ApplyButtonListener
    implements ActionListener {
        protected ApplyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FontData newData = PreferencesDialog.this.fontPrefsPanel.getFontData();
            PreferencesDialog.this.desktop.setFontData(newData);
            PreferencesDialog.this.desktop.setTheme(PreferencesDialog.this.fontPrefsPanel.getTextWindowThemeChoice());
            try {
                Validate.punctIsValid(PreferencesDialog.this.clones);
            }
            catch (ValidationException exc) {
                PreferencesDialog.this.displayError(exc.getMessage());
                return;
            }
            PreferencesDialog.this.desktop.getMachine().setPunctChars(PreferencesDialog.this.clones);
            PreferencesDialog.this.desktop.updateSyntaxOfAllDocuments();
            PreferencesDialog.this.desktop.updateAssembler();
        }
    }
}

