/*
 * Decompiled with CFR 0.152.
 */
package cpusim.gui;

import cpusim.Field;
import cpusim.Machine;
import cpusim.MachineInstrFactory;
import cpusim.MachineInstruction;
import cpusim.Microinstruction;
import cpusim.gui.ActionListenerFor;
import cpusim.gui.Desktop;
import cpusim.gui.EditDialog;
import cpusim.gui.LangUnit;
import cpusim.gui.MicroDialog;
import cpusim.microinstruction.Comment;
import cpusim.microinstruction.End;
import cpusim.util.Assert;
import cpusim.util.DraggableEditableJList;
import cpusim.util.ExtendedJTable;
import cpusim.util.Factory;
import cpusim.util.HexTableCellEditor;
import cpusim.util.HexTableCellRenderer;
import cpusim.util.MicroListCellEditor;
import cpusim.util.MicroListModel;
import cpusim.util.OOTableModel;
import cpusim.util.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class InstructionDialog
extends EditDialog {
    private MachineInstrFactory currentFactory;
    private JButton deleteMicroButton;
    private JButton insertMicroButton;
    private List<Field> originalFields;
    private boolean fieldsChanged = false;
    private MachineInstruction selectedInstr;
    private DraggableEditableJList microList;
    private JTree microTree;
    private Dimension preferredSize;
    private JLabel currentMicrosLabel;
    private Desktop desktop;

    public InstructionDialog(Frame parent, Machine machine) {
        super(parent, LangUnit.LU_EDIT_INS.str(), true);
        Container contentPane = this.getContentPane();
        this.desktop = (Desktop)parent;
        this.machine = machine;
        this.selectedInstr = null;
        this.currentFactory = new MachineInstrFactory(machine, this);
        JSplitPane splitPane = new JSplitPane(1, this.createInstrPanel(), this.createMicroListPanel());
        int sizeFactor = splitPane.getMinimumDividerLocation();
        this.preferredSize = new Dimension(sizeFactor * 3, sizeFactor * 2);
        splitPane.setDividerLocation(sizeFactor);
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.createBottomButtonPanel(), "South");
        this.originalFields = new ArrayList<Field>();
        for (Field field : machine.getFields()) {
            this.originalFields.add(field.clone());
        }
        this.cancelButton.removeActionListener(this.cancelButton.getActionListeners()[0]);
        CancelListener cancelListener = new CancelListener();
        this.cancelButton.addActionListener(cancelListener);
        this.addWindowListener(cancelListener);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(cancelListener, stroke, 2);
    }

    @Override
    protected Factory getCurrentFactory() {
        return this.currentFactory;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    protected void updateMachine() {
        Object[] objList = this.getObjectList();
        Vector<MachineInstruction> instrList = new Vector<MachineInstruction>();
        for (Object obj : objList) {
            instrList.addElement((MachineInstruction)obj);
        }
        this.machine.setInstructions(instrList);
        this.desktop.updateSyntaxOfAllDocuments();
    }

    public void fieldsChanged(boolean b) {
        this.fieldsChanged = b;
    }

    private ExtendedJTable createInstrJTable() {
        ExtendedJTable instrTable = null;
        OOTableModel model = null;
        Object[] clones = (MachineInstruction[])this.currentFactory.createClones();
        HashMap<String, HexTableCellEditor> editors = new HashMap<String, HexTableCellEditor>();
        editors.put("opcode", new HexTableCellEditor());
        HashMap<String, HexTableCellRenderer> renderers = new HashMap<String, HexTableCellRenderer>();
        renderers.put("opcode", new HexTableCellRenderer());
        try {
            model = new OOTableModel(clones);
            model.setColumns(new String[]{"name", "opcode", "format"});
        }
        catch (IntrospectionException e) {
            Assert.That(false, LangUnit.LU_BEANS_EXCEPT.str());
        }
        instrTable = new ExtendedJTable((TableModel)model, editors, renderers);
        instrTable.setSelectionMode(0);
        instrTable.getSelectionModel().addListSelectionListener(new InstrTableSelectionListener());
        instrTable.getModel().addTableModelListener(new TableModelListenerForCurrentMicrosLabel());
        return instrTable;
    }

    private JPanel createListAddButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel buttonPanel = new JPanel();
        this.newButton = new JButton(LangUnit.LU_NEW.str());
        this.newButton.setToolTipText(LangUnit.LU_CREATE_INS.str());
        this.newButton.addActionListener(new EditDialog.NewButtonListener());
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(LangUnit.LU_DELETE.str());
        this.deleteButton.setToolTipText(LangUnit.LU_DEL_INS.str());
        this.deleteButton.addActionListener(new DeleteButtonListener());
        buttonPanel.add(this.deleteButton);
        this.duplicateButton = new JButton(LangUnit.LU_DUPLICATE.str());
        this.duplicateButton.setToolTipText(LangUnit.LU_INS_DUP_INS.str());
        this.duplicateButton.addActionListener(new EditDialog.DuplicateButtonListener());
        buttonPanel.add(this.duplicateButton);
        JButton fieldButton = new JButton(LangUnit.LU_EDIT_FIELDS.str());
        fieldButton.setToolTipText(LangUnit.LU_EDIT_FIELDS_TXT.str());
        fieldButton.addActionListener(new ActionListenerFor.Fields(this));
        JPanel fieldButtonPanel = new JPanel();
        fieldButtonPanel.add(fieldButton);
        panel.add(buttonPanel);
        panel.add(fieldButtonPanel);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        return panel;
    }

    private JPanel createMicroListPanel() {
        JPanel microListPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        microListPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        microListPanel.setLayout(gridbag);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        this.currentMicrosLabel = new JLabel(LangUnit.LU_IMPLEMENT.str());
        leftPanel.add(this.currentMicrosLabel);
        this.currentMicrosLabel.setAlignmentX(0.5f);
        this.microList = new DraggableEditableJList((ListModel)new MicroListModel());
        this.microList.addMouseListener(new MicroListDoubleClickListener());
        this.microList.setListCellEditor(new MicroListCellEditor(new JTextField()));
        leftPanel.add(new JScrollPane(this.microList));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 1;
        microListPanel.add((Component)leftPanel, c);
        this.microList.addKeyListener(new MicroListKeyListener());
        this.microList.addListSelectionListener(new MicroListSelectionListener());
        this.microList.getModel().addListDataListener(new MicroListDataListener());
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new GridLayout(6, 1, 0, 5));
        middlePanel.add(new JPanel());
        middlePanel.add(new JPanel());
        JPanel deletePanel = new JPanel();
        this.deleteMicroButton = new JButton(LangUnit.LU_DIR_DEL.str());
        this.deleteMicroButton.addActionListener(new DeleteMicroButtonListener());
        deletePanel.add(this.deleteMicroButton);
        JPanel insertPanel = new JPanel();
        this.insertMicroButton = new JButton(LangUnit.LU_DIR_INSERT.str());
        this.insertMicroButton.addActionListener(new InsertMicroButtonListener());
        insertPanel.add(this.insertMicroButton);
        middlePanel.add(insertPanel);
        middlePanel.add(deletePanel);
        c.gridx = 1;
        c.weightx = 0.0;
        microListPanel.add((Component)middlePanel, c);
        this.deleteMicroButton.setEnabled(false);
        this.insertMicroButton.setEnabled(false);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JLabel rightTopLabel = new JLabel(LangUnit.LU_EXIST_MICRO.str());
        rightPanel.add(rightTopLabel);
        rightTopLabel.setAlignmentX(0.5f);
        this.createMicroTree();
        rightPanel.add(new JScrollPane(this.microTree));
        rightPanel.setPreferredSize(new Dimension(160, 1000));
        rightPanel.setMinimumSize(new Dimension(160, 1000));
        c.gridx = 2;
        c.weightx = 0.2;
        microListPanel.add((Component)rightPanel, c);
        this.microTree.getSelectionModel().setSelectionMode(1);
        this.microTree.addTreeSelectionListener(new MicroTreeSelectionListener());
        this.microTree.addMouseListener(new MicroTreeDoubleClickListener());
        return microListPanel;
    }

    private void createMicroTree() {
        int i;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Existing micros", true);
        DefaultMutableTreeNode microType = new DefaultMutableTreeNode("TransferRtoR", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("transferRtoR").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferRtoR").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("TransferAtoR", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("transferAtoR").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferAtoR").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("TransferRtoA", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("transferRtoA").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("transferRtoA").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Set", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("set").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("set").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Test", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("test").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("test").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Increment", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("increment").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("increment").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Arithmetic", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("arithmetic").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("arithmetic").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Shift", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("shift").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("shift").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Branch", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("branch").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("branch").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Logical", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("logical").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("logical").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("Decode", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("decode").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("decode").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("MemoryAccess", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("memoryAccess").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("memoryAccess").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("IO", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("io").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("io").elementAt(i), false));
        }
        microType = new DefaultMutableTreeNode("SetCondBit", true);
        top.add(microType);
        for (i = 0; i < this.machine.getMicros("setCondBit").size(); ++i) {
            microType.add(new DefaultMutableTreeNode(this.machine.getMicros("setCondBit").elementAt(i), false));
        }
        top.add(new DefaultMutableTreeNode(this.machine.getEnd(), false));
        top.add(new DefaultMutableTreeNode(new Comment(), false));
        this.microTree = new JTree(top, true);
        this.microTree.setRootVisible(false);
        this.microTree.setShowsRootHandles(true);
    }

    private JPanel createInstrPanel() {
        JPanel instrPanel = new JPanel();
        instrPanel.setLayout(new BorderLayout());
        instrPanel.add((Component)this.createListAddButtonPanel(), "South");
        this.table = this.createInstrJTable();
        Dimension tablePreferredSize = this.table.getPreferredScrollableViewportSize();
        instrPanel.setPreferredSize(new Dimension(tablePreferredSize.width, 120));
        instrPanel.add((Component)new JScrollPane(this.table), "Center");
        instrPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        TableColumn formatColumn = this.table.getColumnModel().getColumn(2);
        formatColumn.setPreferredWidth((int)this.table.getPreferredScrollableViewportSize().getWidth() / 2);
        return instrPanel;
    }

    private class MicroListDoubleClickListener
    extends MouseAdapter {
        private MicroListDoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            Object[] instrClones;
            int count = e.getClickCount();
            if (count != 2) {
                return;
            }
            int index = InstructionDialog.this.microList.getSelectedIndex();
            if (index == -1) {
                return;
            }
            Microinstruction micro = (Microinstruction)InstructionDialog.this.microList.getSelectedValue();
            if (micro instanceof End || micro instanceof Comment) {
                return;
            }
            Class<?> selectedType = micro.getClass();
            MicroDialog d = new MicroDialog((Dialog)InstructionDialog.this, InstructionDialog.this.machine, selectedType);
            d.pack();
            Rectangle bounds = InstructionDialog.this.desktop.getDialogSizePrefs("MicroDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = d.getOwner().getSize();
                int x = Math.max((d2.width - (d1.width + 50)) / 2, 0);
                int y = Math.max((d2.height - (d1.height + 30)) / 2, 0);
                bounds = new Rectangle(x + d.getOwner().getX(), y + d.getOwner().getY(), d1.width + 50, d1.height + 30);
                d.setBounds(bounds);
            }
            d.setVisible(true);
            if (!InstructionDialog.this.machine.isDirty()) {
                return;
            }
            for (Object o : instrClones = InstructionDialog.this.getObjectList()) {
                MachineInstruction instrClone = (MachineInstruction)o;
                List<Microinstruction> micros = instrClone.getMicros();
                int j = 0;
                while (j < micros.size()) {
                    Microinstruction micro1 = micros.get(j);
                    if (!(micro1 instanceof Comment) && !InstructionDialog.this.machine.contains(micro1)) {
                        instrClone.removeMicro(micro1);
                        j = 0;
                        continue;
                    }
                    ++j;
                }
            }
            if (InstructionDialog.this.selectedInstr != null) {
                DefaultListModel model = (DefaultListModel)InstructionDialog.this.microList.getModel();
                model.clear();
                List<Microinstruction> micros = InstructionDialog.this.selectedInstr.getMicros();
                for (Microinstruction micro2 : micros) {
                    model.addElement(micro2);
                }
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)InstructionDialog.this.microTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> enumer = root.children();
            while (enumer.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumer.nextElement();
                node.removeAllChildren();
            }
            DefaultMutableTreeNode microType = (DefaultMutableTreeNode)root.getChildAt(0);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferRtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferRtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(1);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferAtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferAtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(2);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferRtoA").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferRtoA").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(3);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("set").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("set").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(4);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("test").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("test").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(5);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("increment").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("increment").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(6);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("arithmetic").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("arithmetic").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(7);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("shift").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("shift").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(8);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("branch").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("branch").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(9);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("logical").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("logical").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(10);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("decode").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("decode").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(11);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("memoryAccess").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("memoryAccess").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(12);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("io").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("io").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(13);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("setCondBit").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("setCondBit").elementAt(i), false));
            }
            treeModel.nodeStructureChanged(root);
        }
    }

    private class MicroTreeDoubleClickListener
    extends MouseAdapter {
        private MicroTreeDoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            Object[] instrClones;
            int count = e.getClickCount();
            if (count != 2) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)InstructionDialog.this.microTree.getLastSelectedPathComponent();
            Class selectedType = Microinstruction.class;
            if (node != null) {
                Object nodeInfo = node.getUserObject();
                if (nodeInfo instanceof Microinstruction) {
                    selectedType = nodeInfo.getClass();
                    if (selectedType == End.class || selectedType == Comment.class) {
                        return;
                    }
                } else {
                    try {
                        if ("Set".equals(nodeInfo)) {
                            nodeInfo = "CpusimSet";
                        }
                        selectedType = Class.forName("cpusim.microinstruction." + nodeInfo);
                    }
                    catch (ClassNotFoundException cnfe) {
                        Assert.That(false, LangUnit.LU_CLASS_NOT_FOUND.str());
                    }
                }
            }
            if (InstructionDialog.this.machine.getModule("registers").size() == 0) {
                JOptionPane.showMessageDialog(InstructionDialog.this, LangUnit.LU_NEED_REG_CREATE.str(), LangUnit.LU_ERR.str(), 0);
                return;
            }
            MicroDialog d = new MicroDialog((Dialog)InstructionDialog.this, InstructionDialog.this.machine, selectedType);
            d.pack();
            Rectangle bounds = InstructionDialog.this.desktop.getDialogSizePrefs("MicroDialog");
            if (bounds.x > 0) {
                d.setBounds(bounds);
            } else {
                Dimension d1 = d.getSize();
                Dimension d2 = d.getOwner().getSize();
                int x = Math.max((d2.width - (d1.width + 50)) / 2, 0);
                int y = Math.max((d2.height - (d1.height + 30)) / 2, 0);
                bounds = new Rectangle(x + d.getOwner().getX(), y + d.getOwner().getY(), d1.width + 50, d1.height + 30);
                d.setBounds(bounds);
            }
            d.setVisible(true);
            if (!InstructionDialog.this.machine.isDirty()) {
                return;
            }
            for (Object o : instrClones = InstructionDialog.this.getObjectList()) {
                MachineInstruction instrClone = (MachineInstruction)o;
                List<Microinstruction> micros = instrClone.getMicros();
                int j = 0;
                while (j < micros.size()) {
                    Microinstruction micro = micros.get(j);
                    if (!(micro instanceof Comment) && !InstructionDialog.this.machine.contains(micro)) {
                        instrClone.removeMicro(micro);
                        j = 0;
                        continue;
                    }
                    ++j;
                }
            }
            if (InstructionDialog.this.selectedInstr != null) {
                DefaultListModel model = (DefaultListModel)InstructionDialog.this.microList.getModel();
                model.clear();
                List<Microinstruction> micros = InstructionDialog.this.selectedInstr.getMicros();
                for (Microinstruction micro : micros) {
                    model.addElement(micro);
                }
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)InstructionDialog.this.microTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            Enumeration<TreeNode> enumer = root.children();
            while (enumer.hasMoreElements()) {
                node = (DefaultMutableTreeNode)enumer.nextElement();
                node.removeAllChildren();
            }
            DefaultMutableTreeNode microType = (DefaultMutableTreeNode)root.getChildAt(0);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferRtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferRtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(1);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferAtoR").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferAtoR").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(2);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("transferRtoA").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("transferRtoA").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(3);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("set").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("set").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(4);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("test").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("test").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(5);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("increment").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("increment").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(6);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("arithmetic").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("arithmetic").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(7);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("shift").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("shift").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(8);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("branch").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("branch").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(9);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("logical").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("logical").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(10);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("decode").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("decode").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(11);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("memoryAccess").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("memoryAccess").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(12);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("io").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("io").elementAt(i), false));
            }
            microType = (DefaultMutableTreeNode)root.getChildAt(13);
            for (i = 0; i < InstructionDialog.this.machine.getMicros("setCondBit").size(); ++i) {
                microType.add(new DefaultMutableTreeNode(InstructionDialog.this.machine.getMicros("setCondBit").elementAt(i), false));
            }
            treeModel.nodeStructureChanged(root);
        }
    }

    class MicroListDataListener
    implements ListDataListener {
        MicroListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ListModel model = InstructionDialog.this.microList.getModel();
            for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                InstructionDialog.this.selectedInstr.getMicros().set(i, (Microinstruction)model.getElementAt(i));
            }
        }
    }

    class TableModelListenerForCurrentMicrosLabel
    implements TableModelListener {
        TableModelListenerForCurrentMicrosLabel() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (InstructionDialog.this.selectedInstr == null) {
                InstructionDialog.this.currentMicrosLabel.setText("implementation");
            } else {
                InstructionDialog.this.currentMicrosLabel.setText(InstructionDialog.this.selectedInstr.getName() + LangUnit.LU_OWN_IMPLEMENT.str());
            }
        }
    }

    class MicroListKeyListener
    implements KeyListener {
        MicroListKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 || keyCode == 127) {
                int[] selected = InstructionDialog.this.microList.getSelectedIndices();
                DefaultListModel model = (DefaultListModel)InstructionDialog.this.microList.getModel();
                for (int i = 0; i < selected.length; ++i) {
                    model.removeElementAt(selected[i] - i);
                }
                if (model.size() == 0) {
                    InstructionDialog.this.deleteMicroButton.setEnabled(false);
                } else {
                    InstructionDialog.this.microList.setSelectedIndex(0);
                }
            }
        }
    }

    class DeleteMicroButtonListener
    implements ActionListener {
        DeleteMicroButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = InstructionDialog.this.microList.getSelectedIndices();
            DefaultListModel model = (DefaultListModel)InstructionDialog.this.microList.getModel();
            for (int i = 0; i < selected.length; ++i) {
                model.removeElementAt(selected[i] - i);
                InstructionDialog.this.selectedInstr.getMicros().remove(selected[i] - i);
            }
            if (model.size() == 0) {
                InstructionDialog.this.deleteMicroButton.setEnabled(false);
            } else if (selected.length == 1 && model.size() > selected[0]) {
                InstructionDialog.this.microList.setSelectedIndex(selected[0]);
            } else if (selected.length == 1) {
                InstructionDialog.this.microList.setSelectedIndex(selected[0] - 1);
            } else {
                InstructionDialog.this.microList.setSelectedIndex(0);
            }
        }
    }

    class InsertMicroButtonListener
    implements ActionListener {
        InsertMicroButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Assert.That(InstructionDialog.this.selectedInstr != null, LangUnit.LU_SEL_INS_NULL.str() + LangUnit.LU_INS_ACT_CALL.str());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)InstructionDialog.this.microTree.getLastSelectedPathComponent();
            Assert.That(node != null, LangUnit.LU_NODE_NULL.str() + "actionPerformed()");
            Object nodeInfo = node.getUserObject();
            Assert.That(node.isLeaf(), LangUnit.LU_NOT_LEAF.str() + "InsertMicroButtonListener.actionPerformed()");
            Microinstruction selectedMicro = (Microinstruction)nodeInfo;
            if (selectedMicro instanceof Comment) {
                selectedMicro = new Comment();
            }
            int[] selected = InstructionDialog.this.microList.getSelectedIndices();
            DefaultListModel model = (DefaultListModel)InstructionDialog.this.microList.getModel();
            if (selected.length > 0) {
                model.insertElementAt(selectedMicro, selected[0]);
                InstructionDialog.this.selectedInstr.getMicros().add(selected[0], selectedMicro);
            } else {
                model.addElement(selectedMicro);
                InstructionDialog.this.selectedInstr.getMicros().add(selectedMicro);
            }
        }
    }

    class MicroTreeSelectionListener
    implements TreeSelectionListener {
        MicroTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)InstructionDialog.this.microTree.getLastSelectedPathComponent();
            if (node == null || node.getAllowsChildren() || InstructionDialog.this.selectedInstr == null) {
                InstructionDialog.this.insertMicroButton.setEnabled(false);
            } else {
                InstructionDialog.this.insertMicroButton.setEnabled(true);
            }
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor editor = InstructionDialog.this.table.getCellEditor();
            if (editor != null && !editor.stopCellEditing()) {
                return;
            }
            if (InstructionDialog.this.table.getSelectedRow() == -1) {
                Assert.That(false, LangUnit.LU_DEL_NONE.str());
                return;
            }
            InstructionDialog.this.table.deleteSelectedRowWithoutWarning();
            InstructionDialog.this.deleteButton.setEnabled(false);
            InstructionDialog.this.duplicateButton.setEnabled(false);
            InstructionDialog.this.deleteMicroButton.setEnabled(false);
            InstructionDialog.this.insertMicroButton.setEnabled(false);
        }
    }

    class MicroListSelectionListener
    implements ListSelectionListener {
        MicroListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = InstructionDialog.this.microList.getSelectedIndex();
            InstructionDialog.this.deleteMicroButton.setEnabled(selectedIndex != -1);
        }
    }

    class InstrTableSelectionListener
    implements ListSelectionListener {
        InstrTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = InstructionDialog.this.table.getSelectedRow();
            if (selectedRow == -1) {
                InstructionDialog.this.selectedInstr = null;
                InstructionDialog.this.deleteButton.setEnabled(false);
                InstructionDialog.this.duplicateButton.setEnabled(false);
                InstructionDialog.this.deleteMicroButton.setEnabled(false);
                InstructionDialog.this.insertMicroButton.setEnabled(false);
                DefaultListModel listModel = (DefaultListModel)InstructionDialog.this.microList.getModel();
                listModel.clear();
                InstructionDialog.this.currentMicrosLabel.setText(LangUnit.LU_IMPLEMENT.str());
            } else {
                int actualRow = ((TableSorter)InstructionDialog.this.table.getModel()).modelIndex(selectedRow);
                OOTableModel model = InstructionDialog.this.table.getOOModel();
                InstructionDialog.this.selectedInstr = (MachineInstruction)model.getObject(actualRow);
                DefaultListModel listModel = (DefaultListModel)InstructionDialog.this.microList.getModel();
                listModel.clear();
                List<Microinstruction> micros = InstructionDialog.this.selectedInstr.getMicros();
                for (Microinstruction micro : micros) {
                    listModel.addElement(micro);
                }
                InstructionDialog.this.currentMicrosLabel.setText(InstructionDialog.this.selectedInstr.getName() + LangUnit.LU_OWN_IMPLEMENT.str());
                InstructionDialog.this.deleteButton.setEnabled(true);
                InstructionDialog.this.duplicateButton.setEnabled(true);
                InstructionDialog.this.deleteMicroButton.setEnabled(false);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)InstructionDialog.this.microTree.getLastSelectedPathComponent();
                if (node == null || !node.isLeaf() || InstructionDialog.this.selectedInstr == null) {
                    InstructionDialog.this.insertMicroButton.setEnabled(false);
                } else {
                    InstructionDialog.this.insertMicroButton.setEnabled(true);
                }
            }
        }
    }

    public class CancelListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void windowClosing(WindowEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InstructionDialog.this.fieldsChanged) {
                Object[] options = new String[]{LangUnit.LU_YES_CANCEL.str(), LangUnit.LU_KEEP_OPEN.str()};
                String message = LangUnit.LU_SURE_CANCEL.str() + LangUnit.LU_CHANGE_MADE.str() + LangUnit.LU_CANCEL_TOO.str();
                int response = JOptionPane.showOptionDialog(InstructionDialog.this, message, LangUnit.LU_INS_WARN.str(), 0, 2, null, options, options[0]);
                if (response == 1) {
                    return;
                }
            }
            InstructionDialog.this.machine.setFields(InstructionDialog.this.originalFields);
            InstructionDialog.this.desktop.updateDialogSizePrefs(InstructionDialog.this.getClass().getSimpleName(), InstructionDialog.this.getX(), InstructionDialog.this.getY(), InstructionDialog.this.getWidth(), InstructionDialog.this.getHeight());
            InstructionDialog.this.setVisible(false);
        }
    }
}

