/*
 * Decompiled with CFR 0.152.
 */
package cpusim;

import cpusim.FieldValue;
import cpusim.util.NamedObject;
import cpusim.xml.HtmlEncoder;
import java.util.ArrayList;
import java.util.List;

public class Field
implements NamedObject {
    private String name;
    private Type type;
    private int numBits;
    private Relativity relativity;
    private List<FieldValue> values;
    private int defaultValue;
    private boolean signed;
    private int offset;
    private String ID;

    public Field() {
        this("?");
    }

    public Field(String name) {
        this(name, Type.required, 0, Relativity.absolute, new ArrayList<FieldValue>(), 0, true, -1);
    }

    public Field(String name, Type type, int length, Relativity relativity, List<FieldValue> values, int defaultValue, boolean signed, int offset) {
        this.name = name;
        this.type = type;
        this.numBits = length;
        this.relativity = relativity;
        this.values = values;
        this.defaultValue = defaultValue;
        this.signed = signed;
        this.offset = offset;
        String s = super.toString();
        int index = s.indexOf(64);
        this.ID = index == -1 ? s : s.substring(7, index) + s.substring(index + 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public void setNumBits(int numBits) {
        this.numBits = numBits;
    }

    public Relativity getRelativity() {
        return this.relativity;
    }

    public void setRelativity(Relativity relativity) {
        this.relativity = relativity;
    }

    public List<FieldValue> getValues() {
        return this.values;
    }

    public void setValues(List<FieldValue> values) {
        this.values = values;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getID() {
        return this.ID;
    }

    public void copyDataTo(Field newField) {
        newField.setName(this.getName());
        newField.setType(this.getType());
        newField.setRelativity(this.getRelativity());
        newField.setNumBits(this.getNumBits());
        newField.setDefaultValue(this.getDefaultValue());
        newField.setSigned(this.isSigned());
        newField.setValues(this.getValues());
        newField.setOffset(this.getOffset());
    }

    public FieldValue getValue(String name) {
        for (FieldValue value : this.getValues()) {
            if (!value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Field clone() {
        Field c = new Field();
        c.setName(this.name);
        c.setType(this.type);
        c.setNumBits(this.numBits);
        c.setRelativity(this.relativity);
        c.setValues(this.values);
        c.setDefaultValue(this.defaultValue);
        c.setSigned(this.signed);
        c.setOffset(this.offset);
        return c;
    }

    public String getXMLDescription(String indent) {
        String nl = System.getProperty("line.separator");
        String result = indent + "<Field name=\"" + HtmlEncoder.sEncode(this.name) + "\" type=\"" + (Object)((Object)this.type) + "\" numBits=\"" + this.numBits + "\" relativity=\"" + (Object)((Object)this.relativity) + "\" signed=\"" + this.signed + "\" offset=\"" + this.offset + "\" defaultValue=\"" + this.defaultValue + "\" id=\"" + this.getID() + "\">" + nl;
        for (FieldValue value : this.values) {
            result = result + indent + "\t" + value.getXMLDescription() + nl;
        }
        result = result + indent + "</Field>";
        return result;
    }

    public String getHTMLDescription() {
        String result = "<TR><TD>" + HtmlEncoder.sEncode(this.name) + "</TD><TD>" + (Object)((Object)this.type) + "</TD><TD>" + this.numBits + "</TD><TD>" + (Object)((Object)this.relativity) + "</TD><TD>" + this.signed + "</TD><TD>" + this.defaultValue + "</TD><TD>";
        if (this.values.size() == 0) {
            result = result + HtmlEncoder.sEncode("<any>");
        }
        for (FieldValue fieldValue : this.values) {
            result = result + HtmlEncoder.sEncode(fieldValue.getName() + "=") + fieldValue.getValue() + "<BR>";
        }
        return result + "</TD></TR>";
    }

    public static enum Relativity {
        absolute,
        pcRelativePreIncr,
        pcRelativePostIncr;

    }

    public static enum Type {
        required,
        optional,
        ignored;

    }
}

