/*
 * Decompiled with CFR 0.152.
 */
package apple.dts.samplecode.osxadapter;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter
implements InvocationHandler {
    protected Object targetObject;
    protected Method targetMethod;
    protected String proxySignature;
    static Object macOSXApplication;

    public static void setQuitHandler(Object target, Method quitHandler) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        OSXAdapter.setHandler(new OSXAdapter("handleQuit", target, quitHandler));
    }

    public static void setAboutHandler(Object target, Method aboutHandler) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException, ClassNotFoundException {
        boolean enableAboutMenu;
        boolean bl = enableAboutMenu = target != null && aboutHandler != null;
        if (enableAboutMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handleAbout", target, aboutHandler));
        }
        Method enableAboutMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
        enableAboutMethod.invoke(macOSXApplication, enableAboutMenu);
    }

    public static void setPreferencesHandler(Object target, Method prefsHandler) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        boolean enablePrefsMenu;
        boolean bl = enablePrefsMenu = target != null && prefsHandler != null;
        if (enablePrefsMenu) {
            OSXAdapter.setHandler(new OSXAdapter("handlePreferences", target, prefsHandler));
        }
        Method enablePrefsMethod = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
        enablePrefsMethod.invoke(macOSXApplication, enablePrefsMenu);
    }

    public static void setFileHandler(Object target, Method fileHandler) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        OSXAdapter.setHandler(new OSXAdapter("handleOpenFile", target, fileHandler){

            @Override
            public boolean callTarget(Object appleEvent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                if (appleEvent != null) {
                    Method getFilenameMethod = appleEvent.getClass().getDeclaredMethod("getFilename", null);
                    String filename = (String)getFilenameMethod.invoke(appleEvent, (Object[])null);
                    this.targetMethod.invoke(this.targetObject, filename);
                }
                return true;
            }
        });
    }

    public static void setHandler(OSXAdapter adapter) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        if (macOSXApplication == null) {
            macOSXApplication = applicationClass.getConstructor(null).newInstance(null);
        }
        Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
        Object osxAdapterProxy = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{applicationListenerClass}, (InvocationHandler)adapter);
        addListenerMethod.invoke(macOSXApplication, osxAdapterProxy);
    }

    protected OSXAdapter(String proxySignature, Object target, Method handler) {
        this.proxySignature = proxySignature;
        this.targetObject = target;
        this.targetMethod = handler;
    }

    public boolean callTarget(Object appleEvent) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object result = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (result == null) {
            return true;
        }
        return Boolean.valueOf(result.toString());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isCorrectMethod(method, args)) {
            boolean handled = this.callTarget(args[0]);
            this.setApplicationEventHandled(args[0], handled);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] args) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && args.length == 1;
    }

    protected void setApplicationEventHandled(Object event, boolean handled) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (event != null) {
            Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
            setHandledMethod.invoke(event, handled);
        }
    }
}

