/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.Program;
import acm.util.ErrorException;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;

class DefaultActionListener
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Component comp = (Component)e.getSource();
        Program program = this.findProgram(comp);
        if (program != null && DefaultActionListener.countActionListeners(comp) > 1) {
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.ActionListener")};
                Object[] args = new Object[]{this};
                Method removeActionListener = comp.getClass().getMethod("removeActionListener", types);
                removeActionListener.invoke((Object)comp, args);
                return;
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
        String message = "No ActionListener is attached";
        if (comp instanceof Button) {
            message = message + " to button " + ((Button)comp).getLabel();
        } else {
            try {
                Method getText = comp.getClass().getMethod("getText", new Class[0]);
                message = message + " to button " + (String)getText.invoke((Object)comp, new Object[0]);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
        if (program == null) {
            throw new ErrorException(message);
        }
        program.getDialog().showErrorMessage(message);
    }

    protected static int countActionListeners(Component comp) {
        try {
            Method getActionListeners = comp.getClass().getMethod("getActionListeners", new Class[0]);
            ActionListener[] listeners = (ActionListener[])getActionListeners.invoke((Object)comp, new Object[0]);
            return listeners.length;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private Program findProgram(Component comp) {
        if (comp instanceof Program) {
            return (Program)comp;
        }
        if (comp != null) {
            return this.findProgram(comp.getParent());
        }
        return null;
    }
}

