/* cplay2.cmd */

'@echo off'
call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if (initcode = 'ERROR') then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP
   
arg rate file

/* Re-arrange Arguments if necessary*/
if datatype(rate)=char then do
   temp = rate
   rate = file
   file = temp
end

/* File Selection Box*/
if (file = '') then do
   button = VFileBox('CPLAY- Audio File Player', '*.wav', name)
   file = name.vstring  
   if ((file='')|(button='CANCEL')) then signal cleanup
end

/* Radio Box for sampling rate selection*/
if (rate = '') then do
   list.0 = 4
   list.1  = '8'
   list.2  = '11.25'
   list.3  = '22.5'
   list.4  = '43.4'
   list.vstring = list.3          /* default selection */
   button= VRadioBox( ' Select Sampling Rate (kHz) ', list, 3)
   rate = list.vstring
   if button='CANCEL' then signal cleanup
end

/* Zip file handling */
zipflag=0
if ((RIGHT(file,3) = 'ZIP') | (RIGHT(file,3)='zip')) then do
   prompt.0 =4 
   prompt.1 = ' You have Selected a Zip Archive! '
   prompt.2 = ' '
   prompt.3 = '   Please enter the filename of the '
   prompt.4 = ' sound file contained in the archive. '
   'unzip -v' file
   button = VInputBox('Zip Archive Handler', prompt, 20, 3)
   if button='CANCEL' then signal cleanup
   zipflag=1
   'unzip 'file  prompt.vstring
   file = prompt.vstring
end

/* Player Section */
if ((FILESPEC("drive",file)='A:')|(FILESPEC("drive",file)='B:')) then do
   'copy' file 'cplay1.wav'
   'sox cplay1.wav -r'rate*1000' cplay2.wav'
end
else 'sox' file '-r'rate*1000' cplay2.wav'
'player -r'rate*1000' cplay2.wav' 
'erase cplay?.wav' 
if zipflag=1 then 'erase 'file

/* Signal completion */
'player -r11000 %sounds%\sttng\progcomp.wav'

CLEANUP:
   do
      call VExit
      exit
   end 
exit


